package in.oliveboard.sdk.utils;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.TreeMap;

import in.oliveboard.sdk.log.DebugMonitor;
import in.oliveboard.sdk.presenter.model.FilterModel;
import in.oliveboard.sdk.presenter.model.PauseTestInfo;
import in.oliveboard.sdk.presenter.model.SectionKeyValue;
import in.oliveboard.sdk.presenter.model.SubmitTestInfo;
import in.oliveboard.sdk.presenter.model.TestAppModel;
import in.oliveboard.sdk.presenter.model.TestDialogInfo;


public class FilterQuestions {

    private static FilterQuestions filterquestions;

    public static synchronized FilterQuestions getInstance() {
        if (filterquestions == null) {
            filterquestions = new FilterQuestions();
        }
        return filterquestions;
    }

    public ArrayList<FilterModel> filter(ArrayList<TestAppModel> questionDataList, int filterOption) {
        ArrayList<TestAppModel> filterArrayList = new ArrayList<>();
        ArrayList<FilterModel>filterData=new ArrayList<>();
        TreeMap<Integer,SectionKeyValue> sectionSort =new TreeMap<>();
        int sectionSortKey=0;
        int newIndex=0;
        String oldKey="";

        if (filterOption == Constants.TYPE_ALL) {
            filterData.add(new FilterModel(questionDataList,null));
            return filterData;

        } else if (filterOption == Constants.TYPE_ATTEMPTED) {
            for (int i = 0; i < questionDataList.size(); i++) {

                if (questionDataList.get(i).getSelectionOption() != -1) {

                    if(!(oldKey.equals(questionDataList.get(i).getKey()))) {

                        oldKey=questionDataList.get(i).getKey();
                        DebugMonitor.getLogger().d("key taken",oldKey+" position "+sectionSortKey);
                        sectionSort.put(sectionSortKey, new SectionKeyValue(questionDataList.get(i).getKey(), newIndex));
                        sectionSortKey++;

                    }

                    newIndex++;
                    filterArrayList.add(questionDataList.get(i));
                }
            }
        } else if (filterOption == Constants.TYPE_UNATTEMPTED) {
            for (int i = 0; i < questionDataList.size(); i++) {

                if (questionDataList.get(i).getSelectionOption() == -1) {
                    filterArrayList.add(questionDataList.get(i));
                    if(!(oldKey.equals(questionDataList.get(i).getKey()))) {
                        oldKey=questionDataList.get(i).getKey();
                        sectionSort.put(sectionSortKey, new SectionKeyValue(questionDataList.get(i).getKey(), newIndex));
                        sectionSortKey++;
                    }
                    newIndex++;
                }

            }
        } else if (filterOption == Constants.TYPE_FAV) {
            for (int i = 0; i < questionDataList.size(); i++) {
                if (questionDataList.get(i).isFavorite()) {
                    filterArrayList.add(questionDataList.get(i));
                    if(!(oldKey.equals(questionDataList.get(i).getKey()))) {
                        oldKey=questionDataList.get(i).getKey();
                        sectionSort.put(sectionSortKey, new SectionKeyValue(questionDataList.get(i).getKey(), newIndex));
                        sectionSortKey++;
                    }
                    newIndex++;
                }


            }
        }
        else if (filterOption == Constants.FILTER_CORRECT_TYPE) {
            for (int i = 0; i < questionDataList.size(); i++) {

                if ((((String) ((ArrayList<Object>) questionDataList.get(i).getTestInfo().get(6)).get(0)).equals((String) ((ArrayList<Object>) questionDataList.get(i).getTestInfo().get(6)).get(2)))) {
                    if(!(oldKey.equals(questionDataList.get(i).getKey()))) {
                        oldKey=questionDataList.get(i).getKey();
                        DebugMonitor.getLogger().d("key taken",oldKey+" position "+sectionSortKey);
                        sectionSort.put(sectionSortKey, new SectionKeyValue(questionDataList.get(i).getKey(), newIndex));
                        sectionSortKey++;
                    }
                    newIndex++;
                    filterArrayList.add(questionDataList.get(i));
                }
            }
        }
        else if (filterOption == Constants.FILTER_WRONG_TYPE) {
            for (int i = 0; i < questionDataList.size(); i++) {

                if (!(((String) ((ArrayList<Object>) questionDataList.get(i).getTestInfo().get(6)).get(2)).toLowerCase().equals(Constants.UNATTEMPTED))&&!(((String) ((ArrayList<Object>) questionDataList.get(i).getTestInfo().get(6)).get(0)).equals((String) ((ArrayList<Object>) questionDataList.get(i).getTestInfo().get(6)).get(2)))) {
                    if(!(oldKey.equals(questionDataList.get(i).getKey()))) {
                        oldKey=questionDataList.get(i).getKey();
                        DebugMonitor.getLogger().d("key taken",oldKey+" position "+sectionSortKey);
                        sectionSort.put(sectionSortKey, new SectionKeyValue(questionDataList.get(i).getKey(), newIndex));
                        sectionSortKey++;
                    }
                    newIndex++;
                    filterArrayList.add(questionDataList.get(i));
                }
            }
        }
        else if (filterOption == Constants.FILTER_UN_ATTEMPTED_TYPE) {
            for (int i = 0; i < questionDataList.size(); i++) {


                if (((String) ((ArrayList<Object>) questionDataList.get(i).getTestInfo().get(6)).get(2)).toLowerCase().equals(Constants.UNATTEMPTED)) {


                    if(!(oldKey.equals(questionDataList.get(i).getKey()))) {
                        oldKey=questionDataList.get(i).getKey();
                        DebugMonitor.getLogger().d("key taken",oldKey+" position<<>> "+sectionSortKey);
                        sectionSort.put(sectionSortKey, new SectionKeyValue(questionDataList.get(i).getKey(), newIndex));
                        sectionSortKey++;
                    }
                    newIndex++;
                    filterArrayList.add(questionDataList.get(i));
                }
            }
        }
        filterData.add(new FilterModel(filterArrayList,sectionSort));
        return filterData;
    }

    public ArrayList<TestDialogInfo> getSummeryInfo(ArrayList<TestAppModel> data) {
        int attempted = 0;
        int unattempted = 0;
        int favourite = 0;

        LinkedHashMap<String, SubmitTestInfo> submitMap = new LinkedHashMap<>();
if(data!=null) {
    for (int k = 0; k < data.size(); k++) {
        if (data.get(k).getAllSessionData()!=null&&data.get(k).getAllSessionData().size() > 0) {
//                Log.d("selected", ">>>>>" + data.get(k).getSelectionOption() + "wooo");
            submitMap.put(data.get(k).getQuestionId(), new SubmitTestInfo(data.get(k).getQuestionId(), ((data.get(k).getSelectionOption() == -1) ? "" : Integer.toString((data.get(k).getSelectionOption() + 1))), data.get(k).getAllSessionData()));
        }

        if (data.get(k).isFavorite()) {
            favourite++;
        }
        if (data.get(k).getSelectionOption() == -1) {
            unattempted++;
        } else {
            attempted++;
        }
    }
}

        ArrayList<TestDialogInfo> filterSummeryList = new ArrayList<>();
        filterSummeryList.add(new TestDialogInfo(attempted, favourite, unattempted, submitMap));
        return filterSummeryList;


    }




    public  LinkedHashMap<String, PauseTestInfo>  getPauseTestInfo(ArrayList<TestAppModel> data) {

        LinkedHashMap<String, PauseTestInfo> submitMap = new LinkedHashMap<>();

        for (int k = 0; k < data.size(); k++) {
            if (data.get(k).getAllSessionData().size() > 0) {
                submitMap.put(data.get(k).getQuestionId(), new PauseTestInfo(data.get(k).getQuestionId(), ((data.get(k).getSelectionOption() == -1) ? "" : Integer.toString((data.get(k).getSelectionOption() + 1))), data.get(k).getAllSessionData(),(data.get(k).isFavorite())?"11":""));
            }


        }


        return submitMap;


    }
    public String getDurationString(long seconds) {

        long hours = seconds / 3600;
        long minutes = (seconds % 3600) / 60;
        seconds = seconds % 60;

        return twoDigitString(hours) + ":" + twoDigitString(minutes) + ":" + twoDigitString(seconds);
    }

    private String twoDigitString(long number) {

        if (number == 0) {
            return "00";
        }

        if (number / 10 == 0) {
            return "0" + number;
        }

        return String.valueOf(number);
    }

    public int getQuestionSection(TreeMap<Integer, SectionKeyValue> questionSet, String key) {
        for(int i=0;i<questionSet.size();i++)
        {
            if(questionSet.get(i).getKey().equals(key))
            {
                return i;
            }

        }
        return 0;
    }
}
