package in.oliveboard.sdk.ui.adapters;

import android.content.Context;
import android.support.v4.content.ContextCompat;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;

import java.util.TreeMap;

import in.oliveboard.sdk.R;
import in.oliveboard.sdk.presenter.model.SectionKeyValue;
import in.oliveboard.sdk.ui.adapters.viewholder.QuickActionViewHolder;


public class QuickActionAdaptor extends RecyclerView.Adapter<RecyclerView.ViewHolder> {
    TreeMap<Integer,SectionKeyValue> questionSet;
    Context context;
    String selectedType;
    public QuickActionAdaptor(Context context, TreeMap<Integer,SectionKeyValue> questionSet, String selectedType) {
        this.questionSet=questionSet;
        this.selectedType=selectedType;
        this.context=context;
    }

    @Override
    public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {

            View itemView = LayoutInflater.from(parent.getContext())
                    .inflate(R.layout.quickaction_row_olivesdk, parent, false);
            return new QuickActionViewHolder(itemView);



    }

    @Override
    public void onBindViewHolder(RecyclerView.ViewHolder mainholder, final int position) {

        if(mainholder instanceof QuickActionViewHolder) {

            QuickActionViewHolder holder = (QuickActionViewHolder) mainholder;
            if(position==(questionSet.size()-1))
            {
                holder.lineDividerView.setVisibility(View.INVISIBLE);
            }
            else
            {
                holder.lineDividerView.setVisibility(View.VISIBLE);
            }

            if(selectedType.equals(questionSet.get(position).getKey()))
            {
                holder.testTextView.setTextColor(ContextCompat.getColor(context, R.color.blue_light));
            }
            else
            {
                holder.testTextView.setTextColor(ContextCompat.getColor(context, R.color.light_grey));

            }
            holder.testTextView.setText(questionSet.get(position).getKey());

        }
    }

    @Override
    public int getItemCount() {
        return questionSet.size();
    }


}
