package in.oliveboard.sdk.ui;

import android.graphics.Typeface;
import android.os.Bundle;
import android.support.design.widget.TabLayout;
import android.support.v4.view.ViewPager;
import android.support.v7.widget.Toolbar;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

import com.squareup.otto.Subscribe;
import in.oliveboard.sdk.R;
import in.oliveboard.sdk.presenter.model.CloseFilter;
import in.oliveboard.sdk.timer.OliveBoardTestTimer;
import in.oliveboard.sdk.ui.adapters.FilterFragmentAdapter;
import in.oliveboard.sdk.ui.base.BaseActivity;

import in.oliveboard.sdk.utils.BasicConfig;
import in.oliveboard.sdk.utils.Constants;
import in.oliveboard.sdk.utils.LargeAppInfo;
import in.oliveboard.sdk.utils.MainEventBus;

public class TestAppFilterActivity extends BaseActivity {
    Toolbar toolbar;
    TabLayout tabs;
    ViewPager viewPager;
    private FilterFragmentAdapter adapter;
    boolean forceClosed=false;

    @Override
    protected void initializeDagger() {

        toolbar = findViewById(R.id.toolbar);
        tabs = findViewById(R.id.tabs);
        viewPager = findViewById(R.id.viewpager);


        setSupportActionBar(toolbar);
        toolbar.setNavigationIcon(R.drawable.ic_close_black_24dp);
        if(LargeAppInfo.getInstance().getBaseFilterArray()!=null) {
            adapter = new FilterFragmentAdapter(getSupportFragmentManager(), Constants.FILTER_TEST_APP);

            viewPager.setAdapter(adapter);
            tabs.setupWithViewPager(viewPager);
//            final Typeface selectedFont = Typeface.createFromAsset(getAssets(), "fonts/SF-UI-Display_Heavy_Cyrillic.otf");
//            final Typeface unselectedFont = Typeface.createFromAsset(getAssets(), "fonts/SF-UI-Display_Medium_Cyrillic.otf");
//
//            ViewGroup vg = (ViewGroup) tabs.getChildAt(0);
//            int tabsCount = vg.getChildCount();
//            for (int j = 0; j < tabsCount; j++) {
//                ViewGroup vgTab = (ViewGroup) vg.getChildAt(j);
//                int tabChildsCount = vgTab.getChildCount();
//                for (int i = 0; i < tabChildsCount; i++) {
//                    View tabViewChild = vgTab.getChildAt(i);
//                    if (tabViewChild instanceof TextView) {
//                        if (j > 0) {
//                            ((TextView) tabViewChild).setTypeface(unselectedFont);
//                        } else {
//                            ((TextView) tabViewChild).setTypeface(selectedFont);
//
//                        }
//                    }
//                }
//            }
            if(tabs!=null) {
                try {
                    BasicConfig.getInstance().apply((ViewGroup) tabs.getChildAt(0), "fonts/SF-UI-Display_Heavy_Cyrillic.otf", getApplicationContext());
                }catch (Exception e)
                {

                }

            }

           /* tabs.addOnTabSelectedListener(new TabLayout.OnTabSelectedListener() {
                @Override
                public void onTabSelected(TabLayout.Tab tab) {
                    ViewGroup vg = (ViewGroup) tabs.getChildAt(0);
                    ViewGroup vgTab = (ViewGroup) vg.getChildAt(tab.getPosition());
                    int tabChildsCount = vgTab.getChildCount();
                    for (int i = 0; i < tabChildsCount; i++) {
                        View tabViewChild = vgTab.getChildAt(i);
                        if (tabViewChild instanceof TextView) {
                            ((TextView) tabViewChild).setTypeface(selectedFont);
                        }
                    }
                }

                @Override
                public void onTabUnselected(TabLayout.Tab tab) {
                    ViewGroup vg = (ViewGroup) tabs.getChildAt(0);
                    ViewGroup vgTab = (ViewGroup) vg.getChildAt(tab.getPosition());
                    int tabChildsCount = vgTab.getChildCount();
                    for (int i = 0; i < tabChildsCount; i++) {
                        View tabViewChild = vgTab.getChildAt(i);
                        if (tabViewChild instanceof TextView) {
                            ((TextView) tabViewChild).setTypeface(unselectedFont);
                        }
                    }
                }

                @Override
                public void onTabReselected(TabLayout.Tab tab) {

                }
            });
*/

            try {
                MainEventBus.getInstance().register(this);
            } catch (Exception e) {

            }
            //LogEvents.getInstance().passEvents(getApplicationContext(),"TestAppFilterScreen","view_page");

        }
        else
        {
            finish();
        }

    }

    @Override
    protected void savedInstance(Bundle savedInstanceState) {

    }

    @Override
    protected void initializePresenter() {

    }

    @Override
    public int getLayoutId() {
        return R.layout.test_app_base_layout_olivesdk;
    }


    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        switch (item.getItemId()) {
            case android.R.id.home:
               finish();
        }
        return super.onOptionsItemSelected(item);
    }

    @Override
    protected void onPause() {
        super.onPause();
        if(!forceClosed)
        OliveBoardTestTimer.getInstance().pause();
    }

    @Override
    protected void onResume() {
        super.onResume();

        OliveBoardTestTimer.getInstance().resume();


    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        if(!forceClosed) {
            OliveBoardTestTimer.getInstance().resume();
        }
        try {
            MainEventBus.getInstance().unregister(this);
        }
        catch (Exception e)
        {

        }
    }
    @Subscribe
    public void forceStopFilter(CloseFilter closefilter)
    {
        forceClosed=true;
        finish();
    }
}
