package in.oliveboard.sdk.databases;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.TreeMap;

import in.oliveboard.sdk.presenter.model.CacheTestInfo;
import in.oliveboard.sdk.presenter.model.SectionKeyValue;
import in.oliveboard.sdk.presenter.model.SessionInfo;
import in.oliveboard.sdk.presenter.model.TestAppModel;


public class OliveBoardDb extends SQLiteOpenHelper {
    private OliveBoardDb(Context context) {
        super(context, DATABASE_NAME, null, DATABASE_VERSION);
        // TODO Auto-generated constructor stub
    }

    private static final String DATABASE_NAME = "OliveBoard_DB";
    private static final String DATABASE_OLIVEBOARD_TABLE = "OliveBoardTable";


    private static final int DATABASE_VERSION = 1;

    public static String TEST_DATA_COLOUM = "TestData_Info";
    public static String TEST_DATA_ID_COLOUM = "TestData_Id";
    private static final String TABLE_INSERT = "create table "
            + DATABASE_OLIVEBOARD_TABLE
            + "(" + TEST_DATA_COLOUM + " text not null, " + TEST_DATA_ID_COLOUM + " text not null);";


    public void deleteRecords() {
        db.delete(DATABASE_OLIVEBOARD_TABLE, null, null);
    }

    public void insertTestInfo(LinkedHashMap<String,ArrayList<String>> panesList, ArrayList<TestAppModel> questionInfo, ArrayList<SessionInfo> filterSessionArrayList, String timeleft, String id, TreeMap<Integer,SectionKeyValue> questionSet, int language, String submitUrl, String solutionUrl, String qpi, String pauseUrl, String ppi) {
        String[] h1 = timeleft.split(":");

        int hour = Integer.parseInt(h1[0]);
        int minute = Integer.parseInt(h1[1]);
        int second = Integer.parseInt(h1[2]);

        int temp;
        temp = second + (60 * minute) + (3600 * hour);

        Gson gson =new GsonBuilder().enableComplexMapKeySerialization()
                .setPrettyPrinting().create();

        String questionData = gson.toJson(new CacheTestInfo(questionInfo, filterSessionArrayList, Integer.toString(temp),questionSet,language,panesList,submitUrl,solutionUrl,qpi,pauseUrl,ppi));
        db.delete(DATABASE_OLIVEBOARD_TABLE, null, null);

        ContentValues cv = new ContentValues();
        cv.put(TEST_DATA_COLOUM, questionData);
        cv.put(TEST_DATA_ID_COLOUM, id);

        db.insert(DATABASE_OLIVEBOARD_TABLE, null, cv);


    }

    public CacheTestInfo getTestInfo(String id) {

        Cursor cursor = db.rawQuery("SELECT * FROM " + DATABASE_OLIVEBOARD_TABLE + " WHERE " + TEST_DATA_ID_COLOUM + " = '" + id + "' ", null);
        String testData = null;
        if (cursor.moveToNext()) {
            testData = cursor.getString(cursor
                    .getColumnIndex(TEST_DATA_COLOUM));
        }
        cursor.close();
        if (testData != null) {

            Gson gson =new GsonBuilder().enableComplexMapKeySerialization()
                    .setPrettyPrinting().create();
            return  gson.fromJson(testData, CacheTestInfo.class);
        }

        return null;
    }


    @Override
    public synchronized void close() {
        if (instance != null) {
            db.close();
            instance = null;
        }
    }

    private static OliveBoardDb instance;
    private static SQLiteDatabase db;


    public static synchronized OliveBoardDb getInstance(Context context) {
        if (instance == null) {
            instance = new OliveBoardDb(context);
            db = instance.getWritableDatabase();

        }

        return instance;
    }

    @Override
    public void onCreate(SQLiteDatabase db) {
        // TODO Auto-generated method stub

        db.execSQL(TABLE_INSERT);


    }

    @Override
    public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
        // TODO Auto-generated method stub

    }

}