/*
 * Decompiled with CFR 0.152.
 */
package in.oliveboard.sdk.timer;

import android.annotation.SuppressLint;
import android.os.CountDownTimer;
import android.widget.TextView;
import in.oliveboard.sdk.timer.Counter;
import in.oliveboard.sdk.timer.TimerStatus;
import in.oliveboard.sdk.timer.listener.TimerListener;
import java.io.IOException;

public class OliveBoardTestTimer {
    private static final long WARNING_TIME = 180000L;
    private TextView timerTextView;
    private Counter counterConfig;
    @SuppressLint(value={"StaticFieldLeak"})
    private static OliveBoardTestTimer oliveBoradInstance;
    private TimerListener timerListener;
    private CountDownTimer countDowmTimer;
    private long lastmillisecound = 0L;
    private boolean isTicking = false;

    public static synchronized OliveBoardTestTimer getInstance() {
        if (oliveBoradInstance == null) {
            oliveBoradInstance = new OliveBoardTestTimer();
        }
        return oliveBoradInstance;
    }

    public OliveBoardTestTimer init(TextView timerTextView, Counter counterConfig, TimerListener timerListener) {
        this.timerTextView = timerTextView;
        this.counterConfig = counterConfig;
        this.timerListener = timerListener;
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void startTimer(boolean isResume) throws IOException {
        long secoundtoMilleSecound;
        if (this.timerTextView == null) throw new NullPointerException("textview is null");
        if (this.isTicking && this.countDowmTimer != null) {
            this.countDowmTimer.cancel();
        }
        if (this.counterConfig.getTotalTime() == 0L && this.lastmillisecound == 0L) throw new IOException("starting time cannot be 0");
        long l = secoundtoMilleSecound = isResume ? this.lastmillisecound : this.counterConfig.getTotalTime() * 1000L;
        if (this.isTicking) return;
        this.isTicking = true;
        this.countDowmTimer = new CountDownTimer(secoundtoMilleSecound, 1000L){
            int mDisplayHours;
            private int mDisplayMinutes;
            private int mDisplaySeconds;

            @SuppressLint(value={"SetTextI18n"})
            public void onTick(long millisUntilFinished) {
                OliveBoardTestTimer.this.lastmillisecound = millisUntilFinished;
                this.mDisplayHours = (int)(millisUntilFinished / 1000L / 3600L);
                this.mDisplayMinutes = (int)((millisUntilFinished / 1000L - (long)(this.mDisplayHours * 3600)) / 60L);
                this.mDisplaySeconds = (int)(millisUntilFinished / 1000L % 60L);
                if (OliveBoardTestTimer.this.timerTextView != null) {
                    OliveBoardTestTimer.this.timerTextView.setText((CharSequence)((this.mDisplayHours < 10 ? "0" + this.mDisplayHours : Integer.valueOf(this.mDisplayHours)) + ":" + (this.mDisplayMinutes < 10 ? "0" + this.mDisplayMinutes : Integer.valueOf(this.mDisplayMinutes)) + ":" + (this.mDisplaySeconds < 10 ? "0" + this.mDisplaySeconds : Integer.valueOf(this.mDisplaySeconds))));
                }
                if (millisUntilFinished < 180000L && OliveBoardTestTimer.this.timerListener != null) {
                    OliveBoardTestTimer.this.timerListener.onTimerChanged(TimerStatus.TIME_ENDING);
                }
            }

            @SuppressLint(value={"SetTextI18n"})
            public void onFinish() {
                if (OliveBoardTestTimer.this.timerTextView != null) {
                    OliveBoardTestTimer.this.timerTextView.setText((CharSequence)"00:00:00");
                }
                OliveBoardTestTimer.this.lastmillisecound = 0L;
                if (OliveBoardTestTimer.this.timerListener != null) {
                    OliveBoardTestTimer.this.timerListener.onTimerChanged(TimerStatus.FINISHED);
                }
            }
        }.start();
    }

    public void pause() {
        if (this.isTicking) {
            if (this.countDowmTimer != null) {
                this.countDowmTimer.cancel();
                if (this.timerListener != null) {
                    this.timerListener.onTimerChanged(TimerStatus.PAUSED);
                }
            }
            this.isTicking = false;
        }
    }

    public void resume() {
        if (!this.isTicking && this.countDowmTimer != null) {
            try {
                this.startTimer(true);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (this.timerListener != null) {
                this.timerListener.onTimerChanged(TimerStatus.RESUMED);
            }
        }
    }

    @SuppressLint(value={"SetTextI18n"})
    public void setTime() {
        if (this.counterConfig != null) {
            long millisUntilFinished = (this.counterConfig.getTotalTime() - 1L) * 1000L;
            int mDisplayHours = (int)(millisUntilFinished / 1000L / 3600L);
            int mDisplayMinutes = (int)((millisUntilFinished / 1000L - (long)(mDisplayHours * 3600)) / 60L);
            int mDisplaySeconds = (int)(millisUntilFinished / 1000L % 60L);
            if (this.timerTextView != null) {
                this.timerTextView.setText((CharSequence)((mDisplayHours < 10 ? "0" + mDisplayHours : Integer.valueOf(mDisplayHours)) + ":" + (mDisplayMinutes < 10 ? "0" + mDisplayMinutes : Integer.valueOf(mDisplayMinutes)) + ":" + (mDisplaySeconds < 10 ? "0" + mDisplaySeconds : Integer.valueOf(mDisplaySeconds))));
            }
        }
    }

    @SuppressLint(value={"SetTextI18n"})
    public void finish() {
        this.isTicking = false;
        if (this.countDowmTimer != null) {
            this.countDowmTimer.cancel();
            this.lastmillisecound = 0L;
            if (this.timerListener != null) {
                this.timerListener.onTimerChanged(TimerStatus.FORCE_FINISHED);
            }
            if (this.timerTextView != null) {
                this.timerTextView.setText((CharSequence)"00:00:00");
            }
        }
    }

    public void finishOnPause() {
        this.isTicking = false;
        if (this.countDowmTimer != null) {
            this.countDowmTimer.cancel();
            this.lastmillisecound = 0L;
            if (this.timerListener != null) {
                this.timerListener.onTimerChanged(TimerStatus.FORCE_FINISHED);
            }
        }
    }
}

