/*
 * Decompiled with CFR 0.152.
 */
package in.oliveboard.sdk.log;

import android.util.Log;
import in.oliveboard.sdk.log.DebugMonitor;
import in.oliveboard.sdk.log.Logger;

public class DefaultLogger
implements Logger {
    private int logLevel;

    public DefaultLogger(int logLevel) {
        this.logLevel = logLevel;
    }

    public DefaultLogger() {
        this.logLevel = DebugMonitor.LOG_LEVEL.DEBUG;
    }

    @Override
    public boolean isLoggable(String tag, int level) {
        return this.logLevel <= level;
    }

    @Override
    public int getLogLevel() {
        return this.logLevel;
    }

    @Override
    public void setLogLevel(int logLevel) {
        this.logLevel = logLevel;
    }

    @Override
    public void d(String tag, String message, Throwable throwable) {
        if (DebugMonitor.isDebuggable() && this.isLoggable(tag, 3)) {
            Log.d((String)tag, (String)message, (Throwable)throwable);
        }
    }

    @Override
    public void v(String tag, String message, Throwable throwable) {
        if (DebugMonitor.isDebuggable() && this.isLoggable(tag, 2)) {
            Log.v((String)tag, (String)message, (Throwable)throwable);
        }
    }

    @Override
    public void i(String tag, String message, Throwable throwable) {
        if (DebugMonitor.isDebuggable() && this.isLoggable(tag, 4)) {
            Log.i((String)tag, (String)message, (Throwable)throwable);
        }
    }

    @Override
    public void w(String tag, String message, Throwable throwable) {
        if (DebugMonitor.isDebuggable() && this.isLoggable(tag, 5)) {
            Log.w((String)tag, (String)message, (Throwable)throwable);
        }
    }

    @Override
    public void e(String tag, String message, Throwable throwable) {
        if (DebugMonitor.isDebuggable() && this.isLoggable(tag, 6)) {
            Log.e((String)tag, (String)message, (Throwable)throwable);
        }
    }

    @Override
    public void d(String tag, String message) {
        this.d(tag, message, null);
    }

    @Override
    public void v(String tag, String message) {
        this.v(tag, message, null);
    }

    @Override
    public void i(String tag, String message) {
        this.i(tag, message, null);
    }

    @Override
    public void w(String tag, String message) {
        this.w(tag, message, null);
    }

    @Override
    public void e(String tag, String message) {
        this.e(tag, message, null);
    }

    @Override
    public void log(int priority, String tag, String message) {
        this.log(priority, tag, message, false);
    }

    @Override
    public void log(int priority, String tag, String message, boolean forceLog) {
        if (forceLog || this.isLoggable(tag, priority)) {
            Log.println((int)priority, (String)tag, (String)message);
        }
    }
}

