package in.oliveboard.sdk.communication;

import android.os.AsyncTask;
import android.util.Log;

import com.google.gson.Gson;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Map;

import javax.net.ssl.HttpsURLConnection;

import in.oliveboard.sdk.log.DebugMonitor;
import in.oliveboard.sdk.presenter.base.BaseCallback;
import in.oliveboard.sdk.presenter.model.LoginResponseModel;
import in.oliveboard.sdk.utils.BaseSharedPreferences;
import in.oliveboard.sdk.utils.Constants;

public final class HTTPAsyncTaskAuth extends AsyncTask<String, Void, String> {
    String url;
    Map<String, String> postDataParams;
    BaseCallback callback;
    BaseSharedPreferences baseSharedPreferences;
    String cookieAuthtoken;
    String cookieVersion;
    String cookieDeviceid;

    public HTTPAsyncTaskAuth(String url, Map<String, String> postDataParams, BaseCallback callback){
        this.url = url;
        this.postDataParams = postDataParams;
        this.callback = callback;
    }

    @Override
    protected String doInBackground(String... urls) {

        try {
            return performPostCall(url,postDataParams);
        } catch (Exception e) {
            return null;
        }
    }
    @Override
    protected void onPostExecute(String result) {
        // response_txt.setText(result);

        LoginResponseModel loginResponseModel = new Gson().fromJson(result,LoginResponseModel.class);
        if(loginResponseModel!=null) {
            if (loginResponseModel.uauth.equals("0")) {
                callback.onFail();

            } else {
                if (baseSharedPreferences != null) {
                    DebugMonitor.getLogger().d("new_user", "Ya_sucessfull_prefrence");
                    if (loginResponseModel.newreg != null && loginResponseModel.newreg.equals("1")) {
                        DebugMonitor.getLogger().d("new_user", "yes");
                        baseSharedPreferences.putData(Constants.IS_NEW_USER, 1);

                    } else {
                        DebugMonitor.getLogger().d("new_user", "nooooo");
                        baseSharedPreferences.putData(Constants.IS_NEW_USER, 0);
                    }
                }
                //callback.onLoginSuccess(loginResponseModel.uauth);
                callback.onSuccess(loginResponseModel);
            }
        }
        else
        {
            callback.onFail("fail");
        }
    }

    public String  performPostCall(String requestURL,
                                   Map<String, String> postDataParams) {
        InputStream inputStream = null;
        URL url;
        String response = "";

        try {
            url = new URL(requestURL);

            HttpURLConnection conn = (HttpURLConnection) url.openConnection();
            conn.setReadTimeout(15000);
            conn.setConnectTimeout(15000);
            conn.setRequestMethod("POST");
            conn.setDoInput(true);
            conn.setDoOutput(true);


            OutputStream os = conn.getOutputStream();
            BufferedWriter writer = new BufferedWriter(
                    new OutputStreamWriter(os, "UTF-8"));
            writer.write(getPostDataString(postDataParams));

            writer.flush();
            writer.close();
            os.close();
            int responseCode=conn.getResponseCode();

            if (responseCode == HttpsURLConnection.HTTP_OK) {
                inputStream = conn.getInputStream();
                if(inputStream != null)
                    response = convertInputStreamToString(inputStream);
                else
                    response = "Did not work!";
            }
            else {
                response="";

            }
        } catch (Exception e) {
            e.printStackTrace();
        }

        return response;
    }

    private  String convertInputStreamToString(InputStream inputStream) throws IOException {
        BufferedReader bufferedReader = new BufferedReader( new InputStreamReader(inputStream));
        String line = "";
        String result = "";
        while((line = bufferedReader.readLine()) != null)
            result += line;

        inputStream.close();
        return result;

    }

    private  String getPostDataString(Map<String, String> params) throws UnsupportedEncodingException {
        StringBuilder result = new StringBuilder();
        boolean first = true;
        for(Map.Entry<String, String> entry : params.entrySet()){
            if (first)
                first = false;
            else
                result.append("&");

            result.append(URLEncoder.encode(entry.getKey(), "UTF-8"));
            result.append("=");
            result.append(URLEncoder.encode(entry.getValue(), "UTF-8"));
        }

        return result.toString();
    }

}