/*
 * Decompiled with CFR 0.152.
 */
package in.oliveboard.sdk.ui;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.widget.ProgressBar;
import android.widget.Toast;
import in.oliveboard.sdk.R;
import in.oliveboard.sdk.presenter.AuthPresenter;
import in.oliveboard.sdk.presenter.interfaces.AuthContract;
import in.oliveboard.sdk.presenter.model.LoginResponseModel;
import in.oliveboard.sdk.ui.HomeActivity;
import in.oliveboard.sdk.ui.LoginOliveBoardActivity;
import in.oliveboard.sdk.ui.base.BaseActivity;
import in.oliveboard.sdk.utils.AppPreferences;
import in.oliveboard.sdk.utils.BasicConfig;
import in.oliveboard.sdk.utils.Constants;
import in.oliveboard.sdk.utils.LargeDataHandler;
import java.util.HashMap;

public class LoadingUrlActivity
extends BaseActivity
implements AuthContract.View {
    ProgressBar loadingBar;
    AuthPresenter presenter = new AuthPresenter();

    @Override
    protected void initializeDagger() {
        this.loadingBar = (ProgressBar)this.findViewById(R.id.loading);
        this.loadingBar.setIndeterminate(true);
        this.loadingBar.setVisibility(0);
    }

    @Override
    protected void savedInstance(Bundle savedInstanceState) {
    }

    @Override
    protected void initializePresenter() {
        ((BaseActivity)this).presenter = this.presenter;
        this.presenter.setView(this);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("e", BasicConfig.getInstance().getAuthEmail((Context)this));
        params.put("p", BasicConfig.getInstance().getAuthPassword((Context)this));
        params.put("ref", this.getApplicationContext().getPackageName());
        new AppPreferences(this.getApplicationContext(), "LoginPref").SaveData("email_type", "Normal");
        if (this.presenter != null) {
            this.presenter.onUserLogin(params);
        }
    }

    @Override
    public int getLayoutId() {
        return R.layout.activity_loading_url_olivesdk;
    }

    @Override
    public void loginSuccess(String token) {
        this.loadingBar.setVisibility(8);
    }

    @Override
    public void onFailed() {
        this.loadingBar.setVisibility(8);
        new AppPreferences(this.getApplicationContext(), "LoginPref").clearData();
        Toast.makeText((Context)this.getApplicationContext(), (CharSequence)"Incorrect email/password. Please try again.", (int)0).show();
        Intent intent = new Intent((Context)this, LoginOliveBoardActivity.class);
        this.startActivity(intent);
    }

    @Override
    public void onFailed(String message) {
        this.loadingBar.setVisibility(8);
        Toast.makeText((Context)this.getApplicationContext(), (CharSequence)"Please try again", (int)0).show();
        Intent intent = new Intent((Context)this, LoginOliveBoardActivity.class);
        this.startActivity(intent);
    }

    @Override
    public void onAuthFailed() {
        this.loadingBar.setVisibility(8);
        BasicConfig.getInstance().onAuthFailed(this);
    }

    public void onLoginSuccess(Object responseModel) {
        this.loadingBar.setVisibility(8);
        if (responseModel instanceof LoginResponseModel) {
            LargeDataHandler.getInstance().setMockTestUrl(((LoginResponseModel)responseModel).starturl);
            new AppPreferences(this.getApplicationContext(), "LoginPref").saveBoolean("IsLoggedIn", true);
            new AppPreferences(this.getApplicationContext(), "LoginPref").SaveData("token", ((LoginResponseModel)responseModel).uauth);
            new AppPreferences(this.getApplicationContext(), "LoginPref").SaveData("email", BasicConfig.getInstance().getAuthEmail((Context)this));
            new AppPreferences(this.getApplicationContext(), "LoginPref").SaveData("password", BasicConfig.getInstance().getAuthPassword((Context)this));
            Intent intent = new Intent((Context)this, HomeActivity.class);
            intent.putExtra(Constants.BUNDLE_KEY_MOCK_TEST_URL, ((LoginResponseModel)responseModel).starturl);
            intent.putExtra(Constants.BUNDLE_KEY_MOCK_TEST_TYPE, "Mock Test");
            intent.putExtra("com.title.bundle.language", "Oliveboard Mock Tests");
            this.startActivity(intent);
            this.finish();
        }
    }
}

