package in.oliveboard.sdk.ui.adapters;

import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;

import in.oliveboard.sdk.R;
import in.oliveboard.sdk.presenter.model.SummeryBaseResponse;
import in.oliveboard.sdk.ui.adapters.viewholder.SummeryHeaderViewHolder;
import in.oliveboard.sdk.ui.adapters.viewholder.SummeryMainViewHolder;
import in.oliveboard.sdk.ui.adapters.viewholder.SummerySubHeaderViewHolder;


public class SummeryAdaptor extends RecyclerView.Adapter<RecyclerView.ViewHolder> {
    private static final int TYPE_HEADER =0 ;
    private static final int TYPE_SUBHEADER =1;
    private static final int TYPE_MAIN_HEADER =2;
    private static final int TYPE_MAIN_HEADER_BOLD =3;
    SummeryBaseResponse summeryData;
    public SummeryAdaptor(SummeryBaseResponse summeryData) {
     this.summeryData=summeryData;
    }

    @Override
    public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        if(viewType==TYPE_MAIN_HEADER) {

            View itemView = LayoutInflater.from(parent.getContext())
                    .inflate(R.layout.topview_analysis_olivesdk, parent, false);
            return new SummeryHeaderViewHolder(itemView);
        }
        else if (viewType==TYPE_SUBHEADER)
        {
            View itemView = LayoutInflater.from(parent.getContext())
                    .inflate(R.layout.image_item_layout_olivesdk, parent, false);
            return new SummerySubHeaderViewHolder(itemView);
        }
        else if (viewType==TYPE_MAIN_HEADER_BOLD)
        {
            View itemView = LayoutInflater.from(parent.getContext())
                    .inflate(R.layout.text_item_bold_layout_olivesdk, parent, false);
            return new SummeryMainViewHolder(itemView);
        }
        else
        {
            View itemView = LayoutInflater.from(parent.getContext())
                    .inflate(R.layout.text_item_layout_olivesdk, parent, false);
            return new SummeryMainViewHolder(itemView);
        }



    }

    @Override
    public void onBindViewHolder(RecyclerView.ViewHolder mainholder, final int position) {
        if (mainholder instanceof SummeryMainViewHolder) {
            if(summeryData.tableList!=null) {
                SummeryMainViewHolder holder = (SummeryMainViewHolder) mainholder;
                holder.section.setText("" + summeryData.tableList.get((position - 2)).get(0));
                holder.rightOption.setText("" + summeryData.tableList.get((position - 2)).get(1));
                holder.nextRight.setText("/" + summeryData.tableList.get((position - 2)).get(2));
                holder.wrongOption.setText("" + summeryData.tableList.get((position - 2)).get(3));
                holder.score.setText("" + summeryData.tableList.get((position - 2)).get(4));
                holder.percentile.setText("" + summeryData.tableList.get((position - 2)).get(5));
                holder.time.setText("" + summeryData.tableList.get((position - 2)).get(6));
            }
        } else if (mainholder instanceof SummeryHeaderViewHolder) {
            if(summeryData.summeryModel.rightList!=null&&summeryData.summeryModel.wrongList!=null&&summeryData.summeryModel.scoreList!=null&&summeryData.summeryModel.timeList!=null&&summeryData.summeryModel.percentileList!=null&&summeryData.summeryModel.accuracyList!=null) {
                SummeryHeaderViewHolder holder = (SummeryHeaderViewHolder) mainholder;

                holder.right1.setText(summeryData.summeryModel.rightList.get(0));
                holder.right2.setText(" / " + summeryData.summeryModel.rightList.get(1));
                holder.right3.setText(summeryData.summeryModel.rightList.get(2));

                holder.wrong1.setText("" + summeryData.summeryModel.wrongList.get(0));
                holder.wrong2.setText(" / " + summeryData.summeryModel.wrongList.get(1));
                holder.wrong3.setText("" + summeryData.summeryModel.wrongList.get(2));

                holder.score1.setText("" + summeryData.summeryModel.scoreList.get(0));
                holder.score2.setText(" / " + summeryData.summeryModel.scoreList.get(1));
                holder.score3.setText("" + summeryData.summeryModel.scoreList.get(2));

                holder.time1.setText("" + summeryData.summeryModel.timeList.get(0));
                holder.time3.setText("" + summeryData.summeryModel.timeList.get(2));

                holder.acc1.setText("" + summeryData.summeryModel.accuracyList.get(0));
                holder.acc3.setText("" + summeryData.summeryModel.accuracyList.get(2));

                holder.perc1.setText("" + summeryData.summeryModel.percentileList.get(0));
                holder.perc2.setText(" / " + summeryData.summeryModel.percentileList.get(1));
                holder.perc3.setText("" + summeryData.summeryModel.percentileList.get(2));

            }
        }
    }

    @Override
    public int getItemCount() {
        if(summeryData==null)
        {
            return 0;
        }
        else {
            return (summeryData.tableList.size() + 2);
        }
    }


    @Override
    public int getItemViewType(int position) {
        if(position==0)
        {
            return TYPE_MAIN_HEADER;
        }
        else if(position==1)
        {
            return TYPE_SUBHEADER;
        }
        else if(position==((summeryData.tableList.size()+2)-1))
        {
            return TYPE_MAIN_HEADER_BOLD;
        }
        else
        {
            return TYPE_HEADER;
        }

    }
}
