package in.oliveboard.sdk.ui.adapters;

import android.os.Build;
import android.support.v7.widget.RecyclerView;
import android.text.Html;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;

import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;

import in.oliveboard.sdk.R;
import in.oliveboard.sdk.ui.adapters.viewholder.AnswerViewHolder;
import in.oliveboard.sdk.utils.Constants;

public class AnswerAdaptor extends RecyclerView.Adapter<RecyclerView.ViewHolder> {
    ArrayList<ArrayList<String>> answerDataList;
    int selectedOption;
    int languageType;
    List<String> data;

    public AnswerAdaptor(ArrayList<ArrayList<String>> answerDataList, int selectedOption, int lanuageType) {
        this.answerDataList = answerDataList;
        this.selectedOption = selectedOption;
        this.languageType = lanuageType;
    }

    public AnswerAdaptor(List data, int selectedOption) {
        this.selectedOption=selectedOption;
        this.data= data;
    }

    @Override
    public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        if (viewType == 0) {

            View itemView = LayoutInflater.from(parent.getContext())
                    .inflate(R.layout.row_answer_olivesdk, parent, false);
            return new AnswerViewHolder(itemView);
        } else {
            View itemView = LayoutInflater.from(parent.getContext())
                    .inflate(R.layout.row_answer_selected_olivesdk, parent, false);
            return new AnswerViewHolder(itemView);
        }


    }

    @Override
    public void onBindViewHolder(RecyclerView.ViewHolder mainholder, final int position) {

        if (mainholder instanceof AnswerViewHolder) {

            AnswerViewHolder holder = (AnswerViewHolder) mainholder;
            if(data==null) {
                try {

                    if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.N) {
                        holder.answerTextView.setText(Html.fromHtml(URLDecoder.decode((answerDataList.get(position).size() > 1) ? answerDataList.get(position).get(languageType) : answerDataList.get(position).get(0), "UTF-8"), Html.FROM_HTML_MODE_LEGACY));
                    } else {
                        holder.answerTextView.setText(Html.fromHtml(URLDecoder.decode((answerDataList.get(position).size() > 1) ? answerDataList.get(position).get(languageType) : answerDataList.get(position).get(0), "UTF-8")));

                    }

                } catch (Exception e) {

                }
                holder.optionTextView.setText(Constants.ALPHABETS[position]);
            }
            else
            {
                try {

                    if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.N) {
                        holder.answerTextView.setText(Html.fromHtml(URLDecoder.decode(data.get(position), "UTF-8"), Html.FROM_HTML_MODE_LEGACY));
                    } else {
                        holder.answerTextView.setText(Html.fromHtml(URLDecoder.decode(data.get(position), "UTF-8")));

                    }

                } catch (Exception e) {

                }
                holder.optionTextView.setText(Constants.ALPHABETS[position]);
            }
        }
    }

    @Override
    public int getItemCount() {
        if(data!=null)
        {
            return data.size();
        }
        else
        {
            return answerDataList.size();
        }

    }

    public void notifySelection(int selectedOption) {
        this.selectedOption = selectedOption;
        notifyDataSetChanged();
    }

    public void notifyLanguageChanged(int lanuageType) {
        this.languageType = lanuageType;
        notifyDataSetChanged();
    }

    @Override
    public int getItemViewType(int position) {
        if (position == selectedOption) {
            return 1;
        } else {
            return 0;
        }
    }
}
