/*
 * Decompiled with CFR 0.152.
 */
package in.oliveboard.sdk.ui;

import android.content.res.AssetManager;
import android.graphics.Typeface;
import android.os.Bundle;
import android.support.design.widget.TabLayout;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.support.v7.widget.Toolbar;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import com.squareup.otto.Subscribe;
import in.oliveboard.sdk.R;
import in.oliveboard.sdk.presenter.model.CloseFilter;
import in.oliveboard.sdk.timer.OliveBoardTestTimer;
import in.oliveboard.sdk.ui.adapters.FilterFragmentAdapter;
import in.oliveboard.sdk.ui.base.BaseActivity;
import in.oliveboard.sdk.utils.Constants;
import in.oliveboard.sdk.utils.LargeAppInfo;
import in.oliveboard.sdk.utils.MainEventBus;

public class TestAppFilterActivity
extends BaseActivity {
    Toolbar toolbar;
    TabLayout tabs;
    ViewPager viewPager;
    private FilterFragmentAdapter adapter;
    boolean forceClosed = false;

    @Override
    protected void initializeDagger() {
        this.toolbar = (Toolbar)this.findViewById(R.id.toolbar);
        this.tabs = (TabLayout)this.findViewById(R.id.tabs);
        this.viewPager = (ViewPager)this.findViewById(R.id.viewpager);
        this.setSupportActionBar(this.toolbar);
        this.toolbar.setNavigationIcon(R.drawable.ic_close_black_24dp);
        if (LargeAppInfo.getInstance().getBaseFilterArray() != null) {
            this.adapter = new FilterFragmentAdapter(this.getSupportFragmentManager(), Constants.FILTER_TEST_APP);
            this.viewPager.setAdapter((PagerAdapter)this.adapter);
            this.tabs.setupWithViewPager(this.viewPager);
            final Typeface selectedFont = Typeface.createFromAsset((AssetManager)this.getAssets(), (String)"fonts/SF-UI-Display_Heavy_Cyrillic.otf");
            final Typeface unselectedFont = Typeface.createFromAsset((AssetManager)this.getAssets(), (String)"fonts/SF-UI-Display_Medium_Cyrillic.otf");
            ViewGroup vg = (ViewGroup)this.tabs.getChildAt(0);
            int tabsCount = vg.getChildCount();
            for (int j = 0; j < tabsCount; ++j) {
                ViewGroup vgTab = (ViewGroup)vg.getChildAt(j);
                int tabChildsCount = vgTab.getChildCount();
                for (int i = 0; i < tabChildsCount; ++i) {
                    View tabViewChild = vgTab.getChildAt(i);
                    if (!(tabViewChild instanceof TextView)) continue;
                    if (j > 0) {
                        ((TextView)tabViewChild).setTypeface(unselectedFont);
                        continue;
                    }
                    ((TextView)tabViewChild).setTypeface(selectedFont);
                }
            }
            this.tabs.setOnTabSelectedListener((TabLayout.BaseOnTabSelectedListener)new TabLayout.OnTabSelectedListener(){

                public void onTabSelected(TabLayout.Tab tab) {
                }

                public void onTabUnselected(TabLayout.Tab tab) {
                }

                public void onTabReselected(TabLayout.Tab tab) {
                }
            });
            this.tabs.addOnTabSelectedListener((TabLayout.BaseOnTabSelectedListener)new TabLayout.OnTabSelectedListener(){

                public void onTabSelected(TabLayout.Tab tab) {
                    ViewGroup vg = (ViewGroup)TestAppFilterActivity.this.tabs.getChildAt(0);
                    ViewGroup vgTab = (ViewGroup)vg.getChildAt(tab.getPosition());
                    int tabChildsCount = vgTab.getChildCount();
                    for (int i = 0; i < tabChildsCount; ++i) {
                        View tabViewChild = vgTab.getChildAt(i);
                        if (!(tabViewChild instanceof TextView)) continue;
                        ((TextView)tabViewChild).setTypeface(selectedFont);
                    }
                }

                public void onTabUnselected(TabLayout.Tab tab) {
                    ViewGroup vg = (ViewGroup)TestAppFilterActivity.this.tabs.getChildAt(0);
                    ViewGroup vgTab = (ViewGroup)vg.getChildAt(tab.getPosition());
                    int tabChildsCount = vgTab.getChildCount();
                    for (int i = 0; i < tabChildsCount; ++i) {
                        View tabViewChild = vgTab.getChildAt(i);
                        if (!(tabViewChild instanceof TextView)) continue;
                        ((TextView)tabViewChild).setTypeface(unselectedFont);
                    }
                }

                public void onTabReselected(TabLayout.Tab tab) {
                }
            });
            try {
                MainEventBus.getInstance().register((Object)this);
            }
            catch (Exception exception) {}
        } else {
            this.finish();
        }
    }

    @Override
    protected void savedInstance(Bundle savedInstanceState) {
    }

    @Override
    protected void initializePresenter() {
    }

    @Override
    public int getLayoutId() {
        return R.layout.test_app_base_layout_olivesdk;
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        switch (item.getItemId()) {
            case 16908332: {
                this.finish();
            }
        }
        return super.onOptionsItemSelected(item);
    }

    protected void onPause() {
        super.onPause();
        if (!this.forceClosed) {
            OliveBoardTestTimer.getInstance().pause();
        }
    }

    @Override
    protected void onResume() {
        super.onResume();
        OliveBoardTestTimer.getInstance().resume();
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        if (!this.forceClosed) {
            OliveBoardTestTimer.getInstance().resume();
        }
        try {
            MainEventBus.getInstance().unregister((Object)this);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Subscribe
    public void forceStopFilter(CloseFilter closefilter) {
        this.forceClosed = true;
        this.finish();
    }
}

