package in.oliveboard.sdk.ui;

import android.annotation.TargetApi;
import android.os.Build;
import android.os.Bundle;
import android.support.design.widget.Snackbar;
import android.support.design.widget.TextInputLayout;
import android.support.v7.widget.Toolbar;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.view.LayoutInflater;
import android.view.View;
import android.view.WindowManager;
import android.widget.Button;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.Toast;

import java.util.HashMap;
import java.util.Map;

import in.oliveboard.sdk.R;
import in.oliveboard.sdk.presenter.AuthPresenter;
import in.oliveboard.sdk.presenter.interfaces.AuthContract;
import in.oliveboard.sdk.ui.base.BaseActivity;
import in.oliveboard.sdk.utils.Constants;
import in.oliveboard.sdk.utils.Utils;

public class ForgotPasswordActivity extends BaseActivity implements AuthContract.View{
    LinearLayout view_parent;
    Toolbar toolbar;
    EditText mEditText;
    TextInputLayout mInput;
    Button mSubmit;
    private String  in_email;
    AuthPresenter presenter  = new AuthPresenter();
    @Override
    protected void initializeDagger() {

        toolbar = findViewById(R.id.toolbar);
        mEditText = findViewById(R.id.input_forgot_email);
        mInput = findViewById(R.id.input_layout_forgot_email);

        view_parent = findViewById(R.id.parent_view);
        mSubmit = findViewById(R.id.btn_submit);

        setSupportActionBar(toolbar);
        toolbar.setNavigationIcon(R.drawable.icon_toolbar);
        setBackEnabled(true);
        setTitle("Change password?");
        mEditText.addTextChangedListener(new MyTextWatcher(mEditText));

        mSubmit.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                if(!validateForm())return;
                if(Utils.isConnectionAvailable(ForgotPasswordActivity.this)) {
                    if(presenter!=null) {
                        showProgressDialog(getString(R.string.str_please_wait));

                        Map<String, String> map = new HashMap<String, String>();
                        map.put("e", in_email);
                        presenter.onUserChangePassword(map);
                    }
                    else
                    {
                        Snackbar.make(view, "Reopen this page and try again", Snackbar.LENGTH_LONG).show();

//                    Toast.makeText(getApplicationContext(),"Reopen this page and try again",1).show();
                    }
                }else {
                    Snackbar.make(view, Constants.ERROR_INTERNET_STATUS, Snackbar.LENGTH_LONG).show();
                }
            }
        });
    }

    @Override
    protected void savedInstance(Bundle savedInstanceState) {

    }

    @Override
    protected void initializePresenter() {
        super.presenter=presenter;
        presenter.setView(this);
    }

    @Override
    public int getLayoutId() {
        return R.layout.activity_forgot_pwd_olivesdk;
    }




    @Override
    public void loginSuccess(String token) {
        hideProgressDialog();

        if(token.equalsIgnoreCase("1")){

            LayoutInflater inflater = LayoutInflater.from(ForgotPasswordActivity.this);
            View inflatedLayout= inflater.inflate(R.layout.activity_pwd_reset_olivesdk, null, false);
            Button b=inflatedLayout.findViewById(R.id.btn_go_back);
            b.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View view) {
                    ForgotPasswordActivity.this.finish();
                }
            });
            view_parent.removeAllViews();
            view_parent.addView(inflatedLayout);
        }
    }

    @Override
    public void onFailed() {
        hideProgressDialog();
        Utils.showToast(ForgotPasswordActivity.this,"Email not registered");
    }

    @Override
    public void onFailed(String message) {
        Toast.makeText(getApplicationContext(),"Please try again",Toast.LENGTH_SHORT).show();

    }

    @Override
    public void onAuthFailed() {

    }

    @Override
    public void onLoginSuccess(Object responseModel) {

    }

    private class MyTextWatcher implements TextWatcher {

        private View view;

        private MyTextWatcher(View view) {
            this.view = view;
        }

        public void beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {
        }

        public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {
        }

        public void afterTextChanged(Editable editable) {
            int i = view.getId();
            if (i == R.id.input_forgot_email) {

            }
        }
    }
    @TargetApi(Build.VERSION_CODES.LOLLIPOP)
    public boolean validateForm(){
        return validateEmail();
    }
    private boolean validateEmail() {
        in_email = mEditText.getEditableText().toString().trim();


        if (in_email.isEmpty() || !isValidEmail(in_email)) {
            mInput.setError(getString(R.string.err_msg_email));
            requestFocus(mEditText);
            return false;
        } else {
            mInput.setErrorEnabled(false);
        }

        return true;
    }



    private static boolean isValidEmail(String email) {
        return !TextUtils.isEmpty(email) && android.util.Patterns.EMAIL_ADDRESS.matcher(email).matches();
    }

    private void requestFocus(View view) {
        if (view.requestFocus()) {
            getWindow().setSoftInputMode(WindowManager.LayoutParams.SOFT_INPUT_STATE_ALWAYS_VISIBLE);

        }
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
    }
}
