package in.oliveboard.sdk.ui;


import android.graphics.Typeface;
import android.os.Bundle;
import android.support.design.widget.TabLayout;
import android.support.v4.view.ViewPager;
import android.support.v7.widget.Toolbar;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

import in.oliveboard.sdk.R;
import in.oliveboard.sdk.ui.adapters.FilterFragmentAdapter;
import in.oliveboard.sdk.ui.base.BaseActivity;
import in.oliveboard.sdk.utils.Constants;

public class SolutionAppFilterActivity extends BaseActivity {
    Toolbar toolbar;
    TabLayout tabs;
    ViewPager viewPager;
    private FilterFragmentAdapter adapter;

    @Override
    protected void initializeDagger() {

        toolbar = findViewById(R.id.toolbar);
        tabs = findViewById(R.id.tabs);
        viewPager = findViewById(R.id.viewpager);

        setSupportActionBar(toolbar);

        toolbar.setNavigationIcon(R.drawable.ic_close_black_24dp);
        adapter = new FilterFragmentAdapter(getSupportFragmentManager(), Constants.FILTER_SOLUTION_APP);

        viewPager.setAdapter(adapter);
        tabs.setupWithViewPager(viewPager);
        final Typeface selectedFont = Typeface.createFromAsset(getAssets(), "fonts/SF-UI-Display_Heavy_Cyrillic.otf");
        final Typeface unselectedFont = Typeface.createFromAsset(getAssets(), "fonts/SF-UI-Display_Medium_Cyrillic.otf");

        ViewGroup vg = (ViewGroup) tabs.getChildAt(0);
        int tabsCount = vg.getChildCount();
        for (int j = 0; j < tabsCount; j++) {
            ViewGroup vgTab = (ViewGroup) vg.getChildAt(j);
            int tabChildsCount = vgTab.getChildCount();
            for (int i = 0; i < tabChildsCount; i++) {
                View tabViewChild = vgTab.getChildAt(i);
                if (tabViewChild instanceof TextView) {
                    if (j > 0) {
                        ((TextView) tabViewChild).setTypeface(unselectedFont);
                    } else {
                        ((TextView) tabViewChild).setTypeface(selectedFont);

                    }
                }
            }
        }
        tabs.addOnTabSelectedListener(new TabLayout.OnTabSelectedListener() {
            @Override
            public void onTabSelected(TabLayout.Tab tab) {
                ViewGroup vg = (ViewGroup) tabs.getChildAt(0);
                ViewGroup vgTab = (ViewGroup) vg.getChildAt(tab.getPosition());
                int tabChildsCount = vgTab.getChildCount();
                for (int i = 0; i < tabChildsCount; i++) {
                    View tabViewChild = vgTab.getChildAt(i);
                    if (tabViewChild instanceof TextView) {
                        ((TextView) tabViewChild).setTypeface(selectedFont);
                    }
                }
            }

            @Override
            public void onTabUnselected(TabLayout.Tab tab) {
                ViewGroup vg = (ViewGroup) tabs.getChildAt(0);
                ViewGroup vgTab = (ViewGroup) vg.getChildAt(tab.getPosition());
                int tabChildsCount = vgTab.getChildCount();
                for (int i = 0; i < tabChildsCount; i++) {
                    View tabViewChild = vgTab.getChildAt(i);
                    if (tabViewChild instanceof TextView) {
                        ((TextView) tabViewChild).setTypeface(unselectedFont);
                    }
                }
            }

            @Override
            public void onTabReselected(TabLayout.Tab tab) {

            }
        });

        //LogEvents.getInstance().passEvents(getApplicationContext(),"SolutionFilter","view_page");

    }

    @Override
    protected void savedInstance(Bundle savedInstanceState) {

    }

    @Override
    protected void initializePresenter() {

    }

    @Override
    public int getLayoutId() {
        return R.layout.test_app_base_layout_olivesdk;
    }








}
