package in.oliveboard.sdk.utils;

import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.graphics.Typeface;
import android.os.Build;
import android.provider.Settings;
import android.support.v4.app.ActivityCompat;
import android.support.v4.app.Fragment;
import android.support.v7.app.AppCompatActivity;
import android.telephony.TelephonyManager;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

import in.oliveboard.sdk.presenter.model.SessionOut;
import in.oliveboard.sdk.ui.LoginOliveBoardActivity;

public class BasicConfig {
    public static BasicConfig basicConfig;
    public static synchronized BasicConfig getInstance() {
        if (basicConfig == null) {
            basicConfig = new BasicConfig();
        }
        return basicConfig;
    }

    public String getVersion(Context mContext)
    {
//        String version= BuildConfig.VERSION_NAME;
        String version="2.2.0.9";
       /* try {
            version=mContext.getPackageManager().getPackageInfo(mContext.getPackageName(), 0).versionName;
        } catch (PackageManager.NameNotFoundException e) {
        e.printStackTrace();
    }*/
        return version;
    }

    public String getAuthData(Context mContext)
    {
        return new AppPreferences(mContext,Constants.PREF_NAME).getData(Constants.KEY_TOKEN);
    }

    public String getAuthEmail(Context mContext)
    {
        return new AppPreferences(mContext,Constants.PREF_NAME).getData(Constants.KEY_EMAIL);
    }

    public String getAuthPassword(Context mContext)
    {
        return new AppPreferences(mContext,Constants.PREF_NAME).getData(Constants.KEY_PASSWORD);
    }

    public boolean isLogin(Context mContext)
    {
        return new AppPreferences(mContext,Constants.PREF_NAME).getBoolean(Constants.IS_LOGIN);
    }


    public String getDeviceId(Context mContext) {
        try {


        String devId = "";
        TelephonyManager telephony = (TelephonyManager) mContext.getSystemService(Context.TELEPHONY_SERVICE);
        if (null != telephony && null != telephony.getDeviceId()) {
            devId = telephony.getDeviceId();
        } else {
            devId = Settings.Secure.getString(mContext.getContentResolver(), Settings.Secure.ANDROID_ID);
        }
        try {
            devId = getmd5Checksum(devId,false);
        } catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        return devId;
        }
        catch (Exception e)
        {
            return "no_id";
        }
    }
    public String getmd5Checksum(String email,boolean isSocialLogin) throws NoSuchAlgorithmException {
        String key = email;
        if(isSocialLogin)
        {
            key=email+"OLIVEANDROID";
        }
        MessageDigest md = MessageDigest.getInstance("MD5");
        md.update(key.getBytes());

        byte byteData[] = md.digest();

        //convert the byte to hex format method 1
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < byteData.length; i++) {
            sb.append(Integer.toString((byteData[i] & 0xff) + 0x100, 16).substring(1));
        }
        //convert the byte to hex format method 2
        StringBuffer hexString = new StringBuffer();
        for (int i = 0; i < byteData.length; i++) {
            String hex = Integer.toHexString(0xff & byteData[i]);
            if (hex.length() == 1) hexString.append('0');
            hexString.append(hex);
        }

        return hexString.toString();
    }

    public void apply(ViewGroup vg,String font,Context context)
    {
        try {
            Typeface type = Typeface.createFromAsset(context.getAssets(), font);

            for (int i = 0; i < vg.getChildCount(); ++i) {
                View v = vg.getChildAt(i);
                if (v instanceof TextView)
                    ((TextView) v).setTypeface(type);
                else if (v instanceof ViewGroup)
                    apply((ViewGroup) v, font, context);
            }
        }
        catch (NullPointerException e)
        {

        }
    }

    public String timeLeft(String time)
    {
        String[] h1=time.split(":");

        return Integer.toString(Integer.parseInt(h1[2]) + (60 * Integer.parseInt(h1[1])) + (3600 * Integer.parseInt(h1[0])));

    }

    public void onAuthFailed(AppCompatActivity context) {

        ActivityCompat.finishAffinity(context);
        context.startActivity(new Intent(context,LoginOliveBoardActivity.class).putExtra(Constants.BUNDLE_AUTH_ERROR,true));
        if (Build.VERSION.SDK_INT <= Build.VERSION_CODES.ICE_CREAM_SANDWICH_MR1) {

            MainEventBus.getInstance().post(new SessionOut());

        }

    }

    public void onAuthFailed(Fragment context) {
        ActivityCompat.finishAffinity(context.getActivity());
        context.startActivity(new Intent(context.getActivity(),LoginOliveBoardActivity.class).putExtra(Constants.BUNDLE_AUTH_ERROR,true));

        if (Build.VERSION.SDK_INT <= Build.VERSION_CODES.ICE_CREAM_SANDWICH_MR1) {
            MainEventBus.getInstance().post(new SessionOut());

        }
    }
}
