package in.oliveboard.sdk.ui.adapters;

import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentStatePagerAdapter;

import in.oliveboard.sdk.ui.fragments.SolutionAppFilterFragment;
import in.oliveboard.sdk.ui.fragments.TestAppFilterFragment;
import in.oliveboard.sdk.utils.Constants;

public class FilterFragmentAdapter extends FragmentStatePagerAdapter {
    int filterType;
    public FilterFragmentAdapter(FragmentManager fm, int filterType) {
        super(fm);
        this.filterType=filterType;
    }

    @Override
    public Fragment getItem(int position) {

        if(filterType== Constants.FILTER_TEST_APP) {
            return TestAppFilterFragment.newInstance(position);
        }
        else
        {
            return SolutionAppFilterFragment.newInstance(position);
        }
    }

    @Override
    public int getCount() {
        if(filterType== Constants.FILTER_TEST_APP) {
            return Constants.FILTER_TEST_ARRAY.length;
        }
        else
        {
            return Constants.FILTER_SOLUTION_ARRAY.length;
        }
    }
    @Override
    public CharSequence getPageTitle(int position) {

        if(filterType== Constants.FILTER_TEST_APP) {
            return Constants.FILTER_TEST_ARRAY[position];        }
        else
        {
            return Constants.FILTER_SOLUTION_ARRAY[position];
        }
    }
}
