/*
 * Decompiled with CFR 0.152.
 */
package in.oliveboard.sdk.ui.fragments;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresApi;
import android.support.v4.app.Fragment;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import in.oliveboard.sdk.R;
import in.oliveboard.sdk.presenter.model.FilterModel;
import in.oliveboard.sdk.presenter.model.TestAppModel;
import in.oliveboard.sdk.ui.adapters.TestFilterAdapter;
import in.oliveboard.sdk.utils.Constants;
import in.oliveboard.sdk.utils.FilterAsyncTask;
import in.oliveboard.sdk.utils.FilterInterface;
import in.oliveboard.sdk.utils.LargeAppInfo;
import in.oliveboard.sdk.utils.RecyclerItemClickListener;
import java.util.ArrayList;

public class TestAppFilterFragment
extends Fragment
implements FilterInterface {
    RecyclerView recyclerView;
    ArrayList<TestAppModel> filterArrayList = new ArrayList();
    ArrayList<TestAppModel> questionDataList;

    public static TestAppFilterFragment newInstance(int index) {
        TestAppFilterFragment fragment = new TestAppFilterFragment();
        Bundle args = new Bundle();
        args.putInt(Constants.INDEX, index);
        fragment.setArguments(args);
        return fragment;
    }

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
    }

    public View onCreateView(@NonNull LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View v = inflater.inflate(R.layout.recycler_fragment, container, false);
        this.recyclerView = (RecyclerView)v.findViewById(R.id.recycler_view_fragment);
        return v;
    }

    @TargetApi(value=19)
    public void onActivityCreated(@Nullable Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        this.questionDataList = LargeAppInfo.getInstance().getBaseFilterArray();
        if (this.questionDataList != null) {
            assert (this.getArguments() != null);
            if (this.getArguments().getInt(Constants.INDEX) == 0) {
                this.filterArrayList.clear();
                this.filterArrayList.addAll(this.questionDataList);
                TestFilterAdapter adapter = new TestFilterAdapter(this.filterArrayList, (Context)this.getActivity(), this.getArguments().getInt(Constants.INDEX), LargeAppInfo.getInstance().getLanguageType());
                this.recyclerView.setAdapter((RecyclerView.Adapter)adapter);
                this.recyclerView.setHasFixedSize(true);
                this.recyclerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager((Context)this.getActivity()));
            } else if (this.getArguments().getInt(Constants.INDEX) == 1) {
                new FilterAsyncTask(1, 1, this.questionDataList, this, 0).execute(new Void[0]);
            } else if (this.getArguments().getInt(Constants.INDEX) == 2) {
                new FilterAsyncTask(1, 2, this.questionDataList, this, 0).execute(new Void[0]);
            } else if (this.getArguments().getInt(Constants.INDEX) == 3) {
                new FilterAsyncTask(1, 3, this.questionDataList, this, 0).execute(new Void[0]);
            }
            this.recyclerView.addOnItemTouchListener((RecyclerView.OnItemTouchListener)new RecyclerItemClickListener((Context)this.getActivity(), this.recyclerView, new RecyclerItemClickListener.OnItemClickListener(){

                @Override
                public void onItemClick(View view, int position) {
                    Intent returnIntent = new Intent();
                    returnIntent.putExtra("com.activity.result.filter.type", TestAppFilterFragment.this.getArguments().getInt(Constants.INDEX));
                    returnIntent.putExtra("com.act.result.pos.filter", position);
                    TestAppFilterFragment.this.getActivity().setResult(-1, returnIntent);
                    TestAppFilterFragment.this.getActivity().finish();
                }

                @Override
                public void onItemLongClick(View view, int position) {
                }
            }));
        }
    }

    @Override
    @RequiresApi(api=19)
    public void ongetFilterResult(ArrayList<FilterModel> filterData, int position) {
        if (filterData != null && filterData.size() > 0) {
            this.filterArrayList.clear();
            this.filterArrayList.addAll(filterData.get(0).getFilterArrayList());
            assert (this.getArguments() != null);
            TestFilterAdapter adapter = new TestFilterAdapter(this.filterArrayList, (Context)this.getActivity(), this.getArguments().getInt(Constants.INDEX), LargeAppInfo.getInstance().getLanguageType());
            this.recyclerView.setAdapter((RecyclerView.Adapter)adapter);
            this.recyclerView.setHasFixedSize(true);
            this.recyclerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager((Context)this.getActivity()));
        }
    }
}

