/*
 * Decompiled with CFR 0.152.
 */
package in.oliveboard.sdk.ui.fragments;

import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.CookieManager;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.ProgressBar;
import in.oliveboard.sdk.R;
import in.oliveboard.sdk.ui.base.BaseFragment;
import in.oliveboard.sdk.utils.BaseSharedPreferences;
import in.oliveboard.sdk.utils.BasicConfig;
import in.oliveboard.sdk.utils.Constants;
import in.oliveboard.sdk.utils.Utils;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PlanFragment
extends BaseFragment {
    WebView webView;
    ProgressBar progressBar;
    BaseSharedPreferences baseSharedPreferences;

    @Override
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        super.onCreateView(inflater, container, savedInstanceState);
        this.view = inflater.inflate(this.getLayoutId(), container, false);
        if (this.presenter != null) {
            this.presenter.initialize(this.getArguments());
        }
        this.webView = (WebView)this.view.findViewById(R.id.webView);
        this.progressBar = (ProgressBar)this.view.findViewById(R.id.progressbar_layer);
        return this.view;
    }

    @Override
    protected void initializeDagger() {
    }

    @Override
    protected void initializePresenter() {
    }

    @Override
    protected void initializeActivity() {
        if (Utils.isConnectionAvailable((Context)this.getActivity())) {
            WebSettings webSettings = this.webView.getSettings();
            webSettings.setJavaScriptEnabled(true);
            this.webView.getSettings().setLoadWithOverviewMode(true);
            this.webView.getSettings().setUseWideViewPort(true);
            this.webView.setScrollBarStyle(0x2000000);
            this.webView.setScrollbarFadingEnabled(false);
            this.webView.getSettings().setSaveFormData(false);
            this.webView.setWebViewClient(new WebViewClient(){

                public boolean shouldOverrideUrlLoading(WebView view, String url) {
                    if (PlanFragment.isYoutube(url)) {
                        try {
                            Intent intent = new Intent("android.intent.action.VIEW");
                            intent.setData(Uri.parse((String)url));
                            PlanFragment.this.startActivity(intent);
                        }
                        catch (Exception e) {
                            CookieManager.getInstance().setCookie(url, "uauth=" + BasicConfig.getInstance().getAuthData(PlanFragment.this.getContext()));
                            view.loadUrl(url);
                        }
                    } else {
                        CookieManager.getInstance().setCookie(url, "uauth=" + BasicConfig.getInstance().getAuthData(PlanFragment.this.getContext()));
                        view.loadUrl(url);
                    }
                    return true;
                }

                public void onPageStarted(WebView view, String url, Bitmap favicon) {
                }

                public void onPageFinished(WebView view, String url) {
                    if (PlanFragment.this.isAdded()) {
                        PlanFragment.this.progressBar.setVisibility(8);
                    }
                }
            });
            this.webView.loadUrl(this.getArguments().getString(Constants.BUNDLE_KEY_PAYMENT_URL));
            this.webView.setOnKeyListener(new View.OnKeyListener(){

                public boolean onKey(View v, int keyCode, KeyEvent event) {
                    if (keyCode == 4 && event.getAction() == 1 && PlanFragment.this.webView.canGoBack()) {
                        PlanFragment.this.webView.goBack();
                        return true;
                    }
                    return false;
                }
            });
        } else {
            Utils.showToast((Context)this.getActivity(), "No internet connection");
        }
    }

    @Override
    public int getLayoutId() {
        return R.layout.fragment_plan;
    }

    public static PlanFragment newInstance(String paymentUrl) {
        Bundle bundleData = new Bundle();
        bundleData.putString(Constants.BUNDLE_KEY_PAYMENT_URL, paymentUrl);
        PlanFragment planFragment = new PlanFragment();
        planFragment.setArguments(bundleData);
        return planFragment;
    }

    public static boolean isYoutube(String youtubeUrl) {
        if (youtubeUrl == null || youtubeUrl.trim().contentEquals("")) {
            return false;
        }
        youtubeUrl = youtubeUrl.trim();
        String regexPattern = "^(?:https?:\\/\\/)?(?:[0-9A-Z-]+\\.)?(?:youtu\\.be\\/|youtube\\.com\\S*[^\\w\\-\\s])([\\w\\-]{11})(?=[^\\w\\-]|$)(?![?=&+%\\w]*(?:['\"][^<>]*>|<\\/a>))[?=&+%\\w]*";
        Pattern regexCompiled = Pattern.compile(regexPattern, 2);
        Matcher regexMatcher = regexCompiled.matcher(youtubeUrl);
        return regexMatcher.find();
    }
}

