/*
 * Decompiled with CFR 0.152.
 */
package in.oliveboard.sdk.ui;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.design.widget.FloatingActionButton;
import android.support.v4.app.Fragment;
import android.support.v4.content.ContextCompat;
import android.support.v7.widget.SwitchCompat;
import android.support.v7.widget.Toolbar;
import android.view.MenuItem;
import android.view.View;
import android.widget.Button;
import android.widget.CompoundButton;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import android.widget.Toast;
import com.google.gson.Gson;
import com.squareup.otto.Subscribe;
import in.oliveboard.sdk.R;
import in.oliveboard.sdk.databases.OliveBoardDb;
import in.oliveboard.sdk.log.DebugMonitor;
import in.oliveboard.sdk.presenter.TestPresenter;
import in.oliveboard.sdk.presenter.interfaces.CommonContract;
import in.oliveboard.sdk.presenter.model.CacheTestInfo;
import in.oliveboard.sdk.presenter.model.ChangeLanguage;
import in.oliveboard.sdk.presenter.model.ClearTest;
import in.oliveboard.sdk.presenter.model.CloseFilter;
import in.oliveboard.sdk.presenter.model.FilterModel;
import in.oliveboard.sdk.presenter.model.PauseTestData;
import in.oliveboard.sdk.presenter.model.PauseTestInfo;
import in.oliveboard.sdk.presenter.model.SectionKeyValue;
import in.oliveboard.sdk.presenter.model.SessionInfo;
import in.oliveboard.sdk.presenter.model.SubmitTestInfo;
import in.oliveboard.sdk.presenter.model.TestAppModel;
import in.oliveboard.sdk.presenter.model.TestResponseModel;
import in.oliveboard.sdk.presenter.model.TestStatusEventModel;
import in.oliveboard.sdk.timer.Counter;
import in.oliveboard.sdk.timer.OliveBoardTestTimer;
import in.oliveboard.sdk.timer.TimerStatus;
import in.oliveboard.sdk.timer.listener.TimerListener;
import in.oliveboard.sdk.ui.SummeryActivity;
import in.oliveboard.sdk.ui.TestAppFilterActivity;
import in.oliveboard.sdk.ui.TestSectionActivity;
import in.oliveboard.sdk.ui.base.BaseActivity;
import in.oliveboard.sdk.ui.fragments.TestModuleViewPagerFragment;
import in.oliveboard.sdk.utils.BasicConfig;
import in.oliveboard.sdk.utils.Constants;
import in.oliveboard.sdk.utils.DialogUtils;
import in.oliveboard.sdk.utils.FilterQuestions;
import in.oliveboard.sdk.utils.LargeAppInfo;
import in.oliveboard.sdk.utils.MainEventBus;
import in.oliveboard.sdk.utils.SubmitDialogCalled;
import in.oliveboard.sdk.utils.TestDataChangeListener;
import in.oliveboard.sdk.utils.onDialogUtilCalled;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.TreeMap;

public class TestModuleActivity
extends BaseActivity
implements CommonContract.View,
onDialogUtilCalled,
TimerListener,
TestDataChangeListener,
View.OnClickListener {
    ImageView pauseFab;
    RelativeLayout typeRelative;
    LinearLayout typeBottom;
    FloatingActionButton filterFab;
    LinearLayout timerLayout;
    TextView timerTextView;
    Toolbar toolbar;
    View quickActionLineView;
    TextView examNameToolbarTextView;
    TextView typeTextView;
    ImageView im;
    SwitchCompat languageSwitch;
    TextView hindiTextView;
    TextView englishTextView;
    LinearLayout languageSwitchLayout;
    Button nextButton;
    Button submitButton;
    public static final int FILTER_TYPE = 1002;
    boolean testStartPermissionEnabled = false;
    ArrayList<TestAppModel> questionAnswerInfo = new ArrayList();
    ArrayList<TestAppModel> filterQuestionArrayList = new ArrayList();
    int selectedOption = 0;
    ArrayList<String> sessionTimeList = new ArrayList();
    ArrayList<SessionInfo> filterSessionTime = new ArrayList();
    boolean canStopTimer = true;
    TreeMap<Integer, SectionKeyValue> questionSet = new TreeMap();
    boolean isTestStarted = false;
    String submitUrl = null;
    String solutionUrl = null;
    String qpi = null;
    String ppi = null;
    String pauseUrl;
    int questionPosition = 0;
    boolean isForcePaused = false;
    boolean exitApp = false;
    boolean backPressExit = false;
    boolean selfStopTimershown = false;
    TestPresenter presenter = new TestPresenter();

    @Override
    protected void initializeDagger() {
    }

    @Override
    protected void savedInstance(Bundle savedInstanceState) {
        this.timerTextView = (TextView)this.findViewById(R.id.timer_text_view);
        this.toolbar = (Toolbar)this.findViewById(R.id.toolbar);
        this.quickActionLineView = this.findViewById(R.id.fine_line_view);
        this.examNameToolbarTextView = (TextView)this.findViewById(R.id.test_txt);
        this.typeTextView = (TextView)this.findViewById(R.id.type_text_view);
        this.im = (ImageView)this.findViewById(R.id.section);
        this.languageSwitch = (SwitchCompat)this.findViewById(R.id.switch_language);
        this.hindiTextView = (TextView)this.findViewById(R.id.hindi_txt);
        this.englishTextView = (TextView)this.findViewById(R.id.english_txt);
        this.languageSwitchLayout = (LinearLayout)this.findViewById(R.id.language_switch_layout);
        this.nextButton = (Button)this.findViewById(R.id.next_btn);
        this.submitButton = (Button)this.findViewById(R.id.submit_btn);
        this.pauseFab = (ImageView)this.findViewById(R.id.pause_icon);
        this.typeRelative = (RelativeLayout)this.findViewById(R.id.type_relative);
        this.typeBottom = (LinearLayout)this.findViewById(R.id.type_bottam);
        this.filterFab = (FloatingActionButton)this.findViewById(R.id.filter_fab);
        this.timerLayout = (LinearLayout)this.findViewById(R.id.timer_submit_layout);
        this.typeTextView.setOnClickListener((View.OnClickListener)this);
        this.typeRelative.setOnClickListener((View.OnClickListener)this);
        this.typeBottom.setOnClickListener((View.OnClickListener)this);
        this.im.setOnClickListener((View.OnClickListener)this);
        this.filterFab.setOnClickListener((View.OnClickListener)this);
        this.timerLayout.setOnClickListener((View.OnClickListener)this);
        this.submitButton.setOnClickListener((View.OnClickListener)this);
        this.nextButton.setOnClickListener((View.OnClickListener)this);
        if (savedInstanceState != null && savedInstanceState.containsKey("id") && savedInstanceState.getString("id") != null) {
            CacheTestInfo dataValue = OliveBoardDb.getInstance(this.getApplicationContext()).getTestInfo(savedInstanceState.getString("id"));
            OliveBoardDb.getInstance(this.getApplicationContext()).close();
            if (dataValue != null) {
                LargeAppInfo.getInstance().setCanEndSession(true);
                LargeAppInfo.getInstance().setQuestionAnswerInfo(dataValue.getQuestionInfo());
                LargeAppInfo.getInstance().setQuestionSet(dataValue.getQuestionSet());
                LargeAppInfo.getInstance().setPanesList(dataValue.getPanes());
                this.filterSessionTime = dataValue.getFilterSessionArrayList();
                DebugMonitor.getLogger().d("init", "yez-------dataValue !");
                OliveBoardTestTimer.getInstance().init(this.timerTextView, new Counter.CounterBuilder(Long.parseLong(dataValue.getTimeleft())).build(), this).setTime();
                this.submitUrl = dataValue.getSubmitUrl();
                this.solutionUrl = dataValue.getSolutionUrl();
                this.qpi = dataValue.getQpi();
                this.ppi = dataValue.getPpi();
                this.pauseUrl = dataValue.getPauseUrl();
                try {
                    OliveBoardTestTimer.getInstance().startTimer(false);
                    DebugMonitor.getLogger().d("init", "yez-------After dataValue !");
                    this.testStartPermissionEnabled = true;
                    this.isTestStarted = true;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                LargeAppInfo.getInstance().setLanguageType(dataValue.getLanguage());
                if (LargeAppInfo.getInstance().getLanguageType() == 1) {
                    this.languageSwitch.setChecked(true);
                }
                this.sessionTimeList.add(savedInstanceState.getString("last_time"));
            }
            this.examNameToolbarTextView.setText((CharSequence)savedInstanceState.getString("id"));
        } else if (LargeAppInfo.getInstance().getQuestionInfo() != null && LargeAppInfo.getInstance().getQuestionInfo().pauseData != null && LargeAppInfo.getInstance().getQuestionInfo().pauseData.tdata.containsKey("0")) {
            this.filterSessionTime = LargeAppInfo.getInstance().getQuestionInfo().pauseData.tdata.get("0").getSessionInfo();
        }
        TestResponseModel testInfo = LargeAppInfo.getInstance().getQuestionInfo();
        this.questionAnswerInfo = LargeAppInfo.getInstance().getQuestionAnswerInfo();
        if (testInfo != null) {
            LargeAppInfo.getInstance().switchToPauseQuestion(testInfo.switchToQuestion);
        }
        LargeAppInfo.getInstance().setExamRunning(true);
        if (this.questionAnswerInfo != null) {
            if (testInfo != null) {
                LargeAppInfo.getInstance().setPanesList(testInfo.panes);
                this.examNameToolbarTextView.setText((CharSequence)testInfo.questionId);
                LargeAppInfo.getInstance().setCanEndSession(false);
                this.submitUrl = testInfo.submitUrl;
                this.solutionUrl = testInfo.solutionUrl;
                this.pauseUrl = testInfo.pauseUrl;
                this.qpi = testInfo.questionQpi;
                this.ppi = testInfo.partId;
                DebugMonitor.getLogger().d("ppi>>>>", this.ppi + ">>>");
                if (this.getIntent().getExtras() != null && !this.getIntent().getExtras().containsKey(Constants.PART_TEST)) {
                    DebugMonitor.getLogger().d("init", "yez-------testInfo !");
                    OliveBoardTestTimer.getInstance().init(this.timerTextView, new Counter.CounterBuilder(testInfo.settings.totalTime).build(), this).setTime();
                    DialogUtils.getInstance().startTestDialog(this, testInfo, this, testInfo.pauseData != null);
                } else if (this.getIntent().getExtras() != null && this.getIntent().getExtras().containsKey(Constants.PART_TEST)) {
                    this.sessionTimeList.add(FilterQuestions.getInstance().getDurationString(LargeAppInfo.getInstance().getQuestionInfo().settings.totalTime));
                    DebugMonitor.getLogger().d("init", "yez-------else if !");
                    OliveBoardTestTimer.getInstance().init(this.timerTextView, new Counter.CounterBuilder(testInfo.settings.totalTime).build(), this).setTime();
                    try {
                        OliveBoardTestTimer.getInstance().startTimer(false);
                        this.isTestStarted = true;
                        DebugMonitor.getLogger().d("init", "yez-------After section iguess !");
                        this.testStartPermissionEnabled = true;
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            this.toolbar.setNavigationIcon(R.drawable.icon_toolbar);
            this.setSupportActionBar(this.toolbar);
            this.getSupportActionBar().setDisplayHomeAsUpEnabled(true);
            if (this.questionAnswerInfo != null && this.questionAnswerInfo.size() > 0) {
                if (LargeAppInfo.getInstance().getQuestionSet() != null) {
                    this.questionSet.putAll(LargeAppInfo.getInstance().getQuestionSet());
                }
                this.filterQuestionArrayList.addAll(this.questionAnswerInfo);
                LargeAppInfo.getInstance().setCurrentQuestionInfo(this.filterQuestionArrayList);
                this.setFragment(0);
            }
            this.typeTextView.setText((CharSequence)this.questionSet.get(this.selectedOption).getKey());
            this.languageSwitch.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener(){

                public void onCheckedChanged(CompoundButton compoundButton, boolean b) {
                    if (b) {
                        LargeAppInfo.getInstance().setLanguageType(1);
                        TestModuleActivity.this.englishTextView.setTextColor(ContextCompat.getColor((Context)TestModuleActivity.this.getApplicationContext(), (int)R.color.light_grey));
                        TestModuleActivity.this.hindiTextView.setTextColor(-16777216);
                        MainEventBus.getInstance().post((Object)new ChangeLanguage(1));
                    } else {
                        LargeAppInfo.getInstance().setLanguageType(0);
                        TestModuleActivity.this.englishTextView.setTextColor(-16777216);
                        TestModuleActivity.this.hindiTextView.setTextColor(ContextCompat.getColor((Context)TestModuleActivity.this.getApplicationContext(), (int)R.color.light_grey));
                        MainEventBus.getInstance().post((Object)new ChangeLanguage(0));
                    }
                }
            });
            if (this.solutionUrl != null && this.solutionUrl.equals("0")) {
                this.nextButton.setVisibility(0);
                this.submitButton.setVisibility(8);
            } else {
                this.submitButton.setVisibility(0);
                this.nextButton.setVisibility(8);
            }
            if (this.examNameToolbarTextView != null) {
                // empty if block
            }
        } else {
            LargeAppInfo.getInstance().setExamRunning(false);
            this.finish();
        }
        if (this.pauseUrl != null && this.pauseUrl.length() > 2) {
            this.pauseFab.setVisibility(0);
        } else {
            this.pauseFab.setVisibility(8);
        }
        this.pauseFab.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                TestModuleActivity.this.isForcePaused = true;
                if (TestModuleActivity.this.testStartPermissionEnabled && TestModuleActivity.this.canStopTimer) {
                    TestModuleActivity.this.canStopTimer = false;
                    OliveBoardTestTimer.getInstance().pause();
                }
                DialogUtils.getInstance().pauseOrResumeTest(TestModuleActivity.this, TestModuleActivity.this, "Pause Test ?", "Are you sure you want to pause your test ?", "OK", "Cancel");
            }
        });
    }

    @Override
    protected void initializePresenter() {
        ((BaseActivity)this).presenter = this.presenter;
        this.presenter.setView(this);
        try {
            MainEventBus.getInstance().register((Object)this);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public int getLayoutId() {
        return R.layout.activity_test_infinate;
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == 1002) {
            if (!this.canStopTimer) {
                if (this.sessionTimeList.size() > 0) {
                    this.sessionTimeList.add(this.timerTextView.getText().toString());
                    this.filterSessionTime.add(new SessionInfo(this.sessionTimeList));
                }
                this.canStopTimer = true;
                this.sessionTimeList.clear();
                this.sessionTimeList.add(this.timerTextView.getText().toString());
            }
            if (resultCode == -1) {
                if (data.getIntExtra("com.activity.result.filter.type", 0) == 0) {
                    this.selectedOption = 0;
                    this.filterQuestionArrayList.clear();
                    this.filterQuestionArrayList.addAll(this.questionAnswerInfo);
                    this.questionSet.clear();
                    this.questionSet.putAll(LargeAppInfo.getInstance().getQuestionSet());
                    LargeAppInfo.getInstance().setCurrentQuestionInfo(this.filterQuestionArrayList);
                    this.setFragment(data.getIntExtra("com.act.result.pos.filter", 0));
                } else if (data.getIntExtra("com.activity.result.filter.type", 0) == 3) {
                    this.selectedOption = 0;
                    ArrayList<FilterModel> dataFromFilter = null;
                    dataFromFilter = LargeAppInfo.getInstance().getSolutionfilter(3) == null ? FilterQuestions.getInstance().filter(this.questionAnswerInfo, 3) : LargeAppInfo.getInstance().getSolutionfilter(3);
                    this.filterQuestionArrayList.clear();
                    this.questionSet.clear();
                    this.questionSet.putAll(dataFromFilter.get(0).getSortOrder());
                    this.filterQuestionArrayList.addAll(dataFromFilter.get(0).getFilterArrayList());
                    LargeAppInfo.getInstance().setCurrentQuestionInfo(this.filterQuestionArrayList);
                    this.setFragment(data.getIntExtra("com.act.result.pos.filter", 0));
                } else if (data.getIntExtra("com.activity.result.filter.type", 0) == 1) {
                    this.selectedOption = 0;
                    ArrayList<FilterModel> dataFromFilter = null;
                    dataFromFilter = LargeAppInfo.getInstance().getSolutionfilter(1) == null ? FilterQuestions.getInstance().filter(this.questionAnswerInfo, 1) : LargeAppInfo.getInstance().getSolutionfilter(1);
                    this.filterQuestionArrayList.clear();
                    this.questionSet.clear();
                    this.questionSet.putAll(dataFromFilter.get(0).getSortOrder());
                    this.filterQuestionArrayList.addAll(dataFromFilter.get(0).getFilterArrayList());
                    LargeAppInfo.getInstance().setCurrentQuestionInfo(this.filterQuestionArrayList);
                    this.setFragment(data.getIntExtra("com.act.result.pos.filter", 0));
                } else if (data.getIntExtra("com.activity.result.filter.type", 0) == 2) {
                    this.selectedOption = 0;
                    ArrayList<FilterModel> dataFromFilter = null;
                    dataFromFilter = LargeAppInfo.getInstance().getSolutionfilter(2) == null ? FilterQuestions.getInstance().filter(this.questionAnswerInfo, 2) : LargeAppInfo.getInstance().getSolutionfilter(2);
                    this.filterQuestionArrayList.clear();
                    this.questionSet.clear();
                    this.questionSet.putAll(dataFromFilter.get(0).getSortOrder());
                    this.filterQuestionArrayList.addAll(dataFromFilter.get(0).getFilterArrayList());
                    LargeAppInfo.getInstance().setCurrentQuestionInfo(this.filterQuestionArrayList);
                    this.setFragment(data.getIntExtra("com.act.result.pos.filter", 0));
                }
            }
        }
    }

    @Override
    public void onTimerChanged(TimerStatus status) {
        if (status == TimerStatus.TIME_ENDING) {
            this.timerTextView.setTextColor(-65536);
        } else if (status == TimerStatus.FINISHED && !this.selfStopTimershown) {
            if (!this.canStopTimer) {
                MainEventBus.getInstance().post((Object)new CloseFilter());
            } else {
                MainEventBus.getInstance().post((Object)new SubmitDialogCalled());
            }
            this.selfStopTimershown = true;
            if (this.solutionUrl != null && this.solutionUrl.equals("0")) {
                DialogUtils.getInstance().selfStopDialog(this, this, true);
            } else {
                DialogUtils.getInstance().selfStopDialog(this, this, false);
            }
            LinkedHashMap<String, SubmitTestInfo> data = FilterQuestions.getInstance().getSummeryInfo(this.questionAnswerInfo).get(0).getSubmitMap();
            data.put("0", new SubmitTestInfo("0", "", this.filterSessionTime));
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("data", new Gson().toJson(data));
            params.put("qpi", this.qpi);
            if (this.ppi != null) {
                params.put("ppi", this.ppi);
            }
            try {
                OliveBoardTestTimer.getInstance().finish();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.presenter.callSubmitTest(this.submitUrl, params, (Context)this);
        }
    }

    @Override
    public void onLiveTimeRunning(String time) {
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        LargeAppInfo.getInstance().setExamRunning(false);
        if (this.presenter != null) {
            this.presenter.unSubscribe();
        }
        try {
            MainEventBus.getInstance().unregister((Object)this);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void onPause() {
        super.onPause();
        if (this.testStartPermissionEnabled && this.canStopTimer && !this.isForcePaused) {
            OliveBoardTestTimer.getInstance().pause();
        }
    }

    @Override
    protected void onResume() {
        super.onResume();
        if (this.testStartPermissionEnabled && this.canStopTimer && !this.isForcePaused) {
            OliveBoardTestTimer.getInstance().resume();
        }
    }

    @Override
    public void onChangeFavorite(int position, boolean isFav) {
        try {
            if (position >= 0 && this.questionAnswerInfo != null && position < this.questionAnswerInfo.size()) {
                this.questionAnswerInfo.get(position).setMarked(isFav);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void onChangeOptionSelection(int position, int selectedPosition) {
        try {
            if (position >= 0 && this.questionAnswerInfo != null && position < this.questionAnswerInfo.size()) {
                this.questionAnswerInfo.get(position).setSelectionOption(selectedPosition);
                if (selectedPosition != -1) {
                    ((TestModuleViewPagerFragment)this.getSupportFragmentManager().findFragmentByTag("com.tag.fragment")).nextQuestion(position + 1);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void onSessionReading(int position, String key) {
        try {
            if (position >= 0 && this.questionAnswerInfo != null && position < this.questionAnswerInfo.size()) {
                this.questionPosition = position;
                this.sessionTimeList.add(this.timerTextView.getText().toString());
                if (this.sessionTimeList.size() == 1) {
                    this.sessionTimeList.add(this.timerTextView.getText().toString());
                }
                this.questionAnswerInfo.get(position).setSessionData(this.sessionTimeList);
                String newStartTime = this.sessionTimeList.get(1);
                this.sessionTimeList.clear();
                this.sessionTimeList.add(newStartTime);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void onChangeQuestion(String key) {
        if (this.typeTextView != null && !this.typeTextView.getText().toString().equals(key)) {
            this.typeTextView.setText((CharSequence)key);
            this.selectedOption = FilterQuestions.getInstance().getQuestionSection(this.questionSet, key);
        }
    }

    @Override
    public void onLangaugeSwitchChange(boolean isVisible) {
        if (isVisible) {
            if (this.languageSwitchLayout.getVisibility() == 4) {
                this.languageSwitchLayout.setVisibility(0);
            }
        } else if (this.languageSwitchLayout.getVisibility() == 0) {
            this.languageSwitchLayout.setVisibility(4);
        }
    }

    @Override
    public void onChangeExpandData(int position, boolean isExpanded) {
        try {
            if (position >= 0 && this.questionAnswerInfo != null && position < this.questionAnswerInfo.size()) {
                this.questionAnswerInfo.get(position).setExpanded(isExpanded);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setFragment(int position) {
        this.getSupportFragmentManager().beginTransaction().replace(R.id.container, (Fragment)TestModuleViewPagerFragment.setInstance(position, false), "com.tag.fragment").commitAllowingStateLoss();
    }

    public void onBackPressed() {
        DialogUtils.getInstance().exitDialog(this, this);
    }

    protected void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        if (this.isTestStarted && this.timerTextView != null) {
            OliveBoardDb.getInstance(this.getApplicationContext()).insertTestInfo(LargeAppInfo.getInstance().getPanesList(), this.questionAnswerInfo, this.filterSessionTime, this.timerTextView.getText().toString(), this.examNameToolbarTextView != null ? this.examNameToolbarTextView.getText().toString() : "Test", LargeAppInfo.getInstance().getQuestionSet(), LargeAppInfo.getInstance().getLanguageType(), this.submitUrl, this.solutionUrl, this.qpi, this.pauseUrl, this.ppi);
            OliveBoardDb.getInstance(this.getApplicationContext()).close();
            if (this.examNameToolbarTextView != null) {
                outState.putString("id", this.examNameToolbarTextView.getText().toString());
            } else {
                outState.putString("id", "Test");
            }
            if (this.sessionTimeList.size() > 0 && this.sessionTimeList.get(0).length() > 0) {
                outState.putString("last_time", this.sessionTimeList.get(0));
            } else {
                outState.putString("last_time", this.timerTextView.getText().toString());
            }
        }
    }

    @Override
    public void onOptionDialogSelected(int position) {
        if (this.selectedOption != position) {
            this.selectedOption = position;
            this.typeTextView.setText((CharSequence)this.questionSet.get(this.selectedOption).getKey());
        }
        ((TestModuleViewPagerFragment)this.getSupportFragmentManager().findFragmentByTag("com.tag.fragment")).changePosition(this.questionSet.get(position).getPosition());
    }

    @Override
    public void onAutoDialogSelected() {
        LinkedHashMap<String, SubmitTestInfo> data = FilterQuestions.getInstance().getSummeryInfo(this.questionAnswerInfo).get(0).getSubmitMap();
        data.put("0", new SubmitTestInfo("0", "", this.filterSessionTime));
        this.showProgressDialog(this.getString(R.string.str_submit_test));
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("data", new Gson().toJson(data));
        params.put("qpi", this.qpi);
        if (this.ppi != null) {
            params.put("ppi", this.ppi);
        }
        try {
            OliveBoardTestTimer.getInstance().finish();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.presenter.callSubmitTest(this.submitUrl, params, (Context)this);
    }

    @Override
    public void onSubmitDialogSelected() {
        MainEventBus.getInstance().post((Object)new SubmitDialogCalled());
        LinkedHashMap<String, SubmitTestInfo> data = FilterQuestions.getInstance().getSummeryInfo(this.questionAnswerInfo).get(0).getSubmitMap();
        data.put("0", new SubmitTestInfo("0", "", this.filterSessionTime));
        this.showProgressDialog(this.getString(R.string.str_submit_test));
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("data", new Gson().toJson(data));
        params.put("qpi", this.qpi);
        DebugMonitor.getLogger().d("data", new Gson().toJson(data));
        if (this.ppi != null) {
            params.put("ppi", this.ppi);
        }
        try {
            OliveBoardTestTimer.getInstance().finish();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.presenter.callSubmitTest(this.submitUrl, params, (Context)this);
    }

    @Override
    public void onExitApp() {
        if (this.pauseUrl != null) {
            this.backPressExit = true;
            this.exitApp = true;
            this.showProgressDialog(this.getString(R.string.str_saving_test));
            this.isForcePaused = true;
            if (this.testStartPermissionEnabled && this.canStopTimer) {
                OliveBoardTestTimer.getInstance().pause();
            }
            MainEventBus.getInstance().post((Object)new SubmitDialogCalled());
            LinkedHashMap<String, PauseTestInfo> data = FilterQuestions.getInstance().getPauseTestInfo(this.questionAnswerInfo);
            data.put("0", new PauseTestInfo("0", "", this.filterSessionTime, ""));
            try {
                OliveBoardTestTimer.getInstance().finishOnPause();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.questionPosition >= 0 && this.questionPosition < this.questionAnswerInfo.size()) {
                this.presenter.callPauseTest(this.pauseUrl, new PauseTestData(data, BasicConfig.getInstance().timeLeft(this.timerTextView.getText().toString()), this.questionAnswerInfo.get(this.questionPosition).getQuestionId()), this.qpi, "0", this.ppi, (Context)this);
            } else if (this.questionAnswerInfo != null && this.questionAnswerInfo.size() > 0) {
                this.presenter.callPauseTest(this.pauseUrl, new PauseTestData(data, BasicConfig.getInstance().timeLeft(this.timerTextView.getText().toString()), this.questionAnswerInfo.get(0).getQuestionId()), this.qpi, "0", this.ppi, (Context)this);
            } else {
                this.hideProgressDialog();
            }
        } else {
            try {
                OliveBoardTestTimer.getInstance().finish();
            }
            catch (Exception exception) {
                // empty catch block
            }
            LargeAppInfo.getInstance().clearAllData();
            LargeAppInfo.getInstance().setExamRunning(false);
            this.finish();
        }
    }

    @Override
    public void onExitWithoutPause() {
        try {
            OliveBoardTestTimer.getInstance().finish();
        }
        catch (Exception exception) {
            // empty catch block
        }
        LargeAppInfo.getInstance().clearAllData();
        LargeAppInfo.getInstance().setExamRunning(false);
        this.finish();
    }

    @Override
    public void onTryAgain() {
        LinkedHashMap<String, SubmitTestInfo> data = FilterQuestions.getInstance().getSummeryInfo(this.questionAnswerInfo).get(0).getSubmitMap();
        data.put("0", new SubmitTestInfo("0", "", this.filterSessionTime));
        this.showProgressDialog(this.getString(R.string.str_submit_test));
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("data", new Gson().toJson(data));
        params.put("qpi", this.qpi);
        if (this.ppi != null) {
            params.put("ppi", this.ppi);
        }
        this.presenter.callSubmitTest(this.submitUrl, params, (Context)this);
    }

    @Override
    public void onPauseTest(boolean value) {
        if (value) {
            this.showProgressDialog(this.getString(R.string.str_pause_message));
            this.isForcePaused = true;
            if (this.testStartPermissionEnabled && this.canStopTimer) {
                this.canStopTimer = false;
                OliveBoardTestTimer.getInstance().pause();
            }
            MainEventBus.getInstance().post((Object)new SubmitDialogCalled());
            LinkedHashMap<String, PauseTestInfo> data = FilterQuestions.getInstance().getPauseTestInfo(this.questionAnswerInfo);
            data.put("0", new PauseTestInfo("0", "", this.filterSessionTime, ""));
            try {
                OliveBoardTestTimer.getInstance().finishOnPause();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.questionPosition >= 0 && this.questionPosition < this.questionAnswerInfo.size()) {
                this.presenter.callPauseTest(this.pauseUrl, new PauseTestData(data, BasicConfig.getInstance().timeLeft(this.timerTextView.getText().toString()), this.questionAnswerInfo.get(this.questionPosition).getQuestionId()), this.qpi, "0", this.ppi, (Context)this);
            } else if (this.questionAnswerInfo != null && this.questionAnswerInfo.size() > 0) {
                this.presenter.callPauseTest(this.pauseUrl, new PauseTestData(data, BasicConfig.getInstance().timeLeft(this.timerTextView.getText().toString()), this.questionAnswerInfo.get(0).getQuestionId()), this.qpi, "0", this.ppi, (Context)this);
            } else {
                this.hideProgressDialog();
            }
        } else {
            this.isForcePaused = false;
            this.canStopTimer = true;
            if (this.testStartPermissionEnabled && this.canStopTimer) {
                OliveBoardTestTimer.getInstance().resume();
            }
        }
    }

    @Override
    public void startTest(boolean value) {
        if (value) {
            if (!this.testStartPermissionEnabled) {
                try {
                    this.testStartPermissionEnabled = true;
                    OliveBoardTestTimer.getInstance().startTimer(false);
                    LargeAppInfo.getInstance().setCanEndSession(true);
                    this.sessionTimeList.clear();
                    if (LargeAppInfo.getInstance().getQuestionInfo() != null && LargeAppInfo.getInstance().getQuestionInfo().settings != null) {
                        this.sessionTimeList.add(FilterQuestions.getInstance().getDurationString(LargeAppInfo.getInstance().getQuestionInfo().settings.totalTime));
                    }
                    this.isTestStarted = true;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        } else {
            try {
                OliveBoardTestTimer.getInstance().finish();
            }
            catch (Exception exception) {
                // empty catch block
            }
            LargeAppInfo.getInstance().clearAllData();
            LargeAppInfo.getInstance().setExamRunning(false);
            this.finish();
        }
    }

    @Override
    public void retyPermission() {
    }

    @Override
    public void gotoPurchase() {
    }

    @Override
    public void noPhoneAction() {
    }

    @Override
    public void openPermissionSetting() {
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        switch (item.getItemId()) {
            case 16908332: {
                DialogUtils.getInstance().exitDialog(this, this);
                return true;
            }
        }
        return super.onOptionsItemSelected(item);
    }

    public void onSuccess(Object responseModel) {
        this.hideProgressDialog();
        if (responseModel == "test_submit_response") {
            if (this.solutionUrl.equals("0")) {
                try {
                    DialogUtils.getInstance().closeSelfDialog();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (this.getIntent().getExtras() != null && this.getIntent().getExtras().getBoolean(Constants.IS_MOCK)) {
                    MainEventBus.getInstance().post((Object)new TestStatusEventModel(false));
                } else {
                    MainEventBus.getInstance().post((Object)new TestStatusEventModel(true));
                }
                this.startActivity(new Intent(this.getApplicationContext(), TestSectionActivity.class).putExtra(Constants.BASE_BUNDLE_EXAM_NAME, this.getIntent().getExtras().getString(Constants.BASE_BUNDLE_EXAM_NAME)).putExtra(Constants.BASE_BUNDLE_URL, this.getIntent().getExtras().getString(Constants.BASE_BUNDLE_URL)).putExtra(Constants.BUNDLE_KEY_EXAM_URL, this.getIntent().getExtras().getBoolean(Constants.IS_MOCK)));
                LargeAppInfo.getInstance().setExamRunning(false);
                this.finish();
            } else {
                try {
                    DialogUtils.getInstance().closeSelfDialog();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (this.getIntent().getExtras().containsKey("com.bundle.should.test")) {
                    if (this.getIntent().getExtras().getString(Constants.BASE_BUNDLE_EXAM_NAME).length() > 0) {
                        this.startActivity(new Intent((Context)this, SummeryActivity.class).putExtra(Constants.BUNDLE_SUMMERY_URL, this.solutionUrl).putExtra("exam_name", this.getIntent().getExtras().getString(Constants.BASE_BUNDLE_EXAM_NAME)).putExtra("from_test", "from_test"));
                    } else {
                        this.startActivity(new Intent((Context)this, SummeryActivity.class).putExtra(Constants.BUNDLE_SUMMERY_URL, this.solutionUrl).putExtra("exam_name", this.examNameToolbarTextView.getText().toString()).putExtra("from_test", "from_test"));
                    }
                } else {
                    this.startActivity(new Intent((Context)this, SummeryActivity.class).putExtra(Constants.BUNDLE_SUMMERY_URL, this.solutionUrl).putExtra("exam_name", this.examNameToolbarTextView.getText().toString()).putExtra("from_test", "from_test"));
                }
                if (this.getIntent().getExtras().getBoolean(Constants.IS_MOCK)) {
                    MainEventBus.getInstance().post((Object)new TestStatusEventModel(false));
                } else {
                    MainEventBus.getInstance().post((Object)new TestStatusEventModel(true));
                }
                try {
                    LargeAppInfo.getInstance().clearAllData();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                LargeAppInfo.getInstance().setExamRunning(false);
                this.finish();
            }
        } else if (responseModel == "test_pause_response") {
            try {
                LargeAppInfo.getInstance().clearAllData();
            }
            catch (Exception exception) {
                // empty catch block
            }
            LargeAppInfo.getInstance().setExamRunning(false);
            this.finish();
        }
    }

    @Override
    public void onFailed() {
        this.hideProgressDialog();
        if (!this.isForcePaused) {
            DialogUtils.getInstance().tryAgainSubmit(this, this);
        } else {
            Toast.makeText((Context)this.getApplicationContext(), (CharSequence)"Pausing test failed. Please try again...", (int)0).show();
            try {
                LargeAppInfo.getInstance().clearAllData();
            }
            catch (Exception exception) {
                // empty catch block
            }
            LargeAppInfo.getInstance().setExamRunning(false);
            this.finish();
        }
    }

    public void onSuccess(List responseModel) {
    }

    @Override
    public void onAuthFailed() {
        BasicConfig.getInstance().onAuthFailed(this);
    }

    @Override
    public void onSuccess(String response) {
        this.hideProgressDialog();
        if (response == "test_submit_response") {
            if (this.solutionUrl.equals("0")) {
                try {
                    DialogUtils.getInstance().closeSelfDialog();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (this.getIntent().getExtras() != null && this.getIntent().getExtras().getBoolean(Constants.IS_MOCK)) {
                    MainEventBus.getInstance().post((Object)new TestStatusEventModel(false));
                } else {
                    MainEventBus.getInstance().post((Object)new TestStatusEventModel(true));
                }
                this.startActivity(new Intent(this.getApplicationContext(), TestSectionActivity.class).putExtra(Constants.BASE_BUNDLE_EXAM_NAME, this.getIntent().getExtras().getString(Constants.BASE_BUNDLE_EXAM_NAME)).putExtra(Constants.BASE_BUNDLE_URL, this.getIntent().getExtras().getString(Constants.BASE_BUNDLE_URL)).putExtra(Constants.BUNDLE_KEY_EXAM_URL, this.getIntent().getExtras().getBoolean(Constants.IS_MOCK)));
                LargeAppInfo.getInstance().setExamRunning(false);
                this.finish();
            } else {
                try {
                    DialogUtils.getInstance().closeSelfDialog();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (this.getIntent().getExtras().containsKey("com.bundle.should.test")) {
                    if (this.getIntent().getExtras().getString(Constants.BASE_BUNDLE_EXAM_NAME).length() > 0) {
                        this.startActivity(new Intent((Context)this, SummeryActivity.class).putExtra(Constants.BUNDLE_SUMMERY_URL, this.solutionUrl).putExtra("exam_name", this.getIntent().getExtras().getString(Constants.BASE_BUNDLE_EXAM_NAME)).putExtra("from_test", "from_test"));
                    } else {
                        this.startActivity(new Intent((Context)this, SummeryActivity.class).putExtra(Constants.BUNDLE_SUMMERY_URL, this.solutionUrl).putExtra("exam_name", this.examNameToolbarTextView.getText().toString()).putExtra("from_test", "from_test"));
                    }
                } else {
                    this.startActivity(new Intent((Context)this, SummeryActivity.class).putExtra(Constants.BUNDLE_SUMMERY_URL, this.solutionUrl).putExtra("exam_name", this.examNameToolbarTextView.getText().toString()).putExtra("from_test", "from_test"));
                }
                if (this.getIntent().getExtras().getBoolean(Constants.IS_MOCK)) {
                    MainEventBus.getInstance().post((Object)new TestStatusEventModel(false));
                } else {
                    MainEventBus.getInstance().post((Object)new TestStatusEventModel(true));
                }
                try {
                    LargeAppInfo.getInstance().clearAllData();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                LargeAppInfo.getInstance().setExamRunning(false);
                this.finish();
            }
        } else if (response == "test_pause_response") {
            try {
                LargeAppInfo.getInstance().clearAllData();
            }
            catch (Exception exception) {
                // empty catch block
            }
            LargeAppInfo.getInstance().setExamRunning(false);
            this.finish();
        }
    }

    public void onSolutionDataCallback(TestResponseModel response, ArrayList restructuredModelList, boolean status, TreeMap questionSet, int correct, int wrong, String accurecy) {
    }

    public void onTestDataCallback(TestResponseModel response, ArrayList restructuredModelList, boolean status, TreeMap questionSet) {
    }

    @Override
    public void onFailed(String message) {
    }

    @Subscribe
    public void onForceKill(ClearTest test) {
        try {
            OliveBoardTestTimer.getInstance().finish();
        }
        catch (Exception exception) {
            // empty catch block
        }
        LargeAppInfo.getInstance().clearAllData();
        LargeAppInfo.getInstance().setExamRunning(false);
        this.finish();
    }

    public void onClick(View view) {
        int i = view.getId();
        if (i == R.id.section) {
            if (this.questionSet.size() > 1) {
                DialogUtils.getInstance().displayPopupWindow(this.quickActionLineView, this, this.questionSet, this, this.typeTextView.getText().toString());
            }
        } else if (i == R.id.type_bottam) {
            if (this.questionSet.size() > 1) {
                DialogUtils.getInstance().displayPopupWindow(this.quickActionLineView, this, this.questionSet, this, this.typeTextView.getText().toString());
            }
        } else if (i == R.id.type_relative) {
            if (this.questionSet.size() > 1) {
                DialogUtils.getInstance().displayPopupWindow(this.quickActionLineView, this, this.questionSet, this, this.typeTextView.getText().toString());
            }
        } else if (i == R.id.type_text_view) {
            if (this.questionSet.size() > 1) {
                DialogUtils.getInstance().displayPopupWindow(this.quickActionLineView, this, this.questionSet, this, this.typeTextView.getText().toString());
            }
        } else if (i == R.id.filter_fab) {
            this.canStopTimer = false;
            LargeAppInfo.getInstance().setBaseFilterArray(this.questionAnswerInfo);
            this.startActivityForResult(new Intent(this.getApplicationContext(), TestAppFilterActivity.class), 1002);
        } else if (i == R.id.submit_btn) {
            if (this.solutionUrl != null && this.solutionUrl.equals("0")) {
                DialogUtils.getInstance().submitTestDialog(this, this.questionAnswerInfo, this, true);
            } else {
                DialogUtils.getInstance().submitTestDialog(this, this.questionAnswerInfo, this, false);
            }
        } else if (i == R.id.timer_submit_layout) {
            if (this.solutionUrl != null && this.solutionUrl.equals("0")) {
                DialogUtils.getInstance().submitTestDialog(this, this.questionAnswerInfo, this, true);
            } else {
                DialogUtils.getInstance().submitTestDialog(this, this.questionAnswerInfo, this, false);
            }
        } else if (i == R.id.next_btn) {
            if (this.solutionUrl != null && this.solutionUrl.equals("0")) {
                DialogUtils.getInstance().submitTestDialog(this, this.questionAnswerInfo, this, true);
            } else {
                DialogUtils.getInstance().submitTestDialog(this, this.questionAnswerInfo, this, false);
            }
        }
    }
}

