/*
 * Decompiled with CFR 0.152.
 */
package in.oliveboard.sdk.ui;

import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.RequiresApi;
import android.support.design.widget.TabLayout;
import android.support.v4.content.ContextCompat;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.support.v7.widget.Toolbar;
import android.text.Html;
import android.view.View;
import android.view.Window;
import android.widget.Button;
import android.widget.TextView;
import in.oliveboard.sdk.R;
import in.oliveboard.sdk.presenter.TestPresenter;
import in.oliveboard.sdk.presenter.interfaces.CommonContract;
import in.oliveboard.sdk.presenter.model.SummeryBaseResponse;
import in.oliveboard.sdk.presenter.model.TestResponseModel;
import in.oliveboard.sdk.ui.TestSolutionActivity;
import in.oliveboard.sdk.ui.WebActivity;
import in.oliveboard.sdk.ui.adapters.SummaryFragmentAdapter;
import in.oliveboard.sdk.ui.base.BaseActivity;
import in.oliveboard.sdk.utils.Constants;
import in.oliveboard.sdk.utils.LargeDataHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.TreeMap;

public class SummeryActivity
extends BaseActivity
implements CommonContract.View {
    Toolbar toolbar;
    TextView toolbarTitle;
    ViewPager viewPager;
    TabLayout tabs;
    Button analysisBtn;
    int solutionAppDecideFlag = 0;
    String solutionUrl;
    TestPresenter presenter = new TestPresenter();

    @Override
    @RequiresApi(api=19)
    protected void initializeDagger() {
        if (Build.VERSION.SDK_INT >= 21) {
            Window window = this.getWindow();
            window.addFlags(Integer.MIN_VALUE);
            window.setStatusBarColor(ContextCompat.getColor((Context)this.getApplicationContext(), (int)R.color.primary_color_dark));
        }
        this.toolbar = (Toolbar)this.findViewById(R.id.toolbar);
        this.toolbarTitle = (TextView)this.findViewById(R.id.toolbar_txt);
        this.viewPager = (ViewPager)this.findViewById(R.id.pager_view);
        this.tabs = (TabLayout)this.findViewById(R.id.summary_tabs);
        this.analysisBtn = (Button)this.findViewById(R.id.btn_analysis);
        this.toolbar.setNavigationIcon(R.drawable.icon_toolbar);
        this.setSupportActionBar(this.toolbar);
        Objects.requireNonNull(this.getSupportActionBar()).setDisplayHomeAsUpEnabled(true);
        if (Build.VERSION.SDK_INT >= 24) {
            this.toolbarTitle.setText((CharSequence)Html.fromHtml((String)Objects.requireNonNull(this.getIntent().getExtras()).getString("exam_name"), (int)0));
        } else {
            this.toolbarTitle.setText((CharSequence)Html.fromHtml((String)Objects.requireNonNull(this.getIntent().getExtras()).getString("exam_name")));
        }
        this.analysisBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (1 == SummeryActivity.this.solutionAppDecideFlag) {
                    Intent intent = new Intent(SummeryActivity.this.getApplicationContext(), TestSolutionActivity.class);
                    intent.putExtra(Constants.BASE_BUNDLE_URL, SummeryActivity.this.solutionUrl);
                    intent.putExtra("action_header", SummeryActivity.this.getIntent().getExtras().getString("exam_name"));
                    if (SummeryActivity.this.getIntent().getExtras().containsKey("from_test")) {
                        intent.putExtra("from_test", "from_test");
                    }
                    SummeryActivity.this.startActivity(intent);
                    SummeryActivity.this.finish();
                } else {
                    SummeryActivity.this.startActivity(new Intent(SummeryActivity.this.getApplicationContext(), WebActivity.class).putExtra(Constants.BUNDLE_WEB_URL, SummeryActivity.this.solutionUrl).putExtra("action_header", SummeryActivity.this.getIntent().getExtras().getString("exam_name")).putExtra("hasExitDialog", false));
                }
            }
        });
    }

    @Override
    protected void savedInstance(Bundle savedInstanceState) {
    }

    @Override
    @RequiresApi(api=19)
    protected void initializePresenter() {
        ((BaseActivity)this).presenter = this.presenter;
        this.presenter.setView(this);
        this.showProgressDialog(this.getString(R.string.str_loading_analysis));
        this.presenter.callSummery(Objects.requireNonNull(this.getIntent().getExtras()).getString(Constants.BUNDLE_SUMMERY_URL), (Context)this);
    }

    @Override
    public int getLayoutId() {
        return R.layout.activity_mocksummary;
    }

    public void onSuccess(Object responseModel) {
        this.hideProgressDialog();
        if (responseModel instanceof SummeryBaseResponse) {
            SummeryBaseResponse response = (SummeryBaseResponse)responseModel;
            this.solutionAppDecideFlag = response.solutionAppDecideFlag;
            this.solutionUrl = response.solutionUrl;
            LargeDataHandler.getInstance().setSummaryData(response);
            if (response.detailAnalysisWebView != null && response.detailAnalysisWebView.length() > 3) {
                this.viewPager.setAdapter((PagerAdapter)new SummaryFragmentAdapter(this.getSupportFragmentManager(), true));
                this.tabs.setupWithViewPager(this.viewPager);
            } else {
                this.viewPager.setAdapter((PagerAdapter)new SummaryFragmentAdapter(this.getSupportFragmentManager(), false));
                this.tabs.setVisibility(8);
            }
        }
    }

    @Override
    public void onFailed() {
        this.hideProgressDialog();
        this.finish();
    }

    public void onSuccess(List responseModel) {
    }

    @Override
    public void onAuthFailed() {
    }

    @Override
    public void onSuccess(String response) {
    }

    public void onSolutionDataCallback(TestResponseModel response, ArrayList restructuredModelList, boolean status, TreeMap questionSet, int correct, int wrong, String accurecy) {
    }

    public void onTestDataCallback(TestResponseModel response, ArrayList restructuredModelList, boolean status, TreeMap questionSet) {
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        if (this.presenter != null) {
            this.presenter.unSubscribe();
        }
    }

    @Override
    public void onFailed(String message) {
    }
}

