/*
 * Decompiled with CFR 0.152.
 */
package in.oliveboard.sdk.ui;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.design.widget.Snackbar;
import android.support.design.widget.TextInputLayout;
import android.support.v7.widget.Toolbar;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.util.Patterns;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;
import android.widget.Toast;
import in.oliveboard.sdk.R;
import in.oliveboard.sdk.presenter.AuthPresenter;
import in.oliveboard.sdk.presenter.interfaces.AuthContract;
import in.oliveboard.sdk.presenter.model.LoginResponseModel;
import in.oliveboard.sdk.ui.HomeActivity;
import in.oliveboard.sdk.ui.LoginOliveBoardActivity;
import in.oliveboard.sdk.ui.base.BaseActivity;
import in.oliveboard.sdk.utils.AppPreferences;
import in.oliveboard.sdk.utils.Constants;
import in.oliveboard.sdk.utils.LargeAppInfo;
import in.oliveboard.sdk.utils.LargeDataHandler;
import in.oliveboard.sdk.utils.Utils;
import java.util.HashMap;

public class SignupOliveBoardActivity
extends BaseActivity
implements AuthContract.View {
    Toolbar toolbar;
    EditText mSignup_email;
    EditText mSignup_pwd;
    EditText mSignup_phNo;
    TextInputLayout mInputEmail;
    TextInputLayout mInputPwd;
    TextInputLayout mInputPhNo;
    Button mSignUp;
    Button mSwitch_signIn;
    String input_email;
    String input_password;
    String input_mobNumber;
    public String token;
    private static final int RC_SIGN_IN = 9001;
    AuthPresenter presenter = new AuthPresenter();

    @Override
    protected void initializeDagger() {
        this.toolbar = (Toolbar)this.findViewById(R.id.toolbar);
        this.mSignup_email = (EditText)this.findViewById(R.id.input_email);
        this.mSignup_pwd = (EditText)this.findViewById(R.id.input_password);
        this.mSignup_phNo = (EditText)this.findViewById(R.id.input_phone);
        this.mInputEmail = (TextInputLayout)this.findViewById(R.id.input_layout_email);
        this.mInputPwd = (TextInputLayout)this.findViewById(R.id.input_layout_password);
        this.mInputPhNo = (TextInputLayout)this.findViewById(R.id.input_layout_phone);
        this.mSignUp = (Button)this.findViewById(R.id.btn_signup);
        this.mSwitch_signIn = (Button)this.findViewById(R.id.txt_signUp);
        this.setSupportActionBar(this.toolbar);
        this.setBackEnabled(false);
        this.toolbar.setNavigationOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                Intent BackpressedIntent = new Intent();
                BackpressedIntent.setClass(SignupOliveBoardActivity.this.getApplicationContext(), SignupOliveBoardActivity.class);
                SignupOliveBoardActivity.this.startActivity(BackpressedIntent);
                SignupOliveBoardActivity.this.finish();
            }
        });
        this.mSignup_email.addTextChangedListener((TextWatcher)new MyTextWatcher((View)this.mSignup_email));
        this.mSignup_pwd.addTextChangedListener((TextWatcher)new MyTextWatcher((View)this.mSignup_pwd));
        this.mSignup_phNo.addTextChangedListener((TextWatcher)new MyTextWatcher((View)this.mSignup_phNo));
        LargeAppInfo.getInstance().changeLang("en", this.getApplicationContext());
        this.mSignUp.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (!SignupOliveBoardActivity.this.validateForm()) {
                    return;
                }
                Utils.hideSoftKeyboard((Context)SignupOliveBoardActivity.this, SignupOliveBoardActivity.this.mSignup_email);
                Utils.hideSoftKeyboard((Context)SignupOliveBoardActivity.this, SignupOliveBoardActivity.this.mSignup_pwd);
                Utils.hideSoftKeyboard((Context)SignupOliveBoardActivity.this, SignupOliveBoardActivity.this.mSignup_phNo);
                if (Utils.isConnectionAvailable((Context)SignupOliveBoardActivity.this)) {
                    SignupOliveBoardActivity.this.showProgressDialog(SignupOliveBoardActivity.this.getString(R.string.str_please_wait));
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("e", SignupOliveBoardActivity.this.input_email);
                    map.put("p", SignupOliveBoardActivity.this.input_password);
                    map.put("m", SignupOliveBoardActivity.this.input_mobNumber);
                    map.put("ref", SignupOliveBoardActivity.this.getApplicationContext().getPackageName());
                    new AppPreferences(SignupOliveBoardActivity.this.getApplicationContext(), "LoginPref").SaveData("email_type", "Normal");
                    if (SignupOliveBoardActivity.this.presenter != null) {
                        SignupOliveBoardActivity.this.presenter.onUserRegister(map);
                    }
                } else {
                    Snackbar.make((View)view, (CharSequence)"No internet connection", (int)0).show();
                }
            }
        });
        this.mSwitch_signIn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                SignupOliveBoardActivity.this.startActivity(new Intent(SignupOliveBoardActivity.this.getApplicationContext(), LoginOliveBoardActivity.class));
                SignupOliveBoardActivity.this.finish();
            }
        });
    }

    @Override
    protected void savedInstance(Bundle savedInstanceState) {
    }

    @Override
    protected void initializePresenter() {
        ((BaseActivity)this).presenter = this.presenter;
        this.presenter.setView(this);
    }

    @Override
    public int getLayoutId() {
        return R.layout.activity_signup;
    }

    @Override
    protected void onStart() {
        super.onStart();
    }

    @Override
    protected void onResume() {
        super.onResume();
    }

    @Override
    public void loginSuccess(String token) {
        if (!this.isFinishing()) {
            this.hideProgressDialog();
            LargeDataHandler.getInstance().setMockTestUrl(token);
            new AppPreferences(this.getApplicationContext(), "LoginPref").saveBoolean("IsLoggedIn", true);
            new AppPreferences(this.getApplicationContext(), "LoginPref").SaveData("token", token);
            new AppPreferences(this.getApplicationContext(), "LoginPref").SaveData("email", this.input_email);
            Intent intent = new Intent((Context)this, HomeActivity.class);
            intent.putExtra(Constants.BUNDLE_KEY_MOCK_TEST_URL, "https://mocks.oliveboard.in/banking/android/mockstart.cgi?c=BANKING");
            intent.putExtra(Constants.BUNDLE_KEY_MOCK_TEST_TYPE, "Mock Test");
            intent.putExtra("com.title.bundle.language", "Oliveboard Mock Tests");
            this.startActivity(intent);
            this.finish();
        }
    }

    @Override
    public void onFailed() {
        this.hideProgressDialog();
        Toast.makeText((Context)this.getApplicationContext(), (CharSequence)"Email already registered", (int)0).show();
    }

    @Override
    public void onFailed(String message) {
        this.hideProgressDialog();
        Toast.makeText((Context)this.getApplicationContext(), (CharSequence)"Please try again", (int)0).show();
    }

    @Override
    public void onAuthFailed() {
    }

    public void onLoginSuccess(Object responseModel) {
        this.hideProgressDialog();
        if (responseModel instanceof LoginResponseModel) {
            LargeDataHandler.getInstance().setMockTestUrl(((LoginResponseModel)responseModel).starturl);
            new AppPreferences(this.getApplicationContext(), "LoginPref").saveBoolean("IsLoggedIn", true);
            new AppPreferences(this.getApplicationContext(), "LoginPref").SaveData("token", ((LoginResponseModel)responseModel).uauth);
            new AppPreferences(this.getApplicationContext(), "LoginPref").SaveData("email", this.input_email);
            new AppPreferences(this.getApplicationContext(), "LoginPref").SaveData("password", this.input_password);
            Intent intent = new Intent((Context)this, HomeActivity.class);
            intent.putExtra(Constants.BUNDLE_KEY_MOCK_TEST_URL, ((LoginResponseModel)responseModel).starturl);
            intent.putExtra(Constants.BUNDLE_KEY_MOCK_TEST_TYPE, "Mock Test");
            intent.putExtra("com.title.bundle.language", "Oliveboard Mock Tests");
            this.startActivity(intent);
            this.finish();
        }
    }

    public boolean validateForm() {
        return this.validateEmail() && this.validatePassword() && this.validatePhoneNumber();
    }

    private boolean validateEmail() {
        this.input_email = this.mSignup_email.getText().toString().trim();
        if (this.input_email.isEmpty() || !SignupOliveBoardActivity.isValidEmail(this.input_email)) {
            this.mInputEmail.setError((CharSequence)this.getString(R.string.err_msg_email));
            this.requestFocus((View)this.mSignup_email);
            return false;
        }
        this.mInputEmail.setErrorEnabled(false);
        return true;
    }

    private boolean validatePassword() {
        this.input_password = this.mSignup_pwd.getText().toString().trim();
        if (this.input_password.isEmpty()) {
            this.mInputPwd.setError((CharSequence)this.getString(R.string.err_msg_password));
            this.requestFocus((View)this.mSignup_pwd);
            return false;
        }
        this.mInputPwd.setErrorEnabled(false);
        return true;
    }

    private boolean validatePhoneNumber() {
        this.input_mobNumber = this.mSignup_phNo.getText().toString().trim();
        if (this.input_mobNumber.isEmpty() || this.input_mobNumber.length() != 10) {
            this.mInputPhNo.setError((CharSequence)this.getString(R.string.err_msg_phone));
            this.requestFocus((View)this.mSignup_phNo);
            return false;
        }
        this.mInputPhNo.setErrorEnabled(false);
        return true;
    }

    private static boolean isValidEmail(String email) {
        return !TextUtils.isEmpty((CharSequence)email) && Patterns.EMAIL_ADDRESS.matcher(email).matches();
    }

    private void requestFocus(View view) {
        if (view.requestFocus()) {
            this.getWindow().setSoftInputMode(5);
        }
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        if (this.presenter != null) {
            // empty if block
        }
    }

    public void onBackPressed() {
        if (this.getIntent() != null && this.getIntent().getExtras() != null && this.getIntent().getExtras().containsKey("form")) {
            this.finish();
        } else {
            Intent BackpressedIntent = new Intent();
            BackpressedIntent.setClass(this.getApplicationContext(), SignupOliveBoardActivity.class);
            this.startActivity(BackpressedIntent);
            this.finish();
        }
    }

    private class MyTextWatcher
    implements TextWatcher {
        private View view;

        private MyTextWatcher(View view) {
            this.view = view;
        }

        public void beforeTextChanged(CharSequence s, int start, int count, int after) {
        }

        public void onTextChanged(CharSequence s, int start, int before, int count) {
        }

        public void afterTextChanged(Editable s) {
        }
    }
}

