package in.oliveboard.sdk.ui.fragments;

import android.content.Context;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresApi;
import android.support.v4.app.Fragment;
import android.support.v4.view.ViewPager;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;

import java.util.ArrayList;
import java.util.Objects;

import in.oliveboard.sdk.R;
import in.oliveboard.sdk.ui.adapters.SolutionPageAdaptor;
import in.oliveboard.sdk.utils.Constants;
import in.oliveboard.sdk.utils.LargeAppInfo;
import in.oliveboard.sdk.utils.TestDataChangeListener;
import in.oliveboard.sdk.views.LoopViewPager;


public class TestSolutionViewPagerFragment extends Fragment {

    LoopViewPager mLoopViewPager;
    TestDataChangeListener onTestDataChangeListener;


    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        View v = inflater.inflate(R.layout.fragment_infinate_pager, container, false);
        mLoopViewPager = v.findViewById(R.id.pager);
        return v;
    }

    @RequiresApi(api = Build.VERSION_CODES.KITKAT)
    @Override
    public void onActivityCreated(@Nullable Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);


        assert getArguments() != null;
        if(getArguments().getBoolean("gk_type"))
        {
            mLoopViewPager.setAdapter(new SolutionPageAdaptor(getChildFragmentManager(),getActivity(),true));
        }
        else {
            mLoopViewPager.setAdapter(new SolutionPageAdaptor(getChildFragmentManager(),getActivity(),false));

            if (getArguments().getInt(Constants.INDEX) > 0) {

                mLoopViewPager.setCurrentItem(getArguments().getInt(Constants.INDEX), false);

            }
            if (LargeAppInfo.getInstance().getCurrentQuestionInfo().size() > 0) {
                onTestDataChangeListener.onLangaugeSwitchChange(((ArrayList<String>) LargeAppInfo.getInstance().getCurrentQuestionInfo().get(getArguments().getInt(Constants.INDEX)).getTestInfo().get(1)).size() > 1);
                onTestDataChangeListener.onChangeQuestion(LargeAppInfo.getInstance().getCurrentQuestionInfo().get(getArguments().getInt(Constants.INDEX)).getKey());
            }
        }


        mLoopViewPager.addOnPageChangeListener(new ViewPager.OnPageChangeListener() {
            @Override
            public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {

            }

            @Override
            public void onPageSelected(int position) {
                if(!getArguments().getBoolean("gk_type")) {
                    onTestDataChangeListener.onLangaugeSwitchChange(((ArrayList<String>) LargeAppInfo.getInstance().getCurrentQuestionInfo().get(position).getTestInfo().get(1)).size() > 1);
                    onTestDataChangeListener.onChangeQuestion(LargeAppInfo.getInstance().getCurrentQuestionInfo().get(position).getKey());
                }
            }

            @Override
            public void onPageScrollStateChanged(int state) {

            }
        });

    }

    public static TestSolutionViewPagerFragment setInstance(int position,boolean isGk) {
        TestSolutionViewPagerFragment instance = new TestSolutionViewPagerFragment();
        Bundle bundleValue = new Bundle();
        bundleValue.putInt(Constants.INDEX, position);
        bundleValue.putBoolean("gk_type",isGk);
        instance.setArguments(bundleValue);

        return instance;
    }

    @Override
    public void onAttach(Context context) {
        super.onAttach(context);
        onTestDataChangeListener = (TestDataChangeListener) context;

    }

    public void changePosition(int position) {
        if(mLoopViewPager!=null) {
            mLoopViewPager.setCurrentItem(position, false);
        }
    }
}
