package in.oliveboard.sdk.ui.fragments;

import android.content.Context;
import android.graphics.Bitmap;
import android.os.Bundle;
import android.os.Parcel;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.support.v4.widget.NestedScrollView;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.WebChromeClient;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.squareup.otto.Subscribe;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;

import in.oliveboard.sdk.R;
import in.oliveboard.sdk.presenter.model.ChangeLanguage;
import in.oliveboard.sdk.ui.adapters.SolutionOptionAdaptor;
import in.oliveboard.sdk.utils.Constants;
import in.oliveboard.sdk.utils.DialogUtils;
import in.oliveboard.sdk.utils.LargeAppInfo;
import in.oliveboard.sdk.utils.MainEventBus;
import in.oliveboard.sdk.utils.RecyclerItemClickListener;
import in.oliveboard.sdk.utils.TestDataChangeListener;
import in.oliveboard.sdk.views.OliveBoardWebView;


public class TestSolutionFragment extends Fragment {

    OliveBoardWebView questionWebView;
    OliveBoardWebView solutionWebView;
    LinearLayout expandCollapeLayout;
    RecyclerView answerRecyclerView;
    TextView questionTextView;
    TextView readMoreLessTextView;
    ImageView readMoreLessImageView;
    View lineDividerView;
    NestedScrollView questionScrollView;
    ImageView infoSolution;
    LinearLayout solutionLinearLayout;
    LinearLayout viewSolutionLinearLayout;
    TextView timeTakenTextView;
    TextView statusTextView;
    TextView statusGkTextView;
    TextView questionTotalTextView;
    TextView textTimeTitle;
    RelativeLayout timeLayout;
    LinearLayout statusLinearLayoutGk;

    ArrayList<ArrayList<String>> answerList = new ArrayList<>();
    boolean isExpanded;
    String shortQuestions, value, solutionValue;
    int questionsPosition = -1;
    SolutionOptionAdaptor answerAdaptor;
    String userAnswer;
    String answerPainData = "";
    TestDataChangeListener onTestDataChangeListener;
    boolean loadedExpantion = false;
    int newPosition = 0;
    LinearLayout statusLayout;

    @Nullable
    @Override
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.fragment_solution_question, container, false);

        questionWebView = (OliveBoardWebView)view.findViewById(R.id.webView);
        solutionWebView = (OliveBoardWebView)view.findViewById(R.id.webView_Solution);
        expandCollapeLayout = (LinearLayout)view.findViewById(R.id.expand_collapse_layout);
        answerRecyclerView = (RecyclerView)view.findViewById(R.id.recycler_view);

        questionTextView = (TextView)view.findViewById(R.id.question_textview);
        readMoreLessTextView = (TextView)view.findViewById(R.id.readmore_less_textview);
        readMoreLessImageView = (ImageView)view.findViewById(R.id.readmore_less_imageview);
        lineDividerView = (View)view.findViewById(R.id.line_divider);

        questionScrollView = (NestedScrollView)view.findViewById(R.id.question_nested_scroll_view);
        infoSolution = (ImageView)view.findViewById(R.id.info_image_view);
        solutionLinearLayout = (LinearLayout)view.findViewById(R.id.solution_layer);
        viewSolutionLinearLayout = (LinearLayout) view.findViewById(R.id.view_solution_layer);
        timeTakenTextView = (TextView)view.findViewById(R.id.time_text_view);
        statusTextView = (TextView)view.findViewById(R.id.status_text_view);
        statusGkTextView = (TextView)view.findViewById(R.id.status_gk);
        questionTotalTextView = (TextView)view.findViewById(R.id.question_total_textview);
        textTimeTitle = (TextView)view.findViewById(R.id.txt_time);
        timeLayout = (RelativeLayout) view.findViewById(R.id.time_layout);
        statusLinearLayoutGk = (LinearLayout) view.findViewById(R.id.status_layout_gk);
        statusLayout = (LinearLayout)view.findViewById(R.id.status_layout);


        return view;
    }

    @Override
    public void onActivityCreated(@Nullable Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);

        newPosition = getArguments().getInt("positionAdaptor");

            try {
                /*if have short question means its a panes*/

                if (((ArrayList<String>) LargeAppInfo.getInstance().getCurrentQuestionInfo().get(newPosition).getTestInfo().get(4)).size() > 0 && LargeAppInfo.getInstance().getPanesList() != null && LargeAppInfo.getInstance().getPanesList().get(((ArrayList<String>) LargeAppInfo.getInstance().getCurrentQuestionInfo().get(newPosition).getTestInfo().get(4)).get(0)) != null) {

                    shortQuestions = (((ArrayList<String>) LargeAppInfo.getInstance().getCurrentQuestionInfo().get(newPosition).getTestInfo().get(1)).size() > 1) ? ((ArrayList<String>) LargeAppInfo.getInstance().getCurrentQuestionInfo().get(newPosition).getTestInfo().get(1)).get(LargeAppInfo.getInstance().getLanguageType()) : ((ArrayList<String>) LargeAppInfo.getInstance().getCurrentQuestionInfo().get(newPosition).getTestInfo().get(1)).get(0);

                    value = (LargeAppInfo.getInstance().getPanesList().get(((ArrayList<String>) LargeAppInfo.getInstance().getCurrentQuestionInfo().get(newPosition).getTestInfo().get(4)).get(0)).size() > 1) && LargeAppInfo.getInstance().getPanesList().get(((ArrayList<String>) LargeAppInfo.getInstance().getCurrentQuestionInfo().get(newPosition).getTestInfo().get(4)).get(0)).get(LargeAppInfo.getInstance().getLanguageType()).length() > 0 ? LargeAppInfo.getInstance().getPanesList().get(((ArrayList<String>) LargeAppInfo.getInstance().getCurrentQuestionInfo().get(newPosition).getTestInfo().get(4)).get(0)).get(LargeAppInfo.getInstance().getLanguageType()) : LargeAppInfo.getInstance().getPanesList().get(((ArrayList<String>) LargeAppInfo.getInstance().getCurrentQuestionInfo().get(newPosition).getTestInfo().get(4)).get(0)).get(0);
                    answerPainData = (LargeAppInfo.getInstance().getPanesList().get(((ArrayList<String>) LargeAppInfo.getInstance().getCurrentQuestionInfo().get(newPosition).getTestInfo().get(4)).get(0)).size() > 2) ? LargeAppInfo.getInstance().getPanesList().get(((ArrayList<String>) LargeAppInfo.getInstance().getCurrentQuestionInfo().get(newPosition).getTestInfo().get(4)).get(0)).get(2) : "";
                    value = value + "\n" + shortQuestions;

                } else {

                    value = (((ArrayList<String>) LargeAppInfo.getInstance().getCurrentQuestionInfo().get(newPosition).getTestInfo().get(1)).size() > 1) ? (((ArrayList<String>) LargeAppInfo.getInstance().getCurrentQuestionInfo().get(newPosition).getTestInfo().get(1)).get(LargeAppInfo.getInstance().getLanguageType())) : ((ArrayList<String>) LargeAppInfo.getInstance().getCurrentQuestionInfo().get(newPosition).getTestInfo().get(1)).get(0);

                }
            } catch (Exception e) {
                e.printStackTrace();
            }

        /*avoid the long press and vibration using setHapticFeedbackEnabled*/
        questionWebView.setOnLongClickListener(new View.OnLongClickListener() {
            @Override
            public boolean onLongClick(View v) {
                return true;
            }
        });
        questionWebView.setHapticFeedbackEnabled(false);

        solutionWebView.setOnLongClickListener(new View.OnLongClickListener() {
            @Override
            public boolean onLongClick(View v) {
                return true;
            }
        });
        questionWebView.setHapticFeedbackEnabled(false);
        try {
                questionsPosition = LargeAppInfo.getInstance().getCurrentQuestionInfo().get(newPosition).getQuestionIndex();
                if (userAnswer == null) {
                    userAnswer = (String) LargeAppInfo.getInstance().getCurrentQuestionInfo().get(newPosition).getAnswer().toLowerCase();
                }


                if (!loadedExpantion) {

                    if (LargeAppInfo.getInstance().getCurrentQuestionInfo().get(newPosition).getExpanded()) {
                        isExpanded = true;
                        readMoreLessTextView.setText(getResources().getString(R.string.str_read_less));
                        readMoreLessImageView.setRotation(180);
                    } else {
                        isExpanded = false;
                    }
                    loadedExpantion = true;
                } else {
                    if (isExpanded) {
                        readMoreLessTextView.setText(getResources().getString(R.string.str_read_less));
                        readMoreLessImageView.setRotation(180);
                    }
                }

            if (shortQuestions != null && shortQuestions.length() > 0 && !isExpanded) {
                questionWebView.loadDataWithBaseURL(
                        "file:///android_asset/",

                        shortQuestions


                        , "text/html", "UTF-8", null);

            } else {
                questionWebView.loadDataWithBaseURL(
                        "file:///android_asset/",

                        value


                        , "text/html", "UTF-8", null);
                if (shortQuestions == null || shortQuestions.length() == 0) {
                    expandCollapeLayout.setVisibility(View.GONE);
                    lineDividerView.setVisibility(View.INVISIBLE);
                }
            }

                if (userAnswer.equals(Constants.UNATTEMPTED)) {
                    if ((answerPainData.length() + ((String) ((ArrayList<Object>) (LargeAppInfo.getInstance().getCurrentQuestionInfo()).get(newPosition).getTestInfo().get(6)).get(1)).length()) == 0) {
                        solutionLinearLayout.setVisibility(View.GONE);
                        viewSolutionLinearLayout.setVisibility(View.GONE);
                    } else {
                        viewSolutionLinearLayout.setVisibility(View.VISIBLE);
                    }

                } else {
                    if ((answerPainData.length() + ((String) ((ArrayList<Object>) LargeAppInfo.getInstance().getCurrentQuestionInfo().get(newPosition).getTestInfo().get(6)).get(1)).length()) == 0) {
                        solutionLinearLayout.setVisibility(View.GONE);
                        viewSolutionLinearLayout.setVisibility(View.GONE);
                    } else {
                        viewSolution(false);
                    }


                    if (((String) ((ArrayList<Object>) LargeAppInfo.getInstance().getCurrentQuestionInfo().get(newPosition).getTestInfo().get(6)).get(2)).equals((String) ((ArrayList<Object>) LargeAppInfo.getInstance().getCurrentQuestionInfo().get(newPosition).getTestInfo().get(6)).get(0))) {
                        statusTextView.setText("Correct");
                    } else {
                        statusTextView.setText(((String) ((ArrayList<Object>) LargeAppInfo.getInstance().getCurrentQuestionInfo().get(newPosition).getTestInfo().get(6)).get(2)).toLowerCase().equals(Constants.UNATTEMPTED) ? "Skipped" : "Wrong");


                    }
                }
                if (((String) ((ArrayList<Object>) LargeAppInfo.getInstance().getCurrentQuestionInfo().get(newPosition).getTestInfo().get(6)).get(2)).equals((String) ((ArrayList<Object>) LargeAppInfo.getInstance().getCurrentQuestionInfo().get(newPosition).getTestInfo().get(6)).get(0))) {
                    statusTextView.setText("Correct");
                } else {
                    statusTextView.setText(((String) ((ArrayList<Object>) LargeAppInfo.getInstance().getCurrentQuestionInfo().get(newPosition).getTestInfo().get(6)).get(2)).toLowerCase().equals(Constants.UNATTEMPTED) ? "Skipped" : "Wrong");


                }

                questionTextView.setText("Q. " + Integer.toString(LargeAppInfo.getInstance().getCurrentQuestionInfo().get(newPosition).getQuestionIndex() + 1));

                questionTotalTextView.setText(" / " + LargeAppInfo.getInstance().getQuestionSize());

                timeTakenTextView.setText((((String) ((ArrayList<Object>) LargeAppInfo.getInstance().getCurrentQuestionInfo().get(newPosition).getTestInfo().get(6)).get(3)).equals("0")) ? "0 s" : ((String) ((ArrayList<Object>) LargeAppInfo.getInstance().getCurrentQuestionInfo().get(newPosition).getTestInfo().get(6)).get(3)));



            infoSolution.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View view) {

                    DialogUtils.getInstance().displayInfoPopupWindow(((String) ((ArrayList<Object>) (LargeAppInfo.getInstance().getCurrentQuestionInfo()).get(newPosition).getTestInfo().get(6)).get(4)), ((String) ((ArrayList<Object>) (LargeAppInfo.getInstance().getCurrentQuestionInfo()).get(newPosition).getTestInfo().get(6)).get(5)), infoSolution, TestSolutionFragment.this);
                }
            });

            viewSolutionLinearLayout.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View view) {
                    solutionLinearLayout.setVisibility(View.VISIBLE);
                    viewSolutionLinearLayout.setVisibility(View.GONE);

                        answerAdaptor.notifySelection((String) ((ArrayList<Object>) (LargeAppInfo.getInstance().getCurrentQuestionInfo()).get(newPosition).getTestInfo().get(6)).get(0));
                        try {
                            userAnswer = (String) ((ArrayList<Object>) (LargeAppInfo.getInstance().getCurrentQuestionInfo()).get(newPosition).getTestInfo().get(6)).get(0);

                            onTestDataChangeListener.onChangeOptionSelection(LargeAppInfo.getInstance().getCurrentQuestionInfo().get(newPosition).getQuestionIndex(), Integer.parseInt((String) ((ArrayList<Object>) (LargeAppInfo.getInstance().getCurrentQuestionInfo()).get(newPosition).getTestInfo().get(6)).get(0)));
                        } catch (NumberFormatException e) {
                            e.printStackTrace();
                        }

                    viewSolution(true);


                }
            });


            answerRecyclerView.setLayoutManager(new LinearLayoutManager(getActivity()));

                if (answerList.size() == 0) {
                    if (LargeAppInfo.getInstance().getCurrentQuestionInfo().size() > newPosition) {
                        answerList = (ArrayList<ArrayList<String>>) LargeAppInfo.getInstance().getCurrentQuestionInfo().get(newPosition).getTestInfo().get(2);
                    } else {
//                getActivity().finish();
                    }
                }
                answerAdaptor = new SolutionOptionAdaptor(answerList, LargeAppInfo.getInstance().getLanguageType(), userAnswer, ((String) ((ArrayList<Object>) (LargeAppInfo.getInstance().getCurrentQuestionInfo()).get(newPosition).getTestInfo().get(6)).get(0)).toLowerCase());


            answerRecyclerView.setAdapter(answerAdaptor);
            answerRecyclerView.setNestedScrollingEnabled(false);

            expandCollapeLayout.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View view) {
                    if (!isExpanded) {
                        isExpanded = true;
                        questionWebView.loadDataWithBaseURL(
                                "file:///android_asset/",

                                value


                                , "text/html", "UTF-8", null);
                        readMoreLessTextView.setText(getResources().getString(R.string.str_read_less));
                        readMoreLessImageView.setRotation(180);
                    } else {
                        isExpanded = false;
                        questionWebView.loadDataWithBaseURL(
                                "file:///android_asset/",

                                shortQuestions


                                , "text/html", "UTF-8", null);
                        readMoreLessTextView.setText(getResources().getString(R.string.read_more));
                        readMoreLessImageView.setRotation(360);
                        questionScrollView.scrollTo(0, 0);

                    }
                    onTestDataChangeListener.onChangeExpandData(questionsPosition, isExpanded);

                }
            });


            answerRecyclerView.addOnItemTouchListener(
                    new RecyclerItemClickListener(getActivity(), answerRecyclerView, new RecyclerItemClickListener.OnItemClickListener() {
                        @Override
                        public void onItemClick(View view, int position) {

                            if (userAnswer.toLowerCase().equals(Constants.UNATTEMPTED)) {
                                userAnswer = Integer.toString(position + 1);
                                answerAdaptor.notifySelection(userAnswer);

                                    onTestDataChangeListener.onChangeOptionSelection(LargeAppInfo.getInstance().getCurrentQuestionInfo().get(newPosition).getQuestionIndex(), (position + 1));
                                    if ((answerPainData.length() + ((String) ((ArrayList<Object>) (LargeAppInfo.getInstance().getCurrentQuestionInfo()).get(newPosition).getTestInfo().get(6)).get(1)).length()) != 0) {
                                        viewSolution(true);
                                    }

                                viewSolutionLinearLayout.setVisibility(View.GONE);

                            }


                        }

                        @Override
                        public void onItemLongClick(View view, int position) {

                        }
                    })
            );


            questionScrollView.post(new Runnable() {
                @Override
                public void run() {
                    questionScrollView.scrollTo(0, 0);

                }
            });
        } catch (Exception e) {

        }


    }

    public static TestSolutionFragment setInstance(int positionAdaptor, boolean hasPane, int position, String key, int total, String expandValue, boolean hasMultiLanguage, String correctAnswer, String solution, String userAnswer, String totalSecound, String percentage, String difficulty, String answerStatus, boolean isExpanded) {

        TestSolutionFragment fragment = new TestSolutionFragment();
        Bundle data = new Bundle();
//        data.putStringArrayList("question", question);
//        data.putString("question_no", Integer.toString(position + 1));
//        data.putInt(Constants.BUNDLE_KEY_POSITION, position);
        data.putInt("positionAdaptor", positionAdaptor);
//        data.putString("key", key);
//        data.putString("answer_status", answerStatus);
//        data.putBoolean("hasMultiLanguage", hasMultiLanguage);
//        data.putBoolean("haspane",hasPane);
//        data.putSerializable("answerlist", answersArrayList);
//        if (shortQuestion != null) {
//            data.putSerializable("shortquestion", shortQuestion);
//        }
//        data.putInt("total", total);
//        data.putString("correctAnswer", correctAnswer);
//        data.putString("solution", solution);
//        data.putString("totalSecound", totalSecound);
//        data.putString("percentage", percentage);
//        data.putString("difficulty", difficulty);
//        data.putBoolean("isExpandedData",isExpanded);
        fragment.setArguments(data);
        return fragment;
    }

    public static TestSolutionFragment setInstance(int positionAdaptor, boolean isGk) {

        TestSolutionFragment fragment = new TestSolutionFragment();
        Bundle data = new Bundle();
        data.putInt("positionAdaptor", positionAdaptor);
        data.putBoolean("type_gk", isGk);
        fragment.setArguments(data);
        return fragment;
    }

    @Override
    public void onDestroy() {
        super.onDestroy();

    }

    @Subscribe
    public void changeLanguage(final ChangeLanguage onChange) {

        if (isAdded()) {
            changeLanguage(onChange.changeLanguage);
        }

    }


    public void changeLanguage(final int changedLanguage) {
        try {
            if (((ArrayList<String>) LargeAppInfo.getInstance().getCurrentQuestionInfo().get(newPosition).getTestInfo().get(1)).size() > 1) {
//            if (getArguments().getBoolean("haspane")) {
//                ArrayList<String> paneDataList = LargeAppInfo.getInstance().getPanesList().get(((ArrayList<String>) LargeAppInfo.getInstance().getCurrentQuestionInfo().get(newPosition).getTestInfo().get(4)).get(0));
                if (((ArrayList<String>) LargeAppInfo.getInstance().getCurrentQuestionInfo().get(newPosition).getTestInfo().get(4)).size() > 0 && LargeAppInfo.getInstance().getPanesList() != null && LargeAppInfo.getInstance().getPanesList().get(((ArrayList<String>) LargeAppInfo.getInstance().getCurrentQuestionInfo().get(newPosition).getTestInfo().get(4)).get(0)) != null) {

                    shortQuestions = (((ArrayList<String>) LargeAppInfo.getInstance().getCurrentQuestionInfo().get(newPosition).getTestInfo().get(1)).size() > 1) ? ((ArrayList<String>) LargeAppInfo.getInstance().getCurrentQuestionInfo().get(newPosition).getTestInfo().get(1)).get(changedLanguage) : ((ArrayList<String>) LargeAppInfo.getInstance().getCurrentQuestionInfo().get(newPosition).getTestInfo().get(1)).get(0);
                    value = (LargeAppInfo.getInstance().getPanesList().get(((ArrayList<String>) LargeAppInfo.getInstance().getCurrentQuestionInfo().get(newPosition).getTestInfo().get(4)).get(0)).size() > 1) && LargeAppInfo.getInstance().getPanesList().get(((ArrayList<String>) LargeAppInfo.getInstance().getCurrentQuestionInfo().get(newPosition).getTestInfo().get(4)).get(0)).get(LargeAppInfo.getInstance().getLanguageType()).length() > 0 ? LargeAppInfo.getInstance().getPanesList().get(((ArrayList<String>) LargeAppInfo.getInstance().getCurrentQuestionInfo().get(newPosition).getTestInfo().get(4)).get(0)).get(changedLanguage) : LargeAppInfo.getInstance().getPanesList().get(((ArrayList<String>) LargeAppInfo.getInstance().getCurrentQuestionInfo().get(newPosition).getTestInfo().get(4)).get(0)).get(0);

                } else {

                    shortQuestions = null;
                    value = (((ArrayList<String>) LargeAppInfo.getInstance().getCurrentQuestionInfo().get(newPosition).getTestInfo().get(1)).size() > 1) ? ((ArrayList<String>) LargeAppInfo.getInstance().getCurrentQuestionInfo().get(newPosition).getTestInfo().get(1)).get(changedLanguage) : (((ArrayList<String>) LargeAppInfo.getInstance().getCurrentQuestionInfo().get(newPosition).getTestInfo().get(1))).get(0);

                }

//            Log.d("changed ques",""+shortQuestions);
//            Log.d("changed ques value",""+value);

                try {

//                value = URLDecoder.decode(value, "UTF-8");
//                value=decodeBase64(value.substring(32, value.length() - 32));

                    if (shortQuestions != null && shortQuestions.length() > 0) {
//                    shortQuestions = URLDecoder.decode(shortQuestions, "UTF-8");
//                    shortQuestions=decodeBase64(shortQuestions.substring(32, shortQuestions.length() - 32));

                        value = value + "\n" + shortQuestions;
                    }

                } catch (Exception e) {
                    e.printStackTrace();
                }

                if (shortQuestions != null && shortQuestions.length() > 0) {

                    questionWebView.loadDataWithBaseURL(
                            "file:///android_asset/",

                            (isExpanded) ? value : shortQuestions


                            , "text/html", "UTF-8", null);

                } else {
                    questionWebView.loadDataWithBaseURL(
                            "file:///android_asset/",

                            value


                            , "text/html", "UTF-8", null);
                    expandCollapeLayout.setVisibility(View.GONE);
                    lineDividerView.setVisibility(View.INVISIBLE);

                }

                questionWebView.setWebChromeClient(new WebChromeClient() {
                    public void onProgressChanged(WebView view, int progress) {
                        if (progress == 100) {
//                        if(!isloaded) {
//                            isloaded = true;
                            answerAdaptor.notifyLanguageChanged(changedLanguage);
//                            if (getUserVisibleHint()) {
//                                MainEventBus.getInstance().post(new LazyChangeLanguage(changedLanguage,getArguments().getInt("index")));
//                            }
//                            else {
//                                Log.d("called", "othere"+getArguments().getString("question_no"));
//
//                            }
//                        }
                        }
                    }
                });


            }
        } catch (Exception e) {
//            Toast.makeText(getActivity(),"Switching failed please exit and re open",).show();
        }
    }

    @Override
    public void onAttach(Context context) {
        super.onAttach(context);
        onTestDataChangeListener = (TestDataChangeListener) context;

        try {
            MainEventBus.getInstance().register(this);
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    @Override
    public void onDetach() {
        super.onDetach();

        try {
            MainEventBus.getInstance().unregister(this);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }


    public void viewSolution(final boolean canScroll) {
        solutionLinearLayout.setVisibility(View.VISIBLE);
        if (solutionValue == null) {
            try {
                solutionValue = ((String) ((ArrayList<Object>) (LargeAppInfo.getInstance().getCurrentQuestionInfo()).get(newPosition).getTestInfo().get(6)).get(1));

//                solutionValue = URLDecoder.decode(getArguments().getString("solution"), "UTF-8");
//                solutionValue=decodeBase64(solutionValue.substring(32, solutionValue.length() - 32));

            } catch (Exception e) {
                e.printStackTrace();
            }


        }
        solutionWebView.loadDataWithBaseURL(
                "file:///android_asset/",

                (answerPainData.length() > 0) ? answerPainData + "\n" + solutionValue : solutionValue


                , "text/html", "UTF-8", null);

        solutionWebView.setWebViewClient(new WebViewClient() {
            @Override
            public void onPageStarted(WebView view, String url, Bitmap favicon) {
                super.onPageStarted(view, url, favicon);

            }

            @Override
            public void onPageFinished(WebView view, String url) {
                super.onPageFinished(view, url);
                if (canScroll) {
                    questionScrollView.post(new Runnable() {
                        @Override
                        public void run() {
                            questionScrollView.scrollTo(0, (viewSolutionLinearLayout.getBottom() + 700));
                        }
                    });
                }
            }
        });
    }

   /* private String decodeBase64(String coded){
        byte[] valueDecoded= new byte[0];
        try {
            valueDecoded = Base64.decode(coded.getBytes("UTF-8"), Base64.DEFAULT);
        } catch (UnsupportedEncodingException e) {
        }
        return new String(valueDecoded);
    }*/

    public static int getBundleSizeInBytes(Bundle bundle) {
        if (bundle == null) {
            return 0;
        } else {
            Parcel parcel = Parcel.obtain();
            int size;

            parcel.writeBundle(bundle);
            size = parcel.dataSize();
            parcel.recycle();


            return size;
        }
    }
}
