package in.oliveboard.sdk.ui.fragments;

import android.annotation.TargetApi;
import android.content.Context;
import android.net.http.SslError;
import android.os.Bundle;
import android.support.v4.widget.NestedScrollView;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import android.webkit.SslErrorHandler;
import android.webkit.WebChromeClient;
import android.webkit.WebResourceError;
import android.webkit.WebResourceRequest;
import android.webkit.WebResourceResponse;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;

import com.squareup.otto.Subscribe;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;

import in.oliveboard.sdk.R;
import in.oliveboard.sdk.log.DebugMonitor;
import in.oliveboard.sdk.presenter.model.ChangeLanguage;
import in.oliveboard.sdk.ui.adapters.AnswerAdaptor;
import in.oliveboard.sdk.ui.base.BaseFragment;
import in.oliveboard.sdk.utils.LargeAppInfo;
import in.oliveboard.sdk.utils.MainEventBus;
import in.oliveboard.sdk.utils.RecyclerItemClickListener;
import in.oliveboard.sdk.utils.SubmitDialogCalled;
import in.oliveboard.sdk.utils.TestDataChangeListener;
import in.oliveboard.sdk.views.OliveBoardWebView;


public class TestQuestionFragment extends BaseFragment {
    OliveBoardWebView questionWebView;
    LinearLayout expandCollapeLayout;
    RecyclerView answerRecyclerView;
    TextView questionTextView;
    ImageView markerView;
    TextView readMoreLessTextView;
    ImageView readMoreLessImageView;
    View lineDividerView;
    NestedScrollView questionScrollView;
    TextView questionTotalTextView;

    TestDataChangeListener onTestDataChangeListener;

    String value;
    AnswerAdaptor answerAdaptor;
    ArrayList<ArrayList<String>> answerList = new ArrayList<>();
    ArrayList<String> gKAnswerList=new ArrayList<>();
    int newPosition = 0;

    int selectedOption = -1;
    boolean isExpanded;
    boolean isMarked = false;
    boolean initialLoaded = false;
    String shortQuestions;
    int questionsPosition = -1;
    boolean userVisblity = false;
    boolean loadedExpantion = false;

    @Override
    protected void initializeDagger() {

    }

    @Override
    protected void initializePresenter() {

    }

    @Override
    protected void initializeActivity() {

        questionWebView = (OliveBoardWebView)getView().findViewById(R.id.webView);
        expandCollapeLayout = (LinearLayout)getView().findViewById(R.id.expand_collapse_layout);
        answerRecyclerView = (RecyclerView)getView().findViewById(R.id.recycler_view);
        questionTextView = (TextView)getView().findViewById(R.id.question_textview);
        markerView = (ImageView)getView().findViewById(R.id.marker_imageview);
        readMoreLessTextView = (TextView)getView().findViewById(R.id.readmore_less_textview);
        readMoreLessImageView = (ImageView)getView().findViewById(R.id.readmore_less_imageview);
        lineDividerView = (View)getView().findViewById(R.id.line_divider);
        questionScrollView = (NestedScrollView)getView().findViewById(R.id.question_nested_scroll_view);
        questionTotalTextView = (TextView)getView().findViewById(R.id.question_total_textview);


        newPosition = getArguments().getInt("positionAdaptor");
//        Log.d("Bundle infoooo",">>>bundle<<<"+getBundleSizeInBytes(getArguments()));

        if (!getArguments().getBoolean("is_gk")) {
            try {

                /*if have short question means its a panes*/
//            if(getArguments().getBoolean("haspane")) {
                if (((ArrayList<String>) LargeAppInfo.getInstance().getCurrentQuestionInfo().get(newPosition).getTestInfo().get(4)).size() > 0 && LargeAppInfo.getInstance().getPanesList() != null && LargeAppInfo.getInstance().getPanesList().get(((ArrayList<String>) LargeAppInfo.getInstance().getCurrentQuestionInfo().get(newPosition).getTestInfo().get(4)).get(0)) != null) {

//               ArrayList<String> paneDataList = LargeAppInfo.getInstance().getPanesList().get(((ArrayList<String>) LargeAppInfo.getInstance().getCurrentQuestionInfo().get(newPosition).getTestInfo().get(4)).get(0));
                    shortQuestions = URLDecoder.decode((((ArrayList<String>) LargeAppInfo.getInstance().getCurrentQuestionInfo().get(newPosition).getTestInfo().get(1)).size() > 1) ? (((ArrayList<String>) LargeAppInfo.getInstance().getCurrentQuestionInfo().get(newPosition).getTestInfo().get(1)).get(LargeAppInfo.getInstance().getLanguageType())) : (((ArrayList<String>) LargeAppInfo.getInstance().getCurrentQuestionInfo().get(newPosition).getTestInfo().get(1))).get(0), "UTF-8");
                    value = URLDecoder.decode((LargeAppInfo.getInstance().getPanesList().get(((ArrayList<String>) LargeAppInfo.getInstance().getCurrentQuestionInfo().get(newPosition).getTestInfo().get(4)).get(0)).size() > 1) && LargeAppInfo.getInstance().getPanesList().get(((ArrayList<String>) LargeAppInfo.getInstance().getCurrentQuestionInfo().get(newPosition).getTestInfo().get(4)).get(0)).get(LargeAppInfo.getInstance().getLanguageType()).length() > 0 ? LargeAppInfo.getInstance().getPanesList().get(((ArrayList<String>) LargeAppInfo.getInstance().getCurrentQuestionInfo().get(newPosition).getTestInfo().get(4)).get(0)).get(LargeAppInfo.getInstance().getLanguageType()) : LargeAppInfo.getInstance().getPanesList().get(((ArrayList<String>) LargeAppInfo.getInstance().getCurrentQuestionInfo().get(newPosition).getTestInfo().get(4)).get(0)).get(0), "UTF-8") + "\n" + shortQuestions;

                } else {
                    value = URLDecoder.decode(((((ArrayList<String>) LargeAppInfo.getInstance().getCurrentQuestionInfo().get(newPosition).getTestInfo().get(1))).size() > 1) ? (((ArrayList<String>) LargeAppInfo.getInstance().getCurrentQuestionInfo().get(newPosition).getTestInfo().get(1))).get(LargeAppInfo.getInstance().getLanguageType()) : (((ArrayList<String>) LargeAppInfo.getInstance().getCurrentQuestionInfo().get(newPosition).getTestInfo().get(1))).get(0), "UTF-8");
                }
            } catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }


        /*avoid the long press and vibration using setHapticFeedbackEnabled*/
        questionWebView.setOnLongClickListener(new View.OnLongClickListener() {
            @Override
            public boolean onLongClick(View v) {
                return true;
            }
        });
        questionWebView.setHapticFeedbackEnabled(false);
        if (!getArguments().getBoolean("is_gk")) {
            questionsPosition = LargeAppInfo.getInstance().getCurrentQuestionInfo().get(newPosition).getQuestionIndex();

            if (!loadedExpantion) {

                if (LargeAppInfo.getInstance().getCurrentQuestionInfo().get(newPosition).getExpanded()) {
                    isExpanded = true;
                    readMoreLessTextView.setText(getResources().getString(R.string.str_read_less));
                    readMoreLessImageView.setRotation(180);
                } else {
                    isExpanded = false;
                }
                loadedExpantion = true;
            } else {
                if (isExpanded) {
                    readMoreLessTextView.setText("Read less");
                    readMoreLessImageView.setRotation(180);
                }
            }

            if (!initialLoaded) {
                initialLoaded = true;
                isMarked = LargeAppInfo.getInstance().getCurrentQuestionInfo().get(newPosition).isFavorite();
//            isMarked = getArguments().getBoolean("isFav");
//            selectedOption = getArguments().getInt("isSelected");
                selectedOption = LargeAppInfo.getInstance().getCurrentQuestionInfo().get(newPosition).getSelectionOption();

            }

        }


//Log.d("SelecteOption",selectedOption+"<<<>>>>"+questionsPosition);
        if (shortQuestions != null && shortQuestions.length() > 0 && !isExpanded) {
            questionWebView.loadDataWithBaseURL(
                    "file:///android_asset/",

                    shortQuestions


                    , "text/html", "UTF-8", null);

        } else {
            questionWebView.loadDataWithBaseURL(
                    "file:///android_asset/",

                    value


                    , "text/html", "UTF-8", null);
            if (shortQuestions == null || shortQuestions.length() == 0) {
                expandCollapeLayout.setVisibility(View.GONE);
                lineDividerView.setVisibility(View.INVISIBLE);
            }
        }

//        SpannableString ss=  new SpannableString("Q " + getArguments().getString("question_no")+" / "+getArguments().getInt("total"));
//        ss.setSpan(new RelativeSizeSpan(1.2f), 0,(2+getArguments().getString("question_no").length()), 0);
//        questionTextView.setText(ss);

//        SpannableString ss = new SpannableString("Q. " + getArguments().getString("question_no") + " / " + getArguments().getInt("total"));
////
//        ss.setSpan(new RelativeSizeSpan(1.2f), 0, (3+getArguments().getString("question_no").length()), 0);
//        ss.setSpan(new RelativeSizeSpan(0.9f), (4+getArguments().getString("question_no").length()),(5+getArguments().getString("question_no").length()), 0);
//        ss.setSpan(new RelativeSizeSpan(0.9f), (6+getArguments().getString("question_no").length()),("Q. " + getArguments().getString("question_no") + " / " + getArguments().getInt("total")).length(), 0);
//        questionTextView.setText(ss);




        if (!getArguments().getBoolean("is_gk")) {
            questionTextView.setText("Q. " + Integer.toString(LargeAppInfo.getInstance().getCurrentQuestionInfo().get(newPosition).getQuestionIndex() + 1));
            questionTotalTextView.setText(" / " + LargeAppInfo.getInstance().getQuestionAnswerInfo().size());

            if (answerList.size() == 0) {
                answerList = (ArrayList<ArrayList<String>>) LargeAppInfo.getInstance().getCurrentQuestionInfo().get(newPosition).getTestInfo().get(2);

            }
            answerRecyclerView.setLayoutManager(new LinearLayoutManager(getActivity()));
            answerAdaptor = new AnswerAdaptor(answerList, selectedOption, LargeAppInfo.getInstance().getLanguageType());

            answerRecyclerView.setAdapter(answerAdaptor);
            answerRecyclerView.setNestedScrollingEnabled(false);
            expandCollapeLayout.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View view) {
                    if (!isExpanded) {
                        isExpanded = true;
                        questionWebView.loadDataWithBaseURL(
                                "file:///android_asset/",

                                value


                                , "text/html", "UTF-8", null);
                        readMoreLessTextView.setText("Read less");
                        readMoreLessImageView.setRotation(180);
                    } else {
                        isExpanded = false;
                        questionWebView.loadDataWithBaseURL(
                                "file:///android_asset/",

                                shortQuestions


                                , "text/html", "UTF-8", null);
                        readMoreLessTextView.setText(getResources().getString(R.string.read_more));
                        readMoreLessImageView.setRotation(360);
                        questionScrollView.scrollTo(0, 0);

                    }
                    onTestDataChangeListener.onChangeExpandData(questionsPosition, isExpanded);
                }
            });
        }

        if (isMarked) {
            markerView.setImageResource(R.drawable.ic_star);
        } else {
            markerView.setImageResource(R.drawable.ic_star_uncheck);
        }
        markerView.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                if (!isMarked) {
                    markerView.setImageResource(R.drawable.ic_star);
                    isMarked = true;
                } else {
                    markerView.setImageResource(R.drawable.ic_star_uncheck);
                    isMarked = false;
                }
                onTestDataChangeListener.onChangeFavorite(questionsPosition, isMarked);

            }
        });


        answerRecyclerView.addOnItemTouchListener(
                new RecyclerItemClickListener(getActivity(), answerRecyclerView, new RecyclerItemClickListener.OnItemClickListener() {
                    @Override
                    public void onItemClick(View view, int position) {


                        if (selectedOption == position) {

                            selectedOption = -1;

                        } else {

                            selectedOption = position;
                        }
                        if (!getArguments().getBoolean("is_gk")) {

                            onTestDataChangeListener.onChangeOptionSelection(questionsPosition, selectedOption);

                        }
                        answerAdaptor.notifySelection(selectedOption);

                    }

                    @Override
                    public void onItemLongClick(View view, int position) {

                    }
                })
        );


        questionScrollView.post(new Runnable() {
            @Override
            public void run() {
                if (questionScrollView != null) {
                    questionScrollView.scrollTo(0, 0);
                }

            }
        });


        questionWebView.setWebViewClient(new WebViewClient() {
            @Override
            public void onPageFinished(WebView view, String url) {
            }


            @SuppressWarnings("deprecation")
            @Override
            public void onReceivedError(WebView view, int errorCode, String description, String failingUrl) {
                // Handle the error
                DebugMonitor.getLogger().d("main error", "render failed>>>>getDescription()" + "<<<" + errorCode);

            }

            @TargetApi(android.os.Build.VERSION_CODES.M)
            @Override
            public void onReceivedError(WebView view, WebResourceRequest req, WebResourceError error) {
                // Redirect to deprecated method, so you can use it in all SDK versions
                DebugMonitor.getLogger().d("main error", "render failed>>>>" + error.getDescription() + "<<<" + error.getErrorCode());

                onReceivedError(view, error.getErrorCode(), error.getDescription().toString(), req.getUrl().toString());
            }
//            @Override
//            public void onReceivedError(WebView view, WebResourceRequest request, WebResourceError error) {
////                Toast.makeText(getActivity(),"main error>>>>"+error.getDescription()+"<<<"+error.getErrorCode(),1).show();
//           Log.d("main error","render failed>>>>"+error.getDescription()+"<<<"+error.getErrorCode());
//            }

            @Override
            public void onReceivedHttpError(
                    WebView view, WebResourceRequest request, WebResourceResponse errorResponse) {
            }

            @Override
            public void onReceivedSslError(WebView view, SslErrorHandler handler,
                                           SslError error) {
            }
        });
    }

    @Override
    public int getLayoutId() {
        return R.layout.fragment_test_question;
    }


    public static TestQuestionFragment setInstance(int positionAdaptor, boolean isGk) {
        TestQuestionFragment fragment = new TestQuestionFragment();
        Bundle data = new Bundle();
        data.putBoolean("is_gk", isGk);
        data.putInt("positionAdaptor", positionAdaptor);
        fragment.setArguments(data);
        return fragment;
    }

    @Override
    public void onAttach(Context context) {
        super.onAttach(context);
        onTestDataChangeListener = (TestDataChangeListener) context;

        if (!getArguments().getBoolean("is_gk")) {
            try {
                MainEventBus.getInstance().register(this);
            } catch (Exception e) {
                e.printStackTrace();
            }
        }

    }


    @Override
    public void onDestroy() {
        super.onDestroy();

    }

    @Override
    public void onDetach() {
        super.onDetach();
        if (!getArguments().getBoolean("is_gk")) {
            try {

                MainEventBus.getInstance().unregister(this);
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    }


    @Override
    public void onPause() {
        super.onPause();
        if (!getArguments().getBoolean("is_gk")) {
            if (userVisblity && LargeAppInfo.getInstance().canEndSession()) {
//            Log.d("onPause", ">>>pause called");
                onTestDataChangeListener.onSessionReading(LargeAppInfo.getInstance().getCurrentQuestionInfo().get(newPosition).getQuestionIndex(), LargeAppInfo.getInstance().getCurrentQuestionInfo().get(newPosition).getKey());
                userVisblity = false;
            }
        }
    }

    @Override
    public void onResume() {
        super.onResume();
        if (!getArguments().getBoolean("is_gk")) {
            if (getUserVisibleHint()) {
                userVisblity = true;
//            onTestDataChangeListener.onChangeQuestion(getArguments().getString("key"));

            }
        }


    }

    @Override
    public void setUserVisibleHint(boolean isVisibleToUser) {
        super.setUserVisibleHint(isVisibleToUser);
        if (!getArguments().getBoolean("is_gk")) {
            if (isVisibleToUser) {
                userVisblity = true;
//            if(onTestDataChangeListener!=null) {
//                onTestDataChangeListener.onChangeQuestion(getArguments().getString("key"));
//            }

            } else {
                if (userVisblity) {

                    onTestDataChangeListener.onSessionReading(LargeAppInfo.getInstance().getCurrentQuestionInfo().get(newPosition).getQuestionIndex(), LargeAppInfo.getInstance().getCurrentQuestionInfo().get(newPosition).getKey());

                }

                userVisblity = false;


            }
        }
    }

    @Subscribe
    public void onSubmitDialogCalled(SubmitDialogCalled submit) {
        if (!getArguments().getBoolean("is_gk")) {
            if (userVisblity)
                onTestDataChangeListener.onSessionReading(LargeAppInfo.getInstance().getCurrentQuestionInfo().get(newPosition).getQuestionIndex(),LargeAppInfo.getInstance().getCurrentQuestionInfo().get(newPosition).getKey());
        }
    }


    @Subscribe
    public void changeLanguage(final ChangeLanguage onChange) {
        if (!getArguments().getBoolean("is_gk")) {
            if (isAdded()) {
                changeLanguage(onChange.changeLanguage);
            }
        }

    }

//    @Subscribe
//    public void lazyLoadLanguage(final LazyChangeLanguage onChange) {
//
//        if(getUserVisibleHint()==false) {
//            if(isAdded()) {
//                changeLanguage(onChange.changeLanguage);
//            }
//
////            Log.d("dkjfsas",""+);
//        }

//    }


    public void changeLanguage(final int changedLanguage) {
        try {
            if (((ArrayList<String>) LargeAppInfo.getInstance().getCurrentQuestionInfo().get(newPosition).getTestInfo().get(1)).size() > 1) {


                if (((ArrayList<String>) LargeAppInfo.getInstance().getCurrentQuestionInfo().get(newPosition).getTestInfo().get(4)).size() > 0 && LargeAppInfo.getInstance().getPanesList() != null && LargeAppInfo.getInstance().getPanesList().get(((ArrayList<String>) LargeAppInfo.getInstance().getCurrentQuestionInfo().get(newPosition).getTestInfo().get(4)).get(0)) != null) {

//            }
//
//            if (getArguments().getBoolean("haspane")) {
                    shortQuestions = ((((ArrayList<String>)LargeAppInfo.getInstance().getCurrentQuestionInfo().get(newPosition).getTestInfo().get(1))).size() > 1) ? (((ArrayList<String>) LargeAppInfo.getInstance().getCurrentQuestionInfo().get(newPosition).getTestInfo().get(1))).get(changedLanguage) : (((ArrayList<String>) LargeAppInfo.getInstance().getCurrentQuestionInfo().get(newPosition).getTestInfo().get(1))).get(0);
                    value = (LargeAppInfo.getInstance().getPanesList().get(((ArrayList<String>) LargeAppInfo.getInstance().getCurrentQuestionInfo().get(newPosition).getTestInfo().get(4)).get(0)).size() > 1) && LargeAppInfo.getInstance().getPanesList().get(((ArrayList<String>) LargeAppInfo.getInstance().getCurrentQuestionInfo().get(newPosition).getTestInfo().get(4)).get(0)).get(LargeAppInfo.getInstance().getLanguageType()).length() > 0 ? LargeAppInfo.getInstance().getPanesList().get(((ArrayList<String>) LargeAppInfo.getInstance().getCurrentQuestionInfo().get(newPosition).getTestInfo().get(4)).get(0)).get(changedLanguage) : LargeAppInfo.getInstance().getPanesList().get(((ArrayList<String>) LargeAppInfo.getInstance().getCurrentQuestionInfo().get(newPosition).getTestInfo().get(4)).get(0)).get(0);

                } else {
                    shortQuestions = null;
                    value = ((((ArrayList<String>) LargeAppInfo.getInstance().getCurrentQuestionInfo().get(newPosition).getTestInfo().get(1))).size() > 1) ? (((ArrayList<String>) LargeAppInfo.getInstance().getCurrentQuestionInfo().get(newPosition).getTestInfo().get(1))).get(changedLanguage) : (((ArrayList<String>) LargeAppInfo.getInstance().getCurrentQuestionInfo().get(newPosition).getTestInfo().get(1))).get(0);

                }

                try {

                    value = URLDecoder.decode(value, "UTF-8");
                    if (shortQuestions != null && shortQuestions.length() > 0) {
                        shortQuestions = URLDecoder.decode(shortQuestions, "UTF-8");
                        value = value + "\n" + shortQuestions;
                    }

                } catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }

                if (shortQuestions != null && shortQuestions.length() > 0) {

                    questionWebView.loadDataWithBaseURL(
                            "file:///android_asset/",

                            (isExpanded) ? value : shortQuestions


                            , "text/html", "UTF-8", null);

                } else {
                    questionWebView.loadDataWithBaseURL(
                            "file:///android_asset/",

                            value


                            , "text/html", "UTF-8", null);
                    expandCollapeLayout.setVisibility(View.GONE);
                    lineDividerView.setVisibility(View.INVISIBLE);

                }

                questionWebView.setWebChromeClient(new WebChromeClient() {
                    public void onProgressChanged(WebView view, int progress) {
                        if (progress == 100) {
//                        if(!isloaded) {
//                            isloaded = true;
                            answerAdaptor.notifyLanguageChanged(changedLanguage);
//                            if (getUserVisibleHint()) {
//                                MainEventBus.getInstance().post(new LazyChangeLanguage(changedLanguage,getArguments().getInt("index")));
//                            }
//                            else {
//                                Log.d("called", "othere"+getArguments().getString("question_no"));
//
//                            }
//                        }
                        }
                    }
                });


            }
        } catch (Exception e) {

        }
    }

   /* public static int getBundleSizeInBytes(Bundle bundle) {
        if(bundle==null)
        {return 0;
        }
        else {
            Parcel parcel = Parcel.obtain();
            int size;

            parcel.writeBundle(bundle);
            size = parcel.dataSize();
            parcel.recycle();


            return size;
        }
    }*/


}
