package in.oliveboard.sdk.ui.fragments;

import android.os.Bundle;
import android.support.annotation.Nullable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.LinearLayout;
import android.widget.ProgressBar;

import in.oliveboard.sdk.R;
import in.oliveboard.sdk.ui.WebActivity;
import in.oliveboard.sdk.ui.base.BaseFragment;
import in.oliveboard.sdk.utils.LargeDataHandler;

public class SolutionWebDetailFragment extends BaseFragment {

    public WebView summeryWebView;
    public ProgressBar progressBar;
    LinearLayout tryAgainLayout;

    @Override
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container,
                             @Nullable Bundle savedInstanceState) {
        super.onCreateView(inflater,container,savedInstanceState);
        view = inflater.inflate(getLayoutId(), container, false);

        if (presenter != null) {
            presenter.initialize(getArguments());
        }

        summeryWebView = (WebView)view.findViewById(R.id.web_view);
        progressBar = (ProgressBar)view.findViewById(R.id.progressbar_layer);
        tryAgainLayout = (LinearLayout)view.findViewById(R.id.try_again_layer);

        return view;
    }


    @Override
    protected void initializeDagger() {
       // App app = (App) getActivity().getApplicationContext();
      //  LogEvents.getInstance().passEvents(getActivity(),"Solution and analysis","view_page");
    }

    @Override
    protected void initializePresenter() {

    }

    @Override
    protected void initializeActivity() {

        try {
            WebSettings settings = summeryWebView.getSettings();
            settings.setJavaScriptEnabled(true);
            progressBar.setVisibility(View.VISIBLE);

        }
        catch (Exception e)
        {

        }

        tryAgainLayout.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                if (progressBar != null) {
                    progressBar.setVisibility(View.VISIBLE);
                }
                if(tryAgainLayout!=null) {
                    tryAgainLayout.setVisibility(View.GONE);
                }
                if(summeryWebView!=null)
                {
                    summeryWebView.setVisibility(View.VISIBLE);
                }
                if(LargeDataHandler.getInstance().getSummaryData()!=null) {
                    summeryWebView.loadUrl(LargeDataHandler.getInstance().getSummaryData().detailAnalysisWebView);
                }
            }
        });

        summeryWebView.setWebViewClient(new WebViewClient() {

            @Override
            public boolean shouldOverrideUrlLoading(WebView view, String url) {
//                        CookieManager.getInstance().setCookie(url, "uauth=" + BasicConfig.getInstance().getAuthData(App.getContext()));
                view.loadUrl(url);
                return super.shouldOverrideUrlLoading(view, url);
            }
            @Override
            public void onPageFinished(WebView view, String url) {
                try {
                    if(isAdded()) {
                        if (progressBar != null) {
                            progressBar.setVisibility(View.GONE);
                        }
                    }
                }
                catch (Exception e)
                {

                }

//                Log.d("showwwwww",view.getContentHeight()+">>>");
//                view.loadUrl("javascript:AndroidFunction.resize(document.body.scrollHeight)");
            }
            @Override
            public void onReceivedError (WebView view, int errorCode,
                                         String description, String failingUrl) {
//                Toast.makeText(getActivity(),">>>>>>>>>>>ERROR"+errorCode,1).show();
                try {
                    if (errorCode == ERROR_TIMEOUT || errorCode == ERROR_CONNECT||errorCode==ERROR_HOST_LOOKUP) {
                        if (progressBar != null) {
                            progressBar.setVisibility(View.GONE);
                        }
                        if(tryAgainLayout!=null) {
                            tryAgainLayout.setVisibility(View.VISIBLE);
                        }
                        if(summeryWebView!=null)
                        {
                            summeryWebView.setVisibility(View.GONE);
                        }
//                    view.stopLoading();  // may not be needed
                        view.loadData("retrying.....", "text/html", "utf-8");
                    }
                }
                catch (Exception e)
                {

                }
            }
        });
        if(LargeDataHandler.getInstance().getSummaryData()!=null) {
            summeryWebView.loadUrl(LargeDataHandler.getInstance().getSummaryData().detailAnalysisWebView);
        }
    }

    @Override
    public int getLayoutId() {
        return R.layout.fragment_webview;
    }

    public static SolutionWebDetailFragment newInstance() {
         return new SolutionWebDetailFragment();
    }


}
