package in.oliveboard.sdk.ui.fragments;

import android.content.Intent;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.CookieManager;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.ProgressBar;

import java.util.regex.Matcher;
import java.util.regex.Pattern;


import in.oliveboard.sdk.R;
import in.oliveboard.sdk.ui.base.BaseFragment;

import in.oliveboard.sdk.utils.BaseSharedPreferences;
import in.oliveboard.sdk.utils.BasicConfig;
import in.oliveboard.sdk.utils.Constants;
import in.oliveboard.sdk.utils.Utils;

public class PlanFragment extends BaseFragment {
    WebView webView;
    ProgressBar progressBar;
    BaseSharedPreferences baseSharedPreferences;

    @Override
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container,
                             @Nullable Bundle savedInstanceState) {
        super.onCreateView(inflater,container,savedInstanceState);
        view = inflater.inflate(getLayoutId(), container, false);

        if (presenter != null) {
            presenter.initialize(getArguments());
        }

        webView = (WebView)view.findViewById(R.id.webView);
        progressBar = (ProgressBar)view.findViewById(R.id.progressbar_layer);


        return view;
    }

    @Override
    protected void initializeDagger() {
       // App app = (App) getActivity().getApplicationContext();
    }

    @Override
    protected void initializePresenter() {

    }

    @Override
    protected void initializeActivity() {


        if (Utils.isConnectionAvailable(getActivity())) {
//            pdLoading = ProgressDialog.show(getActivity(), "", getResources().getString(R.string.progress_text), true);
//            pdLoading.setCancelable(true);
//            pdLoading.setCanceledOnTouchOutside(false);

            WebSettings webSettings = webView.getSettings();
            webSettings.setJavaScriptEnabled(true);
            webView.getSettings().setLoadWithOverviewMode(true);
            webView.getSettings().setUseWideViewPort(true);

            webView.setScrollBarStyle(WebView.SCROLLBARS_OUTSIDE_OVERLAY);
            webView.setScrollbarFadingEnabled(false);
            webView.getSettings().setSaveFormData(false);

            webView.setWebViewClient(new WebViewClient() {

                @Override
                public boolean shouldOverrideUrlLoading(WebView view, String url) {
                    if(isYoutube(url))
                    {
                        try
                        {
                            Intent intent = new Intent(Intent.ACTION_VIEW);
                            intent.setData(Uri.parse(url));
                            startActivity(intent);
                        }
                        catch (Exception e)
                        {
                            CookieManager.getInstance().setCookie(url, "uauth=" + BasicConfig.getInstance().getAuthData(getContext()));
                            view.loadUrl(url);
                        }

                    }
                    else {
                        CookieManager.getInstance().setCookie(url, "uauth=" +BasicConfig.getInstance().getAuthData(getContext()));
                        view.loadUrl(url);
                    }

                    return true;
                }

                @Override
                public void onPageStarted(WebView view, String url, Bitmap favicon) {
//                    pdLoading.show();

                }

                @Override
                public void onPageFinished(WebView view, String url) {
//                    pdLoading.dismiss();
                    if(isAdded()) {
                        progressBar.setVisibility(View.GONE);
                    }
                }

            });

                    webView.loadUrl(getArguments().getString(Constants.BUNDLE_KEY_PAYMENT_URL));
            webView.setOnKeyListener(new View.OnKeyListener() {

                public boolean onKey(View v, int keyCode, KeyEvent event) {
                    if (keyCode == KeyEvent.KEYCODE_BACK
                            && event.getAction() == MotionEvent.ACTION_UP
                            && webView.canGoBack()) {
                        webView.goBack();
                        return true;
                    }
                    return false;
                }
            });



        } else {
            Utils.showToast(getActivity(), Constants.ERROR_INTERNET_STATUS);
        }
    }

    @Override
    public int getLayoutId() {
        return R.layout.fragment_plan;
    }

    public static PlanFragment newInstance(String paymentUrl) {
        Bundle bundleData = new Bundle();
        bundleData.putString(Constants.BUNDLE_KEY_PAYMENT_URL, paymentUrl);
        PlanFragment planFragment = new PlanFragment();
        planFragment.setArguments(bundleData);
        return planFragment;
    }

    public static boolean isYoutube(String youtubeUrl) {
        if (youtubeUrl == null || youtubeUrl.trim().contentEquals("")) {
            return false;
        }
        youtubeUrl = youtubeUrl.trim();
        String regexPattern = "^(?:https?:\\/\\/)?(?:[0-9A-Z-]+\\.)?(?:youtu\\.be\\/|youtube\\.com\\S*[^\\w\\-\\s])([\\w\\-]{11})(?=[^\\w\\-]|$)(?![?=&+%\\w]*(?:['\"][^<>]*>|<\\/a>))[?=&+%\\w]*";
        Pattern regexCompiled = Pattern.compile(regexPattern, Pattern.CASE_INSENSITIVE);
        Matcher regexMatcher = regexCompiled.matcher(youtubeUrl);
        if (regexMatcher.find()) {
            return true;
        }
        return false;
    }
}
