package in.oliveboard.sdk.ui.adapters;

import android.os.Build;
import android.support.v7.widget.RecyclerView;
import android.text.Html;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;

import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;

import in.oliveboard.sdk.R;
import in.oliveboard.sdk.ui.adapters.viewholder.AnswerViewHolder;
import in.oliveboard.sdk.utils.Constants;


public class SolutionOptionAdaptor extends RecyclerView.Adapter<RecyclerView.ViewHolder> {

    public static final int NORMAL_CELL = 0;
    public static final int CORRECT_CELL = 1;
    public static final int INCORRECT_CELL = 2;
    ArrayList<ArrayList<String>> answerDataList;
    int lanuageType;
    String userAnswer;
    String correctAnswer;
    List<String> data;

    public SolutionOptionAdaptor(ArrayList<ArrayList<String>> answerDataList, int lanuageType, String userAnswer, String correctAnswer) {
        this.answerDataList = answerDataList;
        this.lanuageType = lanuageType;
        this.userAnswer = userAnswer;
        this.correctAnswer = correctAnswer;

//        Log.d("correctAnswer",correctAnswer);
//        Log.d("userAnswer",userAnswer);
    }
    public SolutionOptionAdaptor(List data,String userAnswer, String correctAnswer) {
        this.data = data;
        this.userAnswer = userAnswer;
        this.correctAnswer = correctAnswer;

//        Log.d("correctAnswer",correctAnswer);
//        Log.d("userAnswer",userAnswer);
    }

    @Override
    public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        if (viewType == NORMAL_CELL) {

            View itemView = LayoutInflater.from(parent.getContext())
                    .inflate(R.layout.row_answer, parent, false);
            return new AnswerViewHolder(itemView);
        } else if (viewType == CORRECT_CELL) {
            View itemView = LayoutInflater.from(parent.getContext())
                    .inflate(R.layout.row_answer_correct, parent, false);
            return new AnswerViewHolder(itemView);
        } else {
            View itemView = LayoutInflater.from(parent.getContext())
                    .inflate(R.layout.row_answer_wrong, parent, false);
            return new AnswerViewHolder(itemView);
        }


    }

    @Override
    public void onBindViewHolder(RecyclerView.ViewHolder mainholder, final int position) {

        if (mainholder instanceof AnswerViewHolder) {

            AnswerViewHolder holder = (AnswerViewHolder) mainholder;
            holder.optionTextView.setText(Constants.ALPHABETS[position]);
            if(data==null) {
                try {
//                String answerDecoded=URLDecoder.decode((answerDataList.get(position).size() > 1) ? answerDataList.get(position).get(lanuageType) : answerDataList.get(position).get(0), "UTF-8");

                    if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.N) {
                        holder.answerTextView.setText(Html.fromHtml((answerDataList.get(position).size() > 1) ? answerDataList.get(position).get(lanuageType) : answerDataList.get(position).get(0), Html.FROM_HTML_MODE_LEGACY));

//                    holder.answerTextView.setText(Html.fromHtml(URLDecoder.decode((answerDataList.get(position).size() > 1) ? answerDataList.get(position).get(lanuageType) : answerDataList.get(position).get(0), "UTF-8"), Html.FROM_HTML_MODE_LEGACY));

                    } else {
                        holder.answerTextView.setText(Html.fromHtml((answerDataList.get(position).size() > 1) ? answerDataList.get(position).get(lanuageType) : answerDataList.get(position).get(0)));
//                    holder.answerTextView.setText(Html.fromHtml(URLDecoder.decode((answerDataList.get(position).size() > 1) ? answerDataList.get(position).get(lanuageType) : answerDataList.get(position).get(0), "UTF-8")));

                    }

//                                holder.answerTextView.setText("In a country so extensively covered with wood as this");

                } catch (Exception e) {

                }
            }
            else
            {
                try {
//                String answerDecoded=URLDecoder.decode((answerDataList.get(position).size() > 1) ? answerDataList.get(position).get(lanuageType) : answerDataList.get(position).get(0), "UTF-8");

                    if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.N) {
                        holder.answerTextView.setText(Html.fromHtml(URLDecoder.decode(data.get(position),"UTF-8"), Html.FROM_HTML_MODE_LEGACY));

//                    holder.answerTextView.setText(Html.fromHtml(URLDecoder.decode((answerDataList.get(position).size() > 1) ? answerDataList.get(position).get(lanuageType) : answerDataList.get(position).get(0), "UTF-8"), Html.FROM_HTML_MODE_LEGACY));

                    } else {
                        holder.answerTextView.setText(Html.fromHtml(URLDecoder.decode(data.get(position),"UTF-8")));
//                    holder.answerTextView.setText(Html.fromHtml(URLDecoder.decode((answerDataList.get(position).size() > 1) ? answerDataList.get(position).get(lanuageType) : answerDataList.get(position).get(0), "UTF-8")));

                    }

//                                holder.answerTextView.setText("In a country so extensively covered with wood as this");

                } catch (Exception e) {

                }
            }
        }
    }

    @Override
    public int getItemCount() {
        if(data!=null)
        {
            return data.size();
        }
        else
        {
            return answerDataList.size();
        }

    }


    @Override
    public int getItemViewType(int position) {
        if (userAnswer.equals(Constants.UNATTEMPTED)) {

            return NORMAL_CELL;

        } else if (Integer.toString((position+1)).equals(correctAnswer)) {

            return CORRECT_CELL;

        }
        else if (!(correctAnswer.equals(userAnswer))&&userAnswer.equals(Integer.toString((position+1)))) {

            return INCORRECT_CELL;

        }
        else {
            return NORMAL_CELL;
        }


    }
    public void notifySelection(String selectedUserAnswer)
    {
        userAnswer=selectedUserAnswer;
        notifyDataSetChanged();
    }

    public void notifyLanguageChanged(int lanuageType)
    {
        this.lanuageType=lanuageType;
        notifyDataSetChanged();
    }

   /* private String decodeBase64(String coded){
        byte[] valueDecoded= new byte[0];
        try {
            valueDecoded = Base64.decode(coded.getBytes("UTF-8"), Base64.DEFAULT);
        } catch (UnsupportedEncodingException e) {
        }
        return new String(valueDecoded);
    }*/
}
