package in.oliveboard.sdk.ui.adapters;

import android.content.Context;
import android.os.Build;
import android.support.v4.content.ContextCompat;
import android.support.v7.widget.RecyclerView;
import android.text.Html;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;

import java.net.URLDecoder;
import java.util.ArrayList;

import in.oliveboard.sdk.R;
import in.oliveboard.sdk.presenter.model.TestAppModel;
import in.oliveboard.sdk.ui.adapters.viewholder.FilterViewHolder;
import in.oliveboard.sdk.utils.Constants;


public class SolutionFilterAdapter extends RecyclerView.Adapter<FilterViewHolder> {

    int type;
    int languageType = 0;
    Context context;
    ArrayList<TestAppModel> filterDataList;

    public SolutionFilterAdapter(ArrayList<TestAppModel> filterDataList, Context context, int type, int languageType) {
        this.filterDataList = filterDataList;
        this.context = context;
        this.type = type;
        this.languageType = languageType;
    }

    @Override
    public FilterViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        View itemView = LayoutInflater.from(parent.getContext())
                .inflate(R.layout.test_app_filter_card, parent, false);

        return new FilterViewHolder(itemView);
    }

    @Override
    public void onBindViewHolder(FilterViewHolder holder, int position) {
        holder.questionNumberTextView.setText((filterDataList.get(position).getQuestionIndex() + 1) + ".");
        try {
//            Log.d((filterDataList.get(position).getQuestionIndex() + 1)+"data olka",URLDecoder.decode(((ArrayList<String>) filterDataList.get(position).getTestInfo().get(3)).size()>1?((ArrayList<String>) filterDataList.get(position).getTestInfo().get(3)).get(languageType):((ArrayList<String>) filterDataList.get(position).getTestInfo().get(3)).get(0), "UTF-8"));
            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.N) {
                holder.title.setText(Html.fromHtml(URLDecoder.decode(((ArrayList<String>) filterDataList.get(position).getTestInfo().get(3)).size() > 1 ? ((ArrayList<String>) filterDataList.get(position).getTestInfo().get(3)).get(languageType) : ((ArrayList<String>) filterDataList.get(position).getTestInfo().get(3)).get(0), "UTF-8"), Html.FROM_HTML_MODE_LEGACY));
            } else {
                holder.title.setText(Html.fromHtml(URLDecoder.decode(((ArrayList<String>) filterDataList.get(position).getTestInfo().get(3)).size() > 1 ? ((ArrayList<String>) filterDataList.get(position).getTestInfo().get(3)).get(languageType) : ((ArrayList<String>) filterDataList.get(position).getTestInfo().get(3)).get(0), "UTF-8")));

            }
        } catch (Exception e) {
            e.printStackTrace();
            holder.title.setText("short question utf encoding is wrong");

        }
        if (type == Constants.TYPE_ALL) {


            if (((String) ((ArrayList<Object>) filterDataList.get(position).getTestInfo().get(6)).get(2)).toLowerCase().equals(Constants.UNATTEMPTED)) {

                holder.iconStatus.setBackgroundColor(ContextCompat.getColor(context, R.color.filter_grey));


            } else if (((String) ((ArrayList<Object>) filterDataList.get(position).getTestInfo().get(6)).get(0)).equals((String) ((ArrayList<Object>) filterDataList.get(position).getTestInfo().get(6)).get(2))) {

                holder.iconStatus.setBackgroundColor(ContextCompat.getColor(context, R.color.green_correct_answer));

            } else {

                holder.iconStatus.setBackgroundColor(ContextCompat.getColor(context, R.color.wrong_color));

            }


        } else if (type == Constants.FILTER_CORRECT) {
            holder.iconStatus.setBackgroundColor(ContextCompat.getColor(context, R.color.green_correct_answer));

        } else if (type == Constants.FILTER_WRONG) {
            holder.iconStatus.setBackgroundColor(ContextCompat.getColor(context, R.color.wrong_color));

        } else if (type == Constants.FILTER_UN_ATTEMPTED) {
            holder.iconStatus.setBackgroundColor(ContextCompat.getColor(context, R.color.filter_grey));

        }

    }

    @Override
    public int getItemCount() {
        return filterDataList.size();
    }


}
