package in.oliveboard.sdk.ui.adapters;

import android.content.Context;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;

import java.util.ArrayList;

import in.oliveboard.sdk.R;
import in.oliveboard.sdk.ui.adapters.viewholder.MockDescHeaderViewHolder;
import in.oliveboard.sdk.ui.adapters.viewholder.MockTestListViewHolder;

public class MockTestListAdaptor extends RecyclerView.Adapter<RecyclerView.ViewHolder> {
    Context context;
    ArrayList<ArrayList<String>> mockTestModelList;
    String descriptionText;
    private static final int TYPE_HEADER = 0;
    private static final int TYPE_DATA = 1;


    public MockTestListAdaptor(Context context, ArrayList<ArrayList<String>> mockTestModelList, String descriptionText) {

        this.context = context;
        this.mockTestModelList = mockTestModelList;
        this.descriptionText = descriptionText;
    }

    @Override
    public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        if (viewType == TYPE_HEADER) {
            View itemView = LayoutInflater.from(parent.getContext())
                    .inflate(R.layout.mock_desc_header, parent, false);
            return new MockDescHeaderViewHolder(itemView);

        } else {
            View itemView = LayoutInflater.from(parent.getContext())
                    .inflate(R.layout.mock_test_card, parent, false);
            return new MockTestListViewHolder(itemView);

        }


    }

    @Override
    public void onBindViewHolder(RecyclerView.ViewHolder mainholder, final int position) {

        if (mainholder instanceof MockTestListViewHolder) {
            MockTestListViewHolder holder = (MockTestListViewHolder) mainholder;
            int finalPosition = position;
            if (descriptionText != null) {
                finalPosition = position - 1;
            }
            holder.titleView.setText(mockTestModelList.get(finalPosition).get(1));
            if ("AV".equalsIgnoreCase(mockTestModelList.get(finalPosition).get(0))) {
                holder.imageView.setImageResource(R.drawable.icon_av);
                holder.imageView.setBackgroundColor(context.getResources().getColor(R.color.primary_color_dark));
                holder.testScore.setTextColor(context.getResources().getColor(R.color.view_hide_color));
                holder.testQuestions.setTextColor(context.getResources().getColor(R.color.view_hide_color));
                holder.testTime.setTextColor(context.getResources().getColor(R.color.view_hide_color));
                holder.testScore.setCompoundDrawablesWithIntrinsicBounds(R.drawable.ic_graph_light, 0, 0, 0);
                holder.testQuestions.setCompoundDrawablesWithIntrinsicBounds(R.drawable.ic_chat_light, 0, 0, 0);
                holder.testTime.setCompoundDrawablesWithIntrinsicBounds(R.drawable.ic_clock_light, 0, 0, 0);
                holder.testScore.setVisibility(View.VISIBLE);
                holder.testScore.setText(mockTestModelList.get(finalPosition).get(2));
                holder.testQuestions.setVisibility(View.VISIBLE);
                holder.wrong.setVisibility(View.INVISIBLE);
                holder.testTime.setVisibility(View.VISIBLE);
                holder.testTime.setText(mockTestModelList.get(finalPosition).get(4));
                holder.testQuestions.setText(mockTestModelList.get(finalPosition).get(3));
                holder.mock_test_right_layout.setVisibility(View.VISIBLE);
                holder.mock_test_reward_layout.setVisibility(View.VISIBLE);
            } else if ("UP".equalsIgnoreCase(mockTestModelList.get(finalPosition).get(0))) {
                holder.imageView.setImageResource(R.drawable.icon_up);
                holder.imageView.setBackgroundColor(context.getResources().getColor(R.color.lock_red));
                holder.testScore.setVisibility(View.GONE);
                holder.wrong.setVisibility(View.GONE);
                holder.testQuestions.setVisibility(View.GONE);
                holder.testTime.setVisibility(View.GONE);
                holder.mock_test_right_layout.setVisibility(View.VISIBLE);
                holder.mock_test_reward_layout.setVisibility(View.VISIBLE);
            } else if ("CO".equalsIgnoreCase(mockTestModelList.get(finalPosition).get(0))) {
                holder.imageView.setImageResource(R.drawable.icon_co);
                holder.imageView.setBackgroundColor(context.getResources().getColor(R.color.co_green));
                holder.testScore.setTextColor(context.getResources().getColor(R.color.colorTextPrimary));
                holder.testQuestions.setTextColor(context.getResources().getColor(R.color.colorTextPrimary));
                holder.wrong.setTextColor(context.getResources().getColor(R.color.red));
                holder.testTime.setTextColor(context.getResources().getColor(R.color.colorTextPrimary));
                holder.testScore.setCompoundDrawablesWithIntrinsicBounds(R.drawable.ic_graph_dark, 0, 0, 0);
                holder.testQuestions.setCompoundDrawablesWithIntrinsicBounds(R.drawable.ic_chat_dark, 0, 0, 0);
                holder.testTime.setCompoundDrawablesWithIntrinsicBounds(R.drawable.ic_acc, 0, 0, 0);
                holder.testScore.setVisibility(View.VISIBLE);
                holder.testScore.setText(mockTestModelList.get(finalPosition).get(2));
                holder.testQuestions.setVisibility(View.VISIBLE);
                holder.wrong.setText(mockTestModelList.get(finalPosition).get(4));
                holder.wrong.setVisibility(View.VISIBLE);
                holder.testTime.setVisibility(View.VISIBLE);
                holder.testTime.setText(mockTestModelList.get(finalPosition).get(5));
                holder.testQuestions.setText(mockTestModelList.get(finalPosition).get(3) + "/");
                holder.mock_test_right_layout.setVisibility(View.VISIBLE);
                holder.mock_test_reward_layout.setVisibility(View.VISIBLE);
            } else if ("CS".equalsIgnoreCase(mockTestModelList.get(finalPosition).get(0))) {
                holder.imageView.setImageResource(R.drawable.icon_cs);
                holder.imageView.setBackgroundColor(context.getResources().getColor(R.color.windowBackground));
                holder.testScore.setCompoundDrawablesWithIntrinsicBounds(0, 0, 0, 0);
                holder.testScore.setTextColor(context.getResources().getColor(R.color.view_hide_color));
                holder.testScore.setVisibility(View.VISIBLE);
                holder.testScore.setText(mockTestModelList.get(finalPosition).get(2));
                holder.testQuestions.setVisibility(View.INVISIBLE);
                holder.wrong.setVisibility(View.INVISIBLE);
                holder.testTime.setVisibility(View.INVISIBLE);
                holder.mock_test_right_layout.setVisibility(View.GONE);
                holder.mock_test_reward_layout.setVisibility(View.GONE);
            }

        } else if (mainholder instanceof MockDescHeaderViewHolder) {
            MockDescHeaderViewHolder holder = (MockDescHeaderViewHolder) mainholder;
//            holder.titleView.setText(descriptionText);
//            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.N) {
//                holder.titleView.setText(Html.fromHtml(descriptionText, Html.FROM_HTML_MODE_LEGACY));
//
//            } else {
                holder.titleView.setText(descriptionText);

//            }

        }
    }

    @Override
    public int getItemCount() {
        if (descriptionText != null) {
            return mockTestModelList.size() + 1;

        } else {
            return mockTestModelList.size();
        }
    }

    @Override
    public int getItemViewType(int position) {
        if (descriptionText != null && position == 0) {
            return TYPE_HEADER;
        } else {
            return TYPE_DATA;
        }
    }

    public void onMockDescripionChange(String mockDescriptionText) {
//        this.descriptionText=mockDescriptionText;
        this.descriptionText=mockDescriptionText.replaceAll("\n", "\n\n");

    }
}
