package in.oliveboard.sdk.ui;


import android.app.Activity;
import android.content.Intent;
import android.graphics.Color;
import android.os.Bundle;
import android.support.design.widget.FloatingActionButton;
import android.support.v4.content.ContextCompat;
import android.support.v7.widget.SwitchCompat;
import android.support.v7.widget.Toolbar;
import android.view.MenuItem;
import android.view.View;
import android.widget.Button;
import android.widget.CompoundButton;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import android.widget.Toast;

import com.google.gson.Gson;
import com.squareup.otto.Subscribe;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;


import in.oliveboard.sdk.R;
import in.oliveboard.sdk.databases.OliveBoardDb;
import in.oliveboard.sdk.log.DebugMonitor;
import in.oliveboard.sdk.presenter.TestPresenter;
import in.oliveboard.sdk.presenter.interfaces.CommonContract;
import in.oliveboard.sdk.presenter.model.CacheTestInfo;
import in.oliveboard.sdk.presenter.model.ChangeLanguage;
import in.oliveboard.sdk.presenter.model.ClearTest;
import in.oliveboard.sdk.presenter.model.CloseFilter;
import in.oliveboard.sdk.presenter.model.FilterModel;
import in.oliveboard.sdk.presenter.model.PauseSubmitResponse;
import in.oliveboard.sdk.presenter.model.PauseTestData;
import in.oliveboard.sdk.presenter.model.PauseTestInfo;
import in.oliveboard.sdk.presenter.model.SectionKeyValue;
import in.oliveboard.sdk.presenter.model.SessionInfo;
import in.oliveboard.sdk.presenter.model.SubmitTestInfo;
import in.oliveboard.sdk.presenter.model.TestAppModel;
import in.oliveboard.sdk.presenter.model.TestResponseModel;
import in.oliveboard.sdk.presenter.model.TestStatusEventModel;
import in.oliveboard.sdk.presenter.model.TestSubmitResponse;
import in.oliveboard.sdk.timer.Counter;
import in.oliveboard.sdk.timer.OliveBoardTestTimer;
import in.oliveboard.sdk.timer.TimerStatus;
import in.oliveboard.sdk.timer.listener.TimerListener;
import in.oliveboard.sdk.ui.base.BaseActivity;
import in.oliveboard.sdk.ui.fragments.TestModuleViewPagerFragment;
import in.oliveboard.sdk.utils.BasicConfig;
import in.oliveboard.sdk.utils.Constants;
import in.oliveboard.sdk.utils.DialogUtils;
import in.oliveboard.sdk.utils.FilterQuestions;
import in.oliveboard.sdk.utils.LargeAppInfo;
import in.oliveboard.sdk.utils.MainEventBus;
import in.oliveboard.sdk.utils.SubmitDialogCalled;
import in.oliveboard.sdk.utils.TestDataChangeListener;
import in.oliveboard.sdk.utils.onDialogUtilCalled;

public class TestModuleActivity extends BaseActivity implements CommonContract.View, onDialogUtilCalled, TimerListener, TestDataChangeListener,View.OnClickListener {
    ImageView pauseFab;
    RelativeLayout typeRelative;
    LinearLayout typeBottom;
    FloatingActionButton filterFab;
    LinearLayout timerLayout;
    TextView timerTextView;
    Toolbar toolbar;
    View quickActionLineView;
    TextView examNameToolbarTextView;
    TextView typeTextView;
    ImageView im;
    SwitchCompat languageSwitch;
    TextView hindiTextView;
    TextView englishTextView;
    LinearLayout languageSwitchLayout;
    Button nextButton;
    Button submitButton;
    //    public static final int DIALOG_REQ_CODE = 1001;
    public static final int FILTER_TYPE = 1002;

    boolean testStartPermissionEnabled = false;
    ArrayList<TestAppModel> questionAnswerInfo = new ArrayList<>();
    ArrayList<TestAppModel> filterQuestionArrayList = new ArrayList<>();
//    LinkedHashMap<String, ArrayList<String>> panesList=new LinkedHashMap<>();

    int selectedOption = 0;
    //    int selectedFilterType = Constants.TYPE_ALL;
    ArrayList<String> sessionTimeList = new ArrayList<>();
    ArrayList<SessionInfo> filterSessionTime = new ArrayList<>();
    boolean canStopTimer = true;
    TreeMap<Integer, SectionKeyValue> questionSet = new TreeMap<>();
    boolean isTestStarted = false;
    String submitUrl = null;
    String solutionUrl = null;
    String qpi = null;
    String ppi = null;
    String pauseUrl;
    int questionPosition = 0;
    boolean isForcePaused = false;
    boolean exitApp = false;
    boolean backPressExit = false;
    boolean selfStopTimershown = false;
    TestPresenter presenter = new TestPresenter();

    @Override
    protected void initializeDagger() {
        //App app = (App) getApplicationContext();


    }

    @Override
    protected void savedInstance(Bundle savedInstanceState) {

        timerTextView = findViewById(R.id.timer_text_view);
        toolbar = findViewById(R.id.toolbar);
        quickActionLineView = findViewById(R.id.fine_line_view);
        examNameToolbarTextView = (TextView) findViewById(R.id.test_txt);
        typeTextView = findViewById(R.id.type_text_view);
        im = findViewById(R.id.section);
        languageSwitch = findViewById(R.id.switch_language);
        hindiTextView = findViewById(R.id.hindi_txt);
        englishTextView = findViewById(R.id.english_txt);
        languageSwitchLayout = findViewById(R.id.language_switch_layout);
        nextButton = findViewById(R.id.next_btn);
        submitButton = findViewById(R.id.submit_btn);
        pauseFab = findViewById(R.id.pause_icon);
        typeRelative = findViewById(R.id.type_relative);
        typeBottom = findViewById(R.id.type_bottam);
        filterFab = findViewById(R.id.filter_fab);
        timerLayout = findViewById(R.id.timer_submit_layout);


        typeTextView.setOnClickListener(this);
        typeRelative.setOnClickListener(this);
        typeBottom.setOnClickListener(this);
        im.setOnClickListener(this);
        filterFab.setOnClickListener(this);
        timerLayout.setOnClickListener(this);
        submitButton.setOnClickListener(this);
        nextButton.setOnClickListener(this);

        if (savedInstanceState != null&&savedInstanceState.containsKey("id")&&savedInstanceState.getString("id")!=null) {

            CacheTestInfo dataValue = OliveBoardDb.getInstance(getApplicationContext()).getTestInfo(savedInstanceState.getString("id"));
            OliveBoardDb.getInstance(getApplicationContext()).close();

            if (dataValue != null) {

                LargeAppInfo.getInstance().setCanEndSession(true);
                LargeAppInfo.getInstance().setQuestionAnswerInfo(dataValue.getQuestionInfo());
                LargeAppInfo.getInstance().setQuestionSet(dataValue.getQuestionSet());
                LargeAppInfo.getInstance().setPanesList(dataValue.getPanes());

                filterSessionTime = dataValue.getFilterSessionArrayList();

                DebugMonitor.getLogger().d("init", "yez-------dataValue !");

                OliveBoardTestTimer.getInstance().init(timerTextView, new Counter.CounterBuilder(Long.parseLong(dataValue.getTimeleft())).build(), this).setTime();
                submitUrl = dataValue.getSubmitUrl();
                solutionUrl = dataValue.getSolutionUrl();
                qpi = dataValue.getQpi();
                ppi = dataValue.getPpi();
                pauseUrl = dataValue.getPauseUrl();
                try {

                    OliveBoardTestTimer.getInstance().startTimer(false);
                    DebugMonitor.getLogger().d("init", "yez-------After dataValue !");
                    testStartPermissionEnabled = true;
                    isTestStarted = true;

                } catch (IOException e) {
                    e.printStackTrace();
                }
                LargeAppInfo.getInstance().setLanguageType(dataValue.getLanguage());

                if (LargeAppInfo.getInstance().getLanguageType() == 1) {

                    languageSwitch.setChecked(true);
                }

                sessionTimeList.add(savedInstanceState.getString("last_time"));

            }

            examNameToolbarTextView.setText(savedInstanceState.getString("id"));


        } else {

            if (LargeAppInfo.getInstance().getQuestionInfo()!=null&& LargeAppInfo.getInstance().getQuestionInfo().pauseData != null) {

                if (LargeAppInfo.getInstance().getQuestionInfo().pauseData.tdata.containsKey("0")) {
                    filterSessionTime = LargeAppInfo.getInstance().getQuestionInfo().pauseData.tdata.get("0").getSessionInfo();
                }

            }
        }


        TestResponseModel testInfo = LargeAppInfo.getInstance().getQuestionInfo();
        questionAnswerInfo =LargeAppInfo.getInstance().getQuestionAnswerInfo();
        if (testInfo != null) {

            LargeAppInfo.getInstance().switchToPauseQuestion(testInfo.switchToQuestion);

        }

        LargeAppInfo.getInstance().setExamRunning(true);
        if (questionAnswerInfo != null) {
            if (testInfo != null) {

                LargeAppInfo.getInstance().setPanesList(testInfo.panes);
                examNameToolbarTextView.setText(testInfo.questionId);
                LargeAppInfo.getInstance().setCanEndSession(false);
                submitUrl = testInfo.submitUrl;
                solutionUrl = testInfo.solutionUrl;
                pauseUrl = testInfo.pauseUrl;
//                Log.d("ppppppp",testInfo.pauseUrl+">>>>>>>");
                qpi = testInfo.questionQpi;
                ppi = testInfo.partId;
                DebugMonitor.getLogger().d("ppi>>>>", ppi + ">>>");
                if (getIntent().getExtras() != null && !(getIntent().getExtras().containsKey(Constants.PART_TEST))) {

                    DebugMonitor.getLogger().d("init", "yez-------testInfo !");

                    OliveBoardTestTimer.getInstance().init(timerTextView, new Counter.CounterBuilder(testInfo.settings.totalTime).build(), this).setTime();

                    DialogUtils.getInstance().startTestDialog(TestModuleActivity.this, testInfo, this, (testInfo.pauseData != null) ? true : false);

                } else if (getIntent().getExtras() != null && getIntent().getExtras().containsKey(Constants.PART_TEST)) {

                    sessionTimeList.add(FilterQuestions.getInstance().getDurationString(LargeAppInfo.getInstance().getQuestionInfo().settings.totalTime));


                    DebugMonitor.getLogger().d("init", "yez-------else if !");
                    OliveBoardTestTimer.getInstance().init(timerTextView, new Counter.CounterBuilder(testInfo.settings.totalTime).build(), this).setTime();

                    try {
                        OliveBoardTestTimer.getInstance().startTimer(false);
                        isTestStarted = true;
                        DebugMonitor.getLogger().d("init", "yez-------After section iguess !");
                        testStartPermissionEnabled = true;
                    } catch (IOException e) {
                        e.printStackTrace();
                    }

                }


            }

            toolbar.setNavigationIcon(R.drawable.icon_toolbar); // just setNavigationIcon
            setSupportActionBar(toolbar);
            getSupportActionBar().setDisplayHomeAsUpEnabled(true);

            if (questionAnswerInfo != null && questionAnswerInfo.size() > 0) {

                if (LargeAppInfo.getInstance().getQuestionSet() != null) {

                    questionSet.putAll(LargeAppInfo.getInstance().getQuestionSet());

                }


                filterQuestionArrayList.addAll(questionAnswerInfo);

                LargeAppInfo.getInstance().setCurrentQuestionInfo(filterQuestionArrayList);

                setFragment(0);


            }


            typeTextView.setText(questionSet.get(selectedOption).getKey());

            languageSwitch.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener() {
                @Override
                public void onCheckedChanged(CompoundButton compoundButton, boolean b) {
                    if (b) {
                        LargeAppInfo.getInstance().setLanguageType(1);

                        englishTextView.setTextColor(ContextCompat.getColor(getApplicationContext(), R.color.light_grey));
                        hindiTextView.setTextColor(Color.BLACK);
                        MainEventBus.getInstance().post(new ChangeLanguage(1));
                    } else {
                        LargeAppInfo.getInstance().setLanguageType(0);

                        englishTextView.setTextColor(Color.BLACK);
                        hindiTextView.setTextColor(ContextCompat.getColor(getApplicationContext(), R.color.light_grey));
                        MainEventBus.getInstance().post(new ChangeLanguage(0));

                    }
                }
            });
            if (solutionUrl != null && solutionUrl.equals("0")) {
                nextButton.setVisibility(View.VISIBLE);
                submitButton.setVisibility(View.GONE);
            } else {
                submitButton.setVisibility(View.VISIBLE);
                nextButton.setVisibility(View.GONE);
            }
         //   LogEvents.getInstance().passEvents(getApplicationContext(), "TestAppScreen", "view_page");
            if(examNameToolbarTextView!=null) {
            //    LogEvents.getInstance().passEvents(getApplicationContext(), "TestScreen", ""+examNameToolbarTextView.getText().toString());
            }
        } else {
            LargeAppInfo.getInstance().setExamRunning(false);
            finish();
        }
        if (pauseUrl != null && pauseUrl.length() > 2) {
            pauseFab.setVisibility(View.VISIBLE);
        } else {
            pauseFab.setVisibility(View.GONE);

        }
        pauseFab.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                isForcePaused = true;
                if (testStartPermissionEnabled && canStopTimer) {
                    canStopTimer = false;
                    OliveBoardTestTimer.getInstance().pause();
                }
                DialogUtils.getInstance().pauseOrResumeTest(TestModuleActivity.this, TestModuleActivity.this, "Pause Test ?", "Are you sure you want to pause your test ?", "OK", "Cancel");
            }
        });
    }

    @Override
    protected void initializePresenter() {
        super.presenter = presenter;
        presenter.setView(this);
        try {
            MainEventBus.getInstance().register(this);
        } catch (Exception e) {

        }
    }


    @Override
    public int getLayoutId() {
        return R.layout.activity_test_infinate;
    }


    @Override
    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == FILTER_TYPE) {
            if (!canStopTimer) {
                if (sessionTimeList.size() > 0) {
                    sessionTimeList.add(timerTextView.getText().toString());
                    filterSessionTime.add(new SessionInfo(sessionTimeList));
                }
                canStopTimer = true;
                sessionTimeList.clear();
                sessionTimeList.add(timerTextView.getText().toString());
            }
            if (resultCode == Activity.RESULT_OK) {
               // LogEvents.getInstance().passEvents(getApplicationContext(), "TestAppFilterScreen", "view_page", "filter_btn");

                if (data.getIntExtra(Constants.FILTER_TYPE, 0) == Constants.TYPE_ALL) {
//                    if (selectedFilterType != Constants.TYPE_ALL) {
                    selectedOption = 0;
//                    selectedFilterType = Constants.TYPE_ALL;
                    filterQuestionArrayList.clear();
                    filterQuestionArrayList.addAll(questionAnswerInfo);
                    questionSet.clear();
                    questionSet.putAll(LargeAppInfo.getInstance().getQuestionSet());
                    LargeAppInfo.getInstance().setCurrentQuestionInfo(filterQuestionArrayList);
                    setFragment(data.getIntExtra(Constants.FILTER_POSITION, 0));

                } else if (data.getIntExtra(Constants.FILTER_TYPE, 0) == Constants.TYPE_FAV) {


                    selectedOption = 0;
//                        ArrayList<FilterModel> dataFromFilter = FilterQuestions.getInstance().filter(questionAnswerInfo, Constants.TYPE_FAV);
                    ArrayList<FilterModel> dataFromFilter = null;
                    if (LargeAppInfo.getInstance().getSolutionfilter(Constants.TYPE_FAV) == null) {
                        dataFromFilter = FilterQuestions.getInstance().filter(questionAnswerInfo, Constants.TYPE_FAV);
                    } else {

                        dataFromFilter = LargeAppInfo.getInstance().getSolutionfilter(Constants.TYPE_FAV);

                    }
                    filterQuestionArrayList.clear();
                    questionSet.clear();
                    questionSet.putAll(dataFromFilter.get(0).getSortOrder());
                    filterQuestionArrayList.addAll(dataFromFilter.get(0).getFilterArrayList());

                    LargeAppInfo.getInstance().setCurrentQuestionInfo(filterQuestionArrayList);
                    setFragment(data.getIntExtra(Constants.FILTER_POSITION, 0));

                } else if (data.getIntExtra(Constants.FILTER_TYPE, 0) == Constants.TYPE_ATTEMPTED) {

                    selectedOption = 0;

                    ArrayList<FilterModel> dataFromFilter = null;
                    if (LargeAppInfo.getInstance().getSolutionfilter(Constants.TYPE_ATTEMPTED) == null) {
                        dataFromFilter = FilterQuestions.getInstance().filter(questionAnswerInfo, Constants.TYPE_ATTEMPTED);
                    } else {

                        dataFromFilter = LargeAppInfo.getInstance().getSolutionfilter(Constants.TYPE_ATTEMPTED);

                    }


                    filterQuestionArrayList.clear();
                    questionSet.clear();
                    questionSet.putAll(dataFromFilter.get(0).getSortOrder());

                    filterQuestionArrayList.addAll(dataFromFilter.get(0).getFilterArrayList());

                    LargeAppInfo.getInstance().setCurrentQuestionInfo(filterQuestionArrayList);
                    setFragment(data.getIntExtra(Constants.FILTER_POSITION, 0));


                } else if (data.getIntExtra(Constants.FILTER_TYPE, 0) == Constants.TYPE_UNATTEMPTED) {

                    selectedOption = 0;

                    ArrayList<FilterModel> dataFromFilter = null;
                    if (LargeAppInfo.getInstance().getSolutionfilter(Constants.TYPE_UNATTEMPTED) == null) {
                        dataFromFilter = FilterQuestions.getInstance().filter(questionAnswerInfo, Constants.TYPE_UNATTEMPTED);
                    } else {
                        dataFromFilter = LargeAppInfo.getInstance().getSolutionfilter(Constants.TYPE_UNATTEMPTED);

                    }

                    filterQuestionArrayList.clear();
                    questionSet.clear();
                    questionSet.putAll(dataFromFilter.get(0).getSortOrder());
                    filterQuestionArrayList.addAll(dataFromFilter.get(0).getFilterArrayList());
                    LargeAppInfo.getInstance().setCurrentQuestionInfo(filterQuestionArrayList);
                    setFragment(data.getIntExtra(Constants.FILTER_POSITION, 0));

                }

            }
        }
    }

    @Override
    public void onTimerChanged(TimerStatus status) {

        if (status == TimerStatus.TIME_ENDING) {
            timerTextView.setTextColor(Color.RED);
        } else if (status == TimerStatus.FINISHED) {
            if (!selfStopTimershown) {
                if (!canStopTimer) {
                    MainEventBus.getInstance().post(new CloseFilter());
                } else {
                    MainEventBus.getInstance().post(new SubmitDialogCalled());
                }
//            DialogUtils.getInstance().selfStopDialog(TestModuleActivity.this, this);
                selfStopTimershown = true;
                if (solutionUrl != null && solutionUrl.equals("0")) {
                    DialogUtils.getInstance().selfStopDialog(TestModuleActivity.this, this, true);
                } else {
                    DialogUtils.getInstance().selfStopDialog(TestModuleActivity.this, this, false);

                }
                HashMap<String, SubmitTestInfo> data = FilterQuestions.getInstance().getSummeryInfo(questionAnswerInfo).get(0).getSubmitMap();
                data.put("0", new SubmitTestInfo("0", "", filterSessionTime));
                Map<String, String> params = new HashMap<String, String>();
                params.put("data", new Gson().toJson(data));
                params.put("qpi", qpi);
                if (ppi != null) {
                    params.put("ppi", ppi);
                }

                try {
                    OliveBoardTestTimer.getInstance().finish();
                } catch (Exception e) {

                }
                presenter.callSubmitTest(submitUrl, params,TestModuleActivity.this);

            }
        }

    }

    @Override
    public void onLiveTimeRunning(String time) {

    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        LargeAppInfo.getInstance().setExamRunning(false);

//        OliveBoardTestTimer.getInstance().finish();
        if (presenter != null) {
            presenter.unSubscribe();
        }
        try {
            MainEventBus.getInstance().unregister(this);
        } catch (Exception e) {

        }
    }

    @Override
    protected void onPause() {
        super.onPause();
        if (testStartPermissionEnabled && canStopTimer) {
            if (!isForcePaused)
                OliveBoardTestTimer.getInstance().pause();
        }
    }


    @Override
    protected void onResume() {
        super.onResume();

        if (testStartPermissionEnabled && canStopTimer) {
            if (!isForcePaused)
                OliveBoardTestTimer.getInstance().resume();
        }
    }

    @Override
    public void onChangeFavorite(int position, boolean isFav) {
        try {
            if (position >= 0 && questionAnswerInfo != null && (position < questionAnswerInfo.size())) {

                questionAnswerInfo.get(position).setMarked(isFav);
            }
        } catch (Exception e) {

        }

    }

    @Override
    public void onChangeOptionSelection(int position, int selectedPosition) {
        try {

            if (position >= 0 && questionAnswerInfo != null && (position < questionAnswerInfo.size())) {

                questionAnswerInfo.get(position).setSelectionOption(selectedPosition);

                if (selectedPosition != -1) {

                    ((TestModuleViewPagerFragment)
                            getSupportFragmentManager().findFragmentByTag(Constants.FRAGMENT_TAG)).nextQuestion((position + 1));
                }

            }
        } catch (Exception e) {

        }


    }

    @Override
    public void onSessionReading(int position, String key) {
        try {
            if (position >= 0 && questionAnswerInfo != null && (position < questionAnswerInfo.size())) {

                questionPosition = position;
                sessionTimeList.add(timerTextView.getText().toString());
                if (sessionTimeList.size() == 1) {
                    sessionTimeList.add(timerTextView.getText().toString());

                }
                questionAnswerInfo.get(position).setSessionData(sessionTimeList);
//                Log.d("total", key + "  " + position + ">>>>> size offfffff" + questionAnswerInfo.get(position).getAllSessionData().size());
//                Gson gson = new Gson();
//                String json = gson.toJson(questionAnswerInfo.get(position).getAllSessionData());
//                Log.d("Structue", "Q "+(position+1)+">>>>> Structue" + json);
                String newStartTime = sessionTimeList.get(1);
                sessionTimeList.clear();
                sessionTimeList.add(newStartTime);


            }
        } catch (Exception e) {

        }


    }

    @Override
    public void onChangeQuestion(String key) {
        if (typeTextView != null && !(typeTextView.getText().toString().equals(key))) {
            typeTextView.setText(key);
            selectedOption = FilterQuestions.getInstance().getQuestionSection(questionSet, key);

        }
    }

    @Override
    public void onLangaugeSwitchChange(boolean isVisible) {
        if (isVisible) {
            if (languageSwitchLayout.getVisibility() == View.INVISIBLE) {
                languageSwitchLayout.setVisibility(View.VISIBLE);
            }
        } else {
            if (languageSwitchLayout.getVisibility() == View.VISIBLE) {
                languageSwitchLayout.setVisibility(View.INVISIBLE);
            }
        }
    }

    @Override
    public void onChangeExpandData(int position, boolean isExpanded) {
        try {
            if (position >= 0 && questionAnswerInfo != null && (position < questionAnswerInfo.size())) {

                questionAnswerInfo.get(position).setExpanded(isExpanded);

            }
        } catch (Exception e) {

        }
    }

    public void setFragment(int position) {

        getSupportFragmentManager()
                .beginTransaction()
                .replace(R.id.container, TestModuleViewPagerFragment.setInstance(position,false), Constants.FRAGMENT_TAG).commitAllowingStateLoss();

    }

    @Override
    public void onBackPressed() {

        DialogUtils.getInstance().exitDialog(TestModuleActivity.this, this);
    }

    @Override
    protected void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        if (isTestStarted) {
            if (timerTextView != null) {
                OliveBoardDb.getInstance(getApplicationContext()).insertTestInfo(LargeAppInfo.getInstance().getPanesList(), questionAnswerInfo, filterSessionTime, timerTextView.getText().toString(), (examNameToolbarTextView != null) ? examNameToolbarTextView.getText().toString() : "Test", LargeAppInfo.getInstance().getQuestionSet(), LargeAppInfo.getInstance().getLanguageType(), submitUrl, solutionUrl, qpi, pauseUrl, ppi);
                OliveBoardDb.getInstance(getApplicationContext()).close();
                if (examNameToolbarTextView != null) {
                    outState.putString("id", examNameToolbarTextView.getText().toString());
                } else {
                    outState.putString("id", "Test");

                }

                if (sessionTimeList.size() > 0 && sessionTimeList.get(0).length() > 0) {
                    outState.putString("last_time", sessionTimeList.get(0));
                } else {
                    outState.putString("last_time", timerTextView.getText().toString());
                }
            }
        }
    }

    @Override
    public void onOptionDialogSelected(int position) {
        if (selectedOption != position) {

            selectedOption = position;
            typeTextView.setText(questionSet.get(selectedOption).getKey());

        }
        ((TestModuleViewPagerFragment)
                getSupportFragmentManager().findFragmentByTag(Constants.FRAGMENT_TAG)).changePosition(questionSet.get(position).getPosition());

    }


    @Override
    public void onAutoDialogSelected() {

        HashMap<String, SubmitTestInfo> data = FilterQuestions.getInstance().getSummeryInfo(questionAnswerInfo).get(0).getSubmitMap();
        data.put("0", new SubmitTestInfo("0", "", filterSessionTime));

//        showProgressDialog(((App)getApplicationContext()).getLang().equals("hi")?getString(R.string.str_submit_test_hindi):getString(R.string.str_submit_test));
        showProgressDialog(getString(R.string.str_submit_test));


        Map<String, String> params = new HashMap<String, String>();
        params.put("data", new Gson().toJson(data));
        params.put("qpi", qpi);
        if (ppi != null) {
            params.put("ppi", ppi);
        }

        try {
            OliveBoardTestTimer.getInstance().finish();
        } catch (Exception e) {

        }
        presenter.callSubmitTest(submitUrl, params,TestModuleActivity.this);


    }

    @Override
    public void onSubmitDialogSelected() {
        MainEventBus.getInstance().post(new SubmitDialogCalled());

        LinkedHashMap<String, SubmitTestInfo> data = FilterQuestions.getInstance().getSummeryInfo(questionAnswerInfo).get(0).getSubmitMap();
        data.put("0", new SubmitTestInfo("0", "", filterSessionTime));


//        showProgressDialog(((App)getApplicationContext()).getLang().equals("hi")?getString(R.string.str_submit_test_hindi):getString(R.string.str_submit_test));
        showProgressDialog(getString(R.string.str_submit_test));

        Map<String, String> params = new HashMap<String, String>();
        params.put("data", new Gson().toJson(data));
        params.put("qpi", qpi);

        DebugMonitor.getLogger().d("data", new Gson().toJson(data));
        if (ppi != null) {
            params.put("ppi", ppi);
        }

        try {
            OliveBoardTestTimer.getInstance().finish();
        } catch (Exception e) {

        }
        presenter.callSubmitTest(submitUrl, params,TestModuleActivity.this);


    }

    @Override
    public void onExitApp() {

        if (pauseUrl != null) {
            backPressExit = true;
            exitApp = true;
//            showProgressDialog(((App)getApplicationContext()).getLang().equals("hi")?getString(R.string.str_saving_test_hindi):getString(R.string.str_saving_test));
            showProgressDialog(getString(R.string.str_saving_test));

            isForcePaused = true;
            if (testStartPermissionEnabled && canStopTimer) {
                OliveBoardTestTimer.getInstance().pause();
            }
            MainEventBus.getInstance().post(new SubmitDialogCalled());

            HashMap<String, PauseTestInfo> data = FilterQuestions.getInstance().getPauseTestInfo(questionAnswerInfo);
            data.put("0", new PauseTestInfo("0", "", filterSessionTime, ""));
            try {
                OliveBoardTestTimer.getInstance().finishOnPause();
            } catch (Exception e) {

            }
            if (questionPosition >= 0 && (questionPosition < questionAnswerInfo.size())) {
                presenter.callPauseTest(pauseUrl, new PauseTestData(data, BasicConfig.getInstance().timeLeft(timerTextView.getText().toString()), questionAnswerInfo.get(questionPosition).getQuestionId()), qpi, "0", ppi,TestModuleActivity.this);
            } else {
                if (questionAnswerInfo != null && questionAnswerInfo.size() > 0) {
                    presenter.callPauseTest(pauseUrl, new PauseTestData(data, BasicConfig.getInstance().timeLeft(timerTextView.getText().toString()), questionAnswerInfo.get(0).getQuestionId()), qpi, "0", ppi,TestModuleActivity.this);

                } else {
                    hideProgressDialog();
                }
            }


        } else {
            try {
                OliveBoardTestTimer.getInstance().finish();
            } catch (Exception e) {

            }

            LargeAppInfo.getInstance().clearAllData();
            LargeAppInfo.getInstance().setExamRunning(false);
            finish();
        }

    }

    @Override
    public void onExitWithoutPause() {
        try {
            OliveBoardTestTimer.getInstance().finish();
        } catch (Exception e) {

        }
        LargeAppInfo.getInstance().clearAllData();
        LargeAppInfo.getInstance().setExamRunning(false);
        finish();
    }

    @Override
    public void onTryAgain() {
        LinkedHashMap<String, SubmitTestInfo> data = FilterQuestions.getInstance().getSummeryInfo(questionAnswerInfo).get(0).getSubmitMap();
        data.put("0", new SubmitTestInfo("0", "", filterSessionTime));
//        showProgressDialog(((App)getApplicationContext()).getLang().equals("hi")?getString(R.string.str_submit_test_hindi):getString(R.string.str_submit_test));
        showProgressDialog(getString(R.string.str_submit_test));

        Map<String, String> params = new HashMap<String, String>();
        params.put("data", new Gson().toJson(data));
        params.put("qpi", qpi);
        if (ppi != null) {
            params.put("ppi", ppi);
        }
        presenter.callSubmitTest(submitUrl, params,TestModuleActivity.this);
    }

    @Override
    public void onPauseTest(boolean value) {

        if (value) {
//            showProgressDialog(((App)getApplicationContext()).getLang().equals("hi")?getString(R.string.str_pause_message_hindi):getString(R.string.str_pause_message));
            showProgressDialog(getString(R.string.str_pause_message));

            isForcePaused = true;
            if (testStartPermissionEnabled && canStopTimer) {
                canStopTimer = false;
                OliveBoardTestTimer.getInstance().pause();
            }

            MainEventBus.getInstance().post(new SubmitDialogCalled());


            HashMap<String, PauseTestInfo> data = FilterQuestions.getInstance().getPauseTestInfo(questionAnswerInfo);
            data.put("0", new PauseTestInfo("0", "", filterSessionTime, ""));

            try {
                OliveBoardTestTimer.getInstance().finishOnPause();
            } catch (Exception e) {

            }
            if (questionPosition >= 0 && (questionPosition < questionAnswerInfo.size())) {

                presenter.callPauseTest(pauseUrl, new PauseTestData(data, BasicConfig.getInstance().timeLeft(timerTextView.getText().toString()), questionAnswerInfo.get(questionPosition).getQuestionId()), qpi, "0", ppi,TestModuleActivity.this);
            } else {
                if (questionAnswerInfo != null && questionAnswerInfo.size() > 0) {

                    presenter.callPauseTest(pauseUrl, new PauseTestData(data, BasicConfig.getInstance().timeLeft(timerTextView.getText().toString()), questionAnswerInfo.get(0).getQuestionId()), qpi, "0", ppi,TestModuleActivity.this);

                } else {

                    hideProgressDialog();
                }
            }

        } else {
            isForcePaused = false;
            canStopTimer = true;
            if (testStartPermissionEnabled && canStopTimer) {
                OliveBoardTestTimer.getInstance().resume();
            }
        }

    }


    @Override
    public void startTest(boolean value) {
        if (value) {
            if (!testStartPermissionEnabled) {
                try {
                    testStartPermissionEnabled = true;
                    OliveBoardTestTimer.getInstance().startTimer(false);
                    LargeAppInfo.getInstance().setCanEndSession(true);
                    sessionTimeList.clear();
                    if(LargeAppInfo.getInstance().getQuestionInfo()!=null&& LargeAppInfo.getInstance().getQuestionInfo().settings!=null)
                    {
                        sessionTimeList.add(FilterQuestions.getInstance().getDurationString(LargeAppInfo.getInstance().getQuestionInfo().settings.totalTime));
                    }
//                    sessionTimeList.add(FilterQuestions.getInstance().getDurationString(((App) getApplicationContext()).getQuestionInfo().settings.totalTime));
                    isTestStarted = true;
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
        } else {
            try {
                OliveBoardTestTimer.getInstance().finish();
            } catch (Exception e) {

            }
            LargeAppInfo.getInstance().clearAllData();
            LargeAppInfo.getInstance().setExamRunning(false);
            finish();
        }
    }

    @Override
    public void retyPermission() {

    }

    @Override
    public void gotoPurchase() {
    }

    @Override
    public void noPhoneAction() {

    }

    @Override
    public void openPermissionSetting() {

    }


    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        switch (item.getItemId()) {
            // Respond to the action bar's Up/Home button
            case android.R.id.home:

                DialogUtils.getInstance().exitDialog(TestModuleActivity.this, this);

                return true;

        }

        return super.onOptionsItemSelected(item);
    }

    @Override
    public void onSuccess(Object responseModel) {
        hideProgressDialog();
        if (responseModel == "test_submit_response") {

            if (solutionUrl.equals("0")) {
                try {
                    DialogUtils.getInstance().closeSelfDialog();
                } catch (Exception e) {

                }
                if (getIntent().getExtras()!=null&&getIntent().getExtras().getBoolean(Constants.IS_MOCK)) {

                    MainEventBus.getInstance().post(new TestStatusEventModel(false));

                } else {

                    MainEventBus.getInstance().post(new TestStatusEventModel(true));

                }
                startActivity(new Intent(getApplicationContext(), TestSectionActivity.class).putExtra(Constants.BASE_BUNDLE_EXAM_NAME, getIntent().getExtras().getString(Constants.BASE_BUNDLE_EXAM_NAME)).putExtra(Constants.BASE_BUNDLE_URL, getIntent().getExtras().getString(Constants.BASE_BUNDLE_URL)).putExtra(Constants.BUNDLE_KEY_EXAM_URL, getIntent().getExtras().getBoolean(Constants.IS_MOCK)));
                LargeAppInfo.getInstance().setExamRunning(false);
                finish();
            } else {

                try {
                    DialogUtils.getInstance().closeSelfDialog();
                } catch (Exception e) {

                }


                if (getIntent().getExtras().containsKey(Constants.BUNDLE_SHOULD_CHANGE)) {
                    if (getIntent().getExtras().getString(Constants.BASE_BUNDLE_EXAM_NAME).length() > 0) {

                        startActivity(new Intent(TestModuleActivity.this, SummeryActivity.class).putExtra(Constants.BUNDLE_SUMMERY_URL, solutionUrl).putExtra("exam_name", getIntent().getExtras().getString(Constants.BASE_BUNDLE_EXAM_NAME)).putExtra("from_test", "from_test"));
                    } else {
                        startActivity(new Intent(TestModuleActivity.this, SummeryActivity.class).putExtra(Constants.BUNDLE_SUMMERY_URL, solutionUrl).putExtra("exam_name", examNameToolbarTextView.getText().toString()).putExtra("from_test", "from_test"));

                    }
                } else {

                    startActivity(new Intent(TestModuleActivity.this, SummeryActivity.class).putExtra(Constants.BUNDLE_SUMMERY_URL, solutionUrl).putExtra("exam_name", examNameToolbarTextView.getText().toString()).putExtra("from_test", "from_test"));

                }
                if (getIntent().getExtras().getBoolean(Constants.IS_MOCK)) {

                    MainEventBus.getInstance().post(new TestStatusEventModel(false));

                } else {

                    MainEventBus.getInstance().post(new TestStatusEventModel(true));

                }
                try {
                    LargeAppInfo.getInstance().clearAllData();
                } catch (Exception e) {

                }
                LargeAppInfo.getInstance().setExamRunning(false);
                finish();
            }
        } else if (responseModel == "test_pause_response") {
            try {
                LargeAppInfo.getInstance().clearAllData();
            } catch (Exception e) {

            }
            LargeAppInfo.getInstance().setExamRunning(false);

            finish();

        }

    }

    @Override
    public void onFailed() {
        hideProgressDialog();
        if (!isForcePaused) {
            DialogUtils.getInstance().tryAgainSubmit(TestModuleActivity.this, this);
        } else {

            Toast.makeText(getApplicationContext(), "Pausing test failed. Please try again...", Toast.LENGTH_SHORT).show();
            try {
                LargeAppInfo.getInstance().clearAllData();
            } catch (Exception e) {

            }
            LargeAppInfo.getInstance().setExamRunning(false);
            finish();


        }
    }

    @Override
    public void onSuccess(List responseModel) {

    }

    @Override
    public void onAuthFailed() {
        BasicConfig.getInstance().onAuthFailed(this);
    }

    @Override
    public void onSuccess(String response) {
        hideProgressDialog();
        if (response == "test_submit_response") {

            if (solutionUrl.equals("0")) {
                try {
                    DialogUtils.getInstance().closeSelfDialog();
                } catch (Exception e) {

                }
                if (getIntent().getExtras()!=null&&getIntent().getExtras().getBoolean(Constants.IS_MOCK)) {

                    MainEventBus.getInstance().post(new TestStatusEventModel(false));

                } else {

                    MainEventBus.getInstance().post(new TestStatusEventModel(true));

                }
                startActivity(new Intent(getApplicationContext(), TestSectionActivity.class).putExtra(Constants.BASE_BUNDLE_EXAM_NAME, getIntent().getExtras().getString(Constants.BASE_BUNDLE_EXAM_NAME)).putExtra(Constants.BASE_BUNDLE_URL, getIntent().getExtras().getString(Constants.BASE_BUNDLE_URL)).putExtra(Constants.BUNDLE_KEY_EXAM_URL, getIntent().getExtras().getBoolean(Constants.IS_MOCK)));
                LargeAppInfo.getInstance().setExamRunning(false);
                finish();
            } else {

                try {
                    DialogUtils.getInstance().closeSelfDialog();
                } catch (Exception e) {

                }


                if (getIntent().getExtras().containsKey(Constants.BUNDLE_SHOULD_CHANGE)) {
                    if (getIntent().getExtras().getString(Constants.BASE_BUNDLE_EXAM_NAME).length() > 0) {

                        startActivity(new Intent(TestModuleActivity.this, SummeryActivity.class).putExtra(Constants.BUNDLE_SUMMERY_URL, solutionUrl).putExtra("exam_name", getIntent().getExtras().getString(Constants.BASE_BUNDLE_EXAM_NAME)).putExtra("from_test", "from_test"));
                    } else {
                        startActivity(new Intent(TestModuleActivity.this, SummeryActivity.class).putExtra(Constants.BUNDLE_SUMMERY_URL, solutionUrl).putExtra("exam_name", examNameToolbarTextView.getText().toString()).putExtra("from_test", "from_test"));

                    }
                } else {

                    startActivity(new Intent(TestModuleActivity.this, SummeryActivity.class).putExtra(Constants.BUNDLE_SUMMERY_URL, solutionUrl).putExtra("exam_name", examNameToolbarTextView.getText().toString()).putExtra("from_test", "from_test"));

                }
                if (getIntent().getExtras().getBoolean(Constants.IS_MOCK)) {

                    MainEventBus.getInstance().post(new TestStatusEventModel(false));

                } else {

                    MainEventBus.getInstance().post(new TestStatusEventModel(true));

                }
                try {
                    LargeAppInfo.getInstance().clearAllData();
                } catch (Exception e) {

                }
                LargeAppInfo.getInstance().setExamRunning(false);
                finish();
            }
        } else if (response == "test_pause_response") {
            try {
                LargeAppInfo.getInstance().clearAllData();
            } catch (Exception e) {

            }
            LargeAppInfo.getInstance().setExamRunning(false);

            finish();

        }

    }

    @Override
    public void onSolutionDataCallback(TestResponseModel response, ArrayList restructuredModelList, boolean status, TreeMap questionSet, int correct, int wrong, String accurecy) {

    }

    @Override
    public void onTestDataCallback(TestResponseModel response, ArrayList restructuredModelList, boolean status, TreeMap questionSet) {

    }

    @Override
    public void onFailed(String message) {

    }
    @Subscribe
    public void onForceKill(ClearTest test)
    {
        try {
            OliveBoardTestTimer.getInstance().finish();
        } catch (Exception e) {

        }

        LargeAppInfo.getInstance().clearAllData();
        LargeAppInfo.getInstance().setExamRunning(false);
        finish();
    }


    @Override
    public void onClick(View view) {
        int i = view.getId();
        if (i == R.id.section) {
            if (questionSet.size() > 1) {
                DialogUtils.getInstance().displayPopupWindow(quickActionLineView, TestModuleActivity.this, questionSet, this, typeTextView.getText().toString());
            }

        } else if (i == R.id.type_bottam) {
            if (questionSet.size() > 1) {
                DialogUtils.getInstance().displayPopupWindow(quickActionLineView, TestModuleActivity.this, questionSet, this, typeTextView.getText().toString());
            }

        } else if (i == R.id.type_relative) {
            if (questionSet.size() > 1) {
                DialogUtils.getInstance().displayPopupWindow(quickActionLineView, TestModuleActivity.this, questionSet, this, typeTextView.getText().toString());
            }

        } else if (i == R.id.type_text_view) {
            if (questionSet.size() > 1) {
                DialogUtils.getInstance().displayPopupWindow(quickActionLineView, TestModuleActivity.this, questionSet, this, typeTextView.getText().toString());
            }

        } else if(i == R.id.filter_fab){
            canStopTimer = false;
            LargeAppInfo.getInstance().setBaseFilterArray(questionAnswerInfo);
            startActivityForResult(new Intent(getApplicationContext(), TestAppFilterActivity.class), FILTER_TYPE);
        }else if(i == R.id.submit_btn){
            if (solutionUrl != null && solutionUrl.equals("0")) {
                DialogUtils.getInstance().submitTestDialog(TestModuleActivity.this, questionAnswerInfo, this, true);
            } else {
                DialogUtils.getInstance().submitTestDialog(TestModuleActivity.this, questionAnswerInfo, this, false);
            }
        }else if(i == R.id.timer_submit_layout){
            if (solutionUrl != null && solutionUrl.equals("0")) {
                DialogUtils.getInstance().submitTestDialog(TestModuleActivity.this, questionAnswerInfo, this, true);
            } else {
                DialogUtils.getInstance().submitTestDialog(TestModuleActivity.this, questionAnswerInfo, this, false);
            }
        }else if(i == R.id.next_btn){
            if (solutionUrl != null && solutionUrl.equals("0")) {
                DialogUtils.getInstance().submitTestDialog(TestModuleActivity.this, questionAnswerInfo, this, true);
            } else {
                DialogUtils.getInstance().submitTestDialog(TestModuleActivity.this, questionAnswerInfo, this, false);
            }
        }

    }
}
