package in.oliveboard.sdk.ui;

import android.content.Intent;
import android.os.Bundle;
import android.support.design.widget.Snackbar;
import android.support.design.widget.TextInputLayout;
import android.support.v7.widget.Toolbar;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.view.View;
import android.view.WindowManager;
import android.widget.Button;
import android.widget.EditText;
import android.widget.Toast;

import java.util.HashMap;
import java.util.Map;

import in.oliveboard.sdk.R;
import in.oliveboard.sdk.presenter.AuthPresenter;
import in.oliveboard.sdk.presenter.interfaces.AuthContract;
import in.oliveboard.sdk.presenter.model.LoginResponseModel;
import in.oliveboard.sdk.ui.base.BaseActivity;
import in.oliveboard.sdk.utils.AppPreferences;
import in.oliveboard.sdk.utils.Constants;
import in.oliveboard.sdk.utils.LargeAppInfo;
import in.oliveboard.sdk.utils.LargeDataHandler;
import in.oliveboard.sdk.utils.Utils;


public class SignupOliveBoardActivity extends BaseActivity implements AuthContract.View {
    Toolbar toolbar;
    EditText mSignup_email;
    EditText mSignup_pwd;
    EditText mSignup_phNo;
    TextInputLayout mInputEmail;
    TextInputLayout mInputPwd;
    TextInputLayout mInputPhNo;
    Button mSignUp;
    Button mSwitch_signIn;
    String input_email;
    String input_password;
    String input_mobNumber;
    public String token;

    private static final int RC_SIGN_IN = 9001;
    AuthPresenter presenter = new AuthPresenter();

    @Override
    protected void initializeDagger() {

        toolbar = findViewById(R.id.toolbar);
        mSignup_email = findViewById(R.id.input_email);
        mSignup_pwd = findViewById(R.id.input_password);
        mSignup_phNo = findViewById(R.id.input_phone);

        mInputEmail = findViewById(R.id.input_layout_email);
        mInputPwd = findViewById(R.id.input_layout_password);
        mInputPhNo = findViewById(R.id.input_layout_phone);

        mSignUp = findViewById(R.id.btn_signup);
        mSwitch_signIn = findViewById(R.id.txt_signUp);

        setSupportActionBar(toolbar);
        setBackEnabled(false);
       // setTitle("Oliveboard");
        toolbar.setNavigationOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                Intent BackpressedIntent = new Intent();
                BackpressedIntent .setClass(getApplicationContext(),SignupOliveBoardActivity.class);
                startActivity(BackpressedIntent);
                finish();
            }
        });

        mSignup_email.addTextChangedListener(new MyTextWatcher(mSignup_email));
        mSignup_pwd.addTextChangedListener(new MyTextWatcher(mSignup_pwd));
        mSignup_phNo.addTextChangedListener(new MyTextWatcher(mSignup_phNo));
        LargeAppInfo.getInstance().changeLang("en",getApplicationContext());
        mSignUp.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                if (!validateForm()) return;
                Utils.hideSoftKeyboard(SignupOliveBoardActivity.this, mSignup_email);
                Utils.hideSoftKeyboard(SignupOliveBoardActivity.this, mSignup_pwd);
                Utils.hideSoftKeyboard(SignupOliveBoardActivity.this, mSignup_phNo);

                if (Utils.isConnectionAvailable(SignupOliveBoardActivity.this)) {

                    showProgressDialog(getString(R.string.str_please_wait));

                    Map<String, String> map = new HashMap<String, String>();
                    map.put("e", input_email);
                    map.put("p", input_password);
                    map.put("m", input_mobNumber);
                    map.put("ref",getApplicationContext().getPackageName());
                    new AppPreferences(getApplicationContext(), Constants.PREF_NAME).SaveData(Constants.KEY_TYPE,"Normal");
                    if (presenter != null) {
                        presenter.onUserRegister(map);
                    }

                } else {
                    Snackbar.make(view, Constants.ERROR_INTERNET_STATUS, Snackbar.LENGTH_LONG).show();
                }
            }
        });



        mSwitch_signIn.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                startActivity(new Intent(getApplicationContext(), LoginOliveBoardActivity.class));
                finish();
            }
        });
    }

    @Override
    protected void savedInstance(Bundle savedInstanceState) {

    }

    @Override
    protected void initializePresenter() {
        super.presenter = presenter;
        presenter.setView(this);
    }

    @Override
    public int getLayoutId() {
        return R.layout.activity_signup;
    }



    @Override
    protected void onStart() {
        super.onStart();
    }

    @Override
    protected void onResume() {
        super.onResume();
    }

    @Override
    public void loginSuccess(String token) {
        if (!isFinishing()) {
            hideProgressDialog();

            LargeDataHandler.getInstance().setMockTestUrl(token);
            new AppPreferences(getApplicationContext(),Constants.PREF_NAME).saveBoolean(Constants.IS_LOGIN, true);
            new AppPreferences(getApplicationContext(),Constants.PREF_NAME).SaveData(Constants.KEY_TOKEN, token);
            new AppPreferences(getApplicationContext(),Constants.PREF_NAME).SaveData(Constants.KEY_EMAIL, input_email);
           // startActivity(new Intent(this, HomeActivity.class));
            Intent intent = new Intent(this,HomeActivity.class);
            intent.putExtra(Constants.BUNDLE_KEY_MOCK_TEST_URL, "https://mocks.oliveboard.in/banking/android/mockstart.cgi?c=BANKING");
            intent.putExtra(Constants.BUNDLE_KEY_MOCK_TEST_TYPE, "Mock Test");
            intent.putExtra(Constants.BUNDLE_KEY_MOCK_TEST_NAME,  "Oliveboard Mock Tests");
            startActivity(intent);
            finish();
        }

    }

    @Override
    public void onFailed() {
        hideProgressDialog();
        Toast.makeText(getApplicationContext(), "Email already registered", Toast.LENGTH_SHORT).show();
    }

    @Override
    public void onFailed(String message) {
        hideProgressDialog();
        Toast.makeText(getApplicationContext(),"Please try again",Toast.LENGTH_SHORT).show();
    }

    @Override
    public void onAuthFailed() {

    }

    @Override
    public void onLoginSuccess(Object responseModel) {
        hideProgressDialog();
        if(responseModel instanceof LoginResponseModel) {

            LargeDataHandler.getInstance().setMockTestUrl(((LoginResponseModel) responseModel).starturl);
            new AppPreferences(getApplicationContext(), Constants.PREF_NAME).saveBoolean(Constants.IS_LOGIN, true);
            new AppPreferences(getApplicationContext(), Constants.PREF_NAME).SaveData(Constants.KEY_TOKEN, ((LoginResponseModel) responseModel).uauth);
            new AppPreferences(getApplicationContext(), Constants.PREF_NAME).SaveData(Constants.KEY_EMAIL, input_email);
            new AppPreferences(getApplicationContext(), Constants.PREF_NAME).SaveData(Constants.KEY_PASSWORD, input_password);

            Intent intent = new Intent(this, HomeActivity.class);
            intent.putExtra(Constants.BUNDLE_KEY_MOCK_TEST_URL, ((LoginResponseModel) responseModel).starturl);
            intent.putExtra(Constants.BUNDLE_KEY_MOCK_TEST_TYPE, "Mock Test");
            intent.putExtra(Constants.BUNDLE_KEY_MOCK_TEST_NAME, "Oliveboard Mock Tests");
            startActivity(intent);
            finish();
        }
    }

    private class MyTextWatcher implements TextWatcher {

        private View view;

        private MyTextWatcher(View view) {
            this.view = view;
        }

        @Override
        public void beforeTextChanged(CharSequence s, int start, int count, int after) {

        }

        @Override
        public void onTextChanged(CharSequence s, int start, int before, int count) {

        }

        @Override
        public void afterTextChanged(Editable s) {

        }

    }

    public boolean validateForm() {

        return validateEmail() && validatePassword() && validatePhoneNumber();
    }

    private boolean validateEmail() {
        input_email = mSignup_email.getText().toString().trim();

        if (input_email.isEmpty() || !isValidEmail(input_email)) {
            mInputEmail.setError(getString(R.string.err_msg_email));
            requestFocus(mSignup_email);
            return false;
        } else {
            mInputEmail.setErrorEnabled(false);
        }

        return true;
    }

    private boolean validatePassword() {
        input_password = mSignup_pwd.getText().toString().trim();
        if (input_password.isEmpty()) {
            mInputPwd.setError(getString(R.string.err_msg_password));
            requestFocus(mSignup_pwd);
            return false;
        } else {
            mInputPwd.setErrorEnabled(false);
        }

        return true;
    }

    private boolean validatePhoneNumber() {
        input_mobNumber = mSignup_phNo.getText().toString().trim();
        if (input_mobNumber.isEmpty() || input_mobNumber.length() != 10) {
            mInputPhNo.setError(getString(R.string.err_msg_phone));
            requestFocus(mSignup_phNo);
            return false;
        } else {
            mInputPhNo.setErrorEnabled(false);
        }

        return true;
    }

    private static boolean isValidEmail(String email) {
        return !TextUtils.isEmpty(email) && android.util.Patterns.EMAIL_ADDRESS.matcher(email).matches();
    }

    private void requestFocus(View view) {
        if (view.requestFocus()) {
            getWindow().setSoftInputMode(WindowManager.LayoutParams.SOFT_INPUT_STATE_ALWAYS_VISIBLE);
        }
    }


    @Override
    protected void onDestroy() {
        super.onDestroy();
        if (presenter != null) {
        }
    }


    @Override
    public void onBackPressed() {
        if (getIntent() != null && getIntent().getExtras() != null && getIntent().getExtras().containsKey("form")) {
            finish();
        } else {
            Intent BackpressedIntent = new Intent();
            BackpressedIntent.setClass(getApplicationContext(), SignupOliveBoardActivity.class);
            startActivity(BackpressedIntent);
            finish();
        }
    }

}
