package in.oliveboard.sdk.presenter.model;

import java.util.ArrayList;

public class TestAppModel {

    private ArrayList<Object> testDataArrayList;
    private String questionId;
    private boolean isFavorite=false;
    private int selectedOption=-1;
    private int questionIndex=0;
    private ArrayList<SessionInfo>sessionTimeList=new ArrayList<>();
    String key;
    String answer;
    int totalPosition;
    boolean isExpanded;

    public TestAppModel(int totalPosition,String key,ArrayList<Object> testDataArrayList,int questionindex,String questionId,boolean isExpanded) {
        this.testDataArrayList=testDataArrayList;
        this.questionIndex=questionindex;
        this.questionId=questionId;
        this.key=key;
        this.totalPosition=totalPosition;
        this.isExpanded=isExpanded;
    }




    public TestAppModel(int totalPosition, String key, ArrayList<Object> testDataArrayList, int questionindex, String questionId,String answer,boolean isExpanded) {
        this.testDataArrayList=testDataArrayList;
        this.questionIndex=questionindex;
        this.questionId=questionId;
        this.key=key;
        this.totalPosition=totalPosition;
        this.answer=answer;
        this.isExpanded=isExpanded;

    }


    public void setSelectionOption(int selectedOption) {
        this.selectedOption = selectedOption;
    }

    public void setAnswer(String answer) {
        this.answer = answer;
    }

    public void setMarked(boolean isFavorite) {
        this.isFavorite = isFavorite;
    }

    public int getSelectionOption() {
        return selectedOption;
    }

    public int getQuestionIndex() {
        return questionIndex;
    }

    public boolean isFavorite() {
        return isFavorite;
    }

    public String getQuestionId() {
        return questionId;
    }

    public ArrayList<Object> getTestInfo()
    {
        return testDataArrayList;
    }

    public void setSessionData(ArrayList<String>sessionInfo)
    {
        sessionTimeList.add(new SessionInfo(sessionInfo));
    }

    public ArrayList<SessionInfo> getAllSessionData()
    {
        return sessionTimeList;
    }

    public String getKey() {
        return key;
    }

    public int getTotalPosition() {
        return totalPosition;
    }

    public String getAnswer() {
        return answer;
    }

    public boolean getExpanded()
    {
        return isExpanded;
    }

    public void setExpanded(boolean expanded) {
        this.isExpanded = expanded;
    }

    public void setPauseSession(ArrayList<SessionInfo>pauseSessionTimeList) {
        sessionTimeList.addAll(pauseSessionTimeList);
    }
}
