/*
 * Decompiled with CFR 0.152.
 */
package in.oliveboard.sdk.ui;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.support.design.widget.Snackbar;
import android.support.design.widget.TextInputLayout;
import android.support.v4.app.ActivityCompat;
import android.support.v4.content.ContextCompat;
import android.support.v7.widget.Toolbar;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.util.Log;
import android.util.Patterns;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;
import android.widget.TextView;
import android.widget.Toast;
import in.oliveboard.sdk.R;
import in.oliveboard.sdk.presenter.AuthPresenter;
import in.oliveboard.sdk.presenter.interfaces.AuthContract;
import in.oliveboard.sdk.presenter.model.LoginResponseModel;
import in.oliveboard.sdk.ui.ForgotPasswordActivity;
import in.oliveboard.sdk.ui.HomeActivity;
import in.oliveboard.sdk.ui.SignupActivity;
import in.oliveboard.sdk.ui.base.BaseActivity;
import in.oliveboard.sdk.utils.AppPreferences;
import in.oliveboard.sdk.utils.BaseSharedPreferences;
import in.oliveboard.sdk.utils.BasicConfig;
import in.oliveboard.sdk.utils.Constants;
import in.oliveboard.sdk.utils.DialogUtils;
import in.oliveboard.sdk.utils.LargeAppInfo;
import in.oliveboard.sdk.utils.LargeDataHandler;
import in.oliveboard.sdk.utils.Utils;
import in.oliveboard.sdk.utils.onDialogUtilCalled;
import java.util.HashMap;

public class LoginActivity
extends BaseActivity
implements AuthContract.View,
onDialogUtilCalled {
    Toolbar toolbar;
    EditText mEmail;
    EditText mPassword;
    TextInputLayout mTextInputLayoutEmail;
    TextInputLayout mTextInputLayoutPassword;
    Button mSignIn;
    TextView mForgotPassword;
    Button mSwitch_signup;
    private String strEmailAddress;
    private String strPassword;
    AuthPresenter presenter = new AuthPresenter();
    private static final int PERMISSION_REQUEST_CODE = 1;
    private static final int REQUEST_APP_SETTINGS = 168;
    BaseSharedPreferences baseSharedPreferences;

    @Override
    protected void initializeDagger() {
        this.toolbar = (Toolbar)this.findViewById(R.id.toolbar);
        this.mEmail = (EditText)this.findViewById(R.id.input_email);
        this.mPassword = (EditText)this.findViewById(R.id.input_password);
        this.mTextInputLayoutEmail = (TextInputLayout)this.findViewById(R.id.input_layout_email);
        this.mTextInputLayoutPassword = (TextInputLayout)this.findViewById(R.id.input_layout_password);
        this.mSignIn = (Button)this.findViewById(R.id.btn_signin);
        this.mForgotPassword = (TextView)this.findViewById(R.id.txt_forgot_pwd);
        this.mSwitch_signup = (Button)this.findViewById(R.id.txt_sign);
        this.mSwitch_signup.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                LoginActivity.this.startActivity(new Intent((Context)LoginActivity.this, SignupActivity.class));
                LoginActivity.this.finish();
            }
        });
        this.mForgotPassword.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                LoginActivity.this.startActivity(new Intent((Context)LoginActivity.this, ForgotPasswordActivity.class));
            }
        });
        this.setSupportActionBar(this.toolbar);
        this.setBackEnabled(false);
        this.toolbar.setNavigationOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                LoginActivity.this.finish();
            }
        });
        this.mEmail.addTextChangedListener((TextWatcher)new MyTextWatcher((View)this.mEmail));
        this.mPassword.addTextChangedListener((TextWatcher)new MyTextWatcher((View)this.mPassword));
        this.mSignIn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (!LoginActivity.this.validateForm()) {
                    return;
                }
                Utils.hideSoftKeyboard((Context)LoginActivity.this, LoginActivity.this.mEmail);
                Utils.hideSoftKeyboard((Context)LoginActivity.this, LoginActivity.this.mPassword);
                LargeAppInfo.getInstance().changeLang("en", LoginActivity.this.getApplicationContext());
                if (Utils.isConnectionAvailable((Context)LoginActivity.this)) {
                    LoginActivity.this.showProgressDialog(LoginActivity.this.getString(R.string.str_please_wait));
                    HashMap<String, String> params = new HashMap<String, String>();
                    params.put("e", LoginActivity.this.strEmailAddress);
                    params.put("p", LoginActivity.this.strPassword);
                    params.put("ref", LoginActivity.this.getApplicationContext().getPackageName());
                    new AppPreferences(LoginActivity.this.getApplicationContext(), "LoginPref").SaveData("email_type", "Normal");
                    if (LoginActivity.this.presenter != null) {
                        LoginActivity.this.presenter.onUserLogin(params);
                    }
                } else {
                    Snackbar.make((View)view, (CharSequence)"No internet connection", (int)0).show();
                }
            }
        });
    }

    @Override
    protected void onStart() {
        super.onStart();
    }

    @Override
    protected void onResume() {
        super.onResume();
    }

    @Override
    protected void savedInstance(Bundle savedInstanceState) {
    }

    @Override
    protected void initializePresenter() {
        ((BaseActivity)this).presenter = this.presenter;
        this.presenter.setView(this);
    }

    @Override
    public int getLayoutId() {
        return R.layout.activity_login;
    }

    @Override
    public void loginSuccess(String token) {
    }

    @Override
    public void onFailed() {
        this.hideProgressDialog();
        Toast.makeText((Context)this.getApplicationContext(), (CharSequence)"Incorrect email/password. Please try again.", (int)0).show();
    }

    @Override
    public void onFailed(String message) {
        this.hideProgressDialog();
        Toast.makeText((Context)this.getApplicationContext(), (CharSequence)"Please try again", (int)0).show();
    }

    @Override
    public void onAuthFailed() {
        BasicConfig.getInstance().onAuthFailed(this);
    }

    public void onLoginSuccess(Object responseModel) {
        this.hideProgressDialog();
        if (responseModel instanceof LoginResponseModel) {
            LargeDataHandler.getInstance().setMockTestUrl(((LoginResponseModel)responseModel).starturl);
            new AppPreferences(this.getApplicationContext(), "LoginPref").saveBoolean("IsLoggedIn", true);
            new AppPreferences(this.getApplicationContext(), "LoginPref").SaveData("token", ((LoginResponseModel)responseModel).uauth);
            new AppPreferences(this.getApplicationContext(), "LoginPref").SaveData("email", this.strEmailAddress);
            new AppPreferences(this.getApplicationContext(), "LoginPref").SaveData("password", this.strPassword);
            Intent intent = new Intent((Context)this, HomeActivity.class);
            intent.putExtra(Constants.BUNDLE_KEY_MOCK_TEST_URL, ((LoginResponseModel)responseModel).starturl);
            intent.putExtra(Constants.BUNDLE_KEY_MOCK_TEST_TYPE, "Mock Test");
            intent.putExtra("com.title.bundle.language", "Oliveboard Mock Tests");
            this.startActivity(intent);
            this.finish();
        }
    }

    @TargetApi(value=21)
    public boolean validateForm() {
        return this.validateEmail() && this.validatePassword();
    }

    private boolean validateEmail() {
        this.strEmailAddress = this.mEmail.getText().toString().trim();
        if (this.strEmailAddress.isEmpty() || !LoginActivity.isValidEmail(this.strEmailAddress)) {
            this.mTextInputLayoutEmail.setError((CharSequence)this.getString(R.string.err_msg_email));
            return false;
        }
        this.mTextInputLayoutEmail.setErrorEnabled(false);
        return true;
    }

    private boolean validatePassword() {
        this.strPassword = this.mPassword.getText().toString().trim();
        if (this.strPassword.isEmpty()) {
            this.mTextInputLayoutPassword.setError((CharSequence)this.getString(R.string.err_msg_password));
            return false;
        }
        this.mTextInputLayoutPassword.setErrorEnabled(false);
        return true;
    }

    private static boolean isValidEmail(String email) {
        return !TextUtils.isEmpty((CharSequence)email) && Patterns.EMAIL_ADDRESS.matcher(email).matches();
    }

    private void requestFocus(View view) {
        if (view.requestFocus()) {
            this.getWindow().setSoftInputMode(5);
        }
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        if (this.presenter != null) {
            // empty if block
        }
    }

    private void requestPermission() {
        if (ActivityCompat.shouldShowRequestPermissionRationale((Activity)this, (String)"android.permission.READ_PHONE_STATE")) {
            if (this.baseSharedPreferences.getData("PhonePermission") != -1) {
                DialogUtils.getInstance().permissionAlerts(this, this, this.baseSharedPreferences);
            }
        } else {
            ActivityCompat.requestPermissions((Activity)this, (String[])new String[]{"android.permission.READ_PHONE_STATE"}, (int)1);
        }
    }

    @Override
    public void onOptionDialogSelected(int position) {
    }

    @Override
    public void onAutoDialogSelected() {
    }

    @Override
    public void onSubmitDialogSelected() {
    }

    @Override
    public void onExitApp() {
    }

    @Override
    public void onExitWithoutPause() {
    }

    @Override
    public void onTryAgain() {
    }

    @Override
    public void onPauseTest(boolean value) {
    }

    @Override
    public void startTest(boolean value) {
    }

    @Override
    public void retyPermission() {
        ActivityCompat.requestPermissions((Activity)this, (String[])new String[]{"android.permission.READ_PHONE_STATE"}, (int)1);
    }

    @Override
    public void gotoPurchase() {
    }

    @Override
    public void noPhoneAction() {
    }

    @Override
    public void openPermissionSetting() {
        Intent intent = new Intent();
        intent.setAction("android.settings.APPLICATION_DETAILS_SETTINGS");
        Uri uri = Uri.fromParts((String)"package", (String)this.getPackageName(), null);
        intent.setData(uri);
        this.startActivityForResult(intent, 168);
    }

    private boolean checkPermission() {
        int result = ContextCompat.checkSelfPermission((Context)this, (String)"android.permission.READ_PHONE_STATE");
        return result == 0;
    }

    public boolean isPermissionGranted() {
        if (Build.VERSION.SDK_INT >= 23) {
            if (this.checkSelfPermission("android.permission.READ_PHONE_STATE") == 0) {
                Log.v((String)"TAG", (String)"Permission is granted");
                return true;
            }
            Log.v((String)"TAG", (String)"Permission is revoked");
            ActivityCompat.requestPermissions((Activity)this, (String[])new String[]{"android.permission.READ_PHONE_STATE"}, (int)2);
            return false;
        }
        Log.v((String)"TAG", (String)"Permission is granted");
        return true;
    }

    public void onRequestPermissionsResult(int requestCode, String[] permissions, int[] grantResults) {
        switch (requestCode) {
            case 2: {
                if (grantResults.length > 0 && grantResults[0] == 0) {
                    Toast.makeText((Context)this.getApplicationContext(), (CharSequence)"Permission granted", (int)0).show();
                } else {
                    Toast.makeText((Context)this.getApplicationContext(), (CharSequence)"Permission denied", (int)0).show();
                }
                return;
            }
        }
    }

    private class MyTextWatcher
    implements TextWatcher {
        private View view;

        private MyTextWatcher(View view) {
            this.view = view;
        }

        public void beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {
        }

        public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {
        }

        public void afterTextChanged(Editable editable) {
            int i = this.view.getId();
            if (i == R.id.input_email || i == R.id.input_password) {
                // empty if block
            }
        }
    }
}

