/*
 * Decompiled with CFR 0.152.
 */
package in.oliveboard.sdk.presenter;

import android.content.Context;
import android.util.Base64;
import in.oliveboard.sdk.log.DebugMonitor;
import in.oliveboard.sdk.presenter.base.BaseCallback;
import in.oliveboard.sdk.presenter.base.Presenter;
import in.oliveboard.sdk.presenter.interfaces.CommonContract;
import in.oliveboard.sdk.presenter.interfaces.TestCallback;
import in.oliveboard.sdk.presenter.model.PauseTestData;
import in.oliveboard.sdk.presenter.model.SectionKeyValue;
import in.oliveboard.sdk.presenter.model.TestAppModel;
import in.oliveboard.sdk.presenter.model.TestResponseModel;
import in.oliveboard.sdk.presenter.usecase.TestUseCase;
import in.oliveboard.sdk.utils.Constants;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class TestPresenter
extends Presenter<CommonContract.View>
implements TestCallback {
    private final TestUseCase testUseCase = new TestUseCase();
    private final BaseCallback callback = new BaseCallback(){

        @Override
        public void onSuccess() {
        }

        public void onSuccess(Object model) {
            if (model instanceof TestResponseModel) {
                TestResponseModel response = (TestResponseModel)model;
                if (response != null) {
                    Set<String> keys = response.sections.keySet();
                    ArrayList<TestAppModel> allData = new ArrayList<TestAppModel>();
                    TreeMap<Integer, SectionKeyValue> questionSet = new TreeMap<Integer, SectionKeyValue>();
                    Set<String> pauseKeys = null;
                    if (response.pauseData != null) {
                        pauseKeys = response.pauseData.tdata.keySet();
                    }
                    int totalPosition = 0;
                    for (int i = 0; i < keys.size(); ++i) {
                        ArrayList<ArrayList<Object>> data = response.sections.get((String)keys.toArray()[i]);
                        questionSet.put(i, new SectionKeyValue((String)keys.toArray()[i], totalPosition));
                        for (int j = 0; j < data.size(); ++j) {
                            allData.add(new TestAppModel(totalPosition, (String)keys.toArray()[i], data.get(j), totalPosition, (String)data.get(j).get(0), ((String)data.get(j).get(5)).equals("1")));
                            ++totalPosition;
                        }
                    }
                    if (response.pauseData != null) {
                        try {
                            block4: for (int j = 0; j < allData.size(); ++j) {
                                if (((TestAppModel)allData.get(j)).getQuestionId().equals(response.pauseData.lqn)) {
                                    response.switchToQuestion = j;
                                }
                                for (int k = 0; k < response.pauseData.tdata.size(); ++k) {
                                    DebugMonitor.getLogger().d("keyon>>>>", (String)pauseKeys.toArray()[k]);
                                    if (!((String)pauseKeys.toArray()[k]).equals(allData.get(j).getQuestionId())) continue;
                                    DebugMonitor.getLogger().d("keyon iff>>>>", (String)pauseKeys.toArray()[k]);
                                    DebugMonitor.getLogger().d("selectedoption", response.pauseData.tdata.get((String)pauseKeys.toArray()[k]).getOptionSelected());
                                    DebugMonitor.getLogger().d("is marked", response.pauseData.tdata.get((String)pauseKeys.toArray()[k]).getsData());
                                    allData.get(j).setPauseSession(response.pauseData.tdata.get((String)pauseKeys.toArray()[k]).getSessionInfo());
                                    allData.get(j).setSelectionOption(response.pauseData.tdata.get((String)pauseKeys.toArray()[k]).getOptionSelected().equals("") ? -1 : Integer.parseInt(response.pauseData.tdata.get((String)pauseKeys.toArray()[k]).getOptionSelected()) - 1);
                                    allData.get(j).setMarked(response.pauseData.tdata.get((String)pauseKeys.toArray()[k]).getsData().equals("11"));
                                    DebugMonitor.getLogger().d("after", "----------------------------------------");
                                    DebugMonitor.getLogger().d("aftergetAllSessionData", allData.get(j).getAllSessionData().size() + "datat");
                                    DebugMonitor.getLogger().d("after is marked", allData.get(j).isFavorite() + ">");
                                    DebugMonitor.getLogger().d("after is selcoption", allData.get(j).getSelectionOption() + ">");
                                    DebugMonitor.getLogger().d("over", "----------------------------------------");
                                    continue block4;
                                }
                            }
                            response.settings.totalTime = Long.parseLong(response.pauseData.ltime);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    if (TestPresenter.this.getView() != null) {
                        ((CommonContract.View)TestPresenter.this.getView()).onTestDataCallback(response, allData, true, questionSet);
                    }
                } else if (TestPresenter.this.getView() != null) {
                    ((CommonContract.View)TestPresenter.this.getView()).onTestDataCallback(response, null, false, null);
                }
            } else if (TestPresenter.this.getView() != null) {
                ((CommonContract.View)TestPresenter.this.getView()).onSuccess(model);
            }
        }

        @Override
        public void onSuccess(String response) {
            if (TestPresenter.this.getView() != null) {
                ((CommonContract.View)TestPresenter.this.getView()).onSuccess(response);
            }
        }

        @Override
        public void onSolutionSuccess(TestResponseModel response) {
            int right = 0;
            int wrong = 0;
            if (response != null) {
                Set<String> keys = response.sections.keySet();
                ArrayList<TestAppModel> allData = new ArrayList<TestAppModel>();
                TreeMap<Integer, SectionKeyValue> questionSet = new TreeMap<Integer, SectionKeyValue>();
                int totalPosition = 0;
                for (int i = 0; i < keys.size(); ++i) {
                    ArrayList<ArrayList<Object>> data = response.sections.get((String)keys.toArray()[i]);
                    questionSet.put(i, new SectionKeyValue((String)keys.toArray()[i], totalPosition));
                    for (int j = 0; j < data.size(); ++j) {
                        ArrayList questionEncryptArray = (ArrayList)data.get(j).get(1);
                        ArrayList answerEncryptArray = (ArrayList)data.get(j).get(2);
                        ArrayList solutionEncryptArray = (ArrayList)data.get(j).get(6);
                        try {
                            String solutionDecode = URLDecoder.decode((String)solutionEncryptArray.get(1), "UTF-8");
                            if (solutionDecode.length() > 0) {
                                solutionEncryptArray.set(1, TestPresenter.this.decodeBase64(solutionDecode.substring(32, solutionDecode.length() - 32)));
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        for (int l = 0; l < questionEncryptArray.size(); ++l) {
                            try {
                                String questionDecoded = URLDecoder.decode((String)questionEncryptArray.get(l), "UTF-8");
                                if (questionDecoded.length() <= 0) continue;
                                questionEncryptArray.set(l, TestPresenter.this.decodeBase64(questionDecoded.substring(32, questionDecoded.length() - 32)));
                                continue;
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                        for (int m = 0; m < answerEncryptArray.size(); ++m) {
                            for (int k = 0; k < ((ArrayList)answerEncryptArray.get(m)).size(); ++k) {
                                try {
                                    String answerDecoded = URLDecoder.decode((String)((ArrayList)answerEncryptArray.get(m)).get(k), "UTF-8");
                                    if (answerDecoded.length() <= 0) continue;
                                    ((ArrayList)answerEncryptArray.get(m)).set(k, TestPresenter.this.decodeBase64(answerDecoded.substring(32, answerDecoded.length() - 32)));
                                    continue;
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                            }
                        }
                        data.get(j).set(1, questionEncryptArray);
                        data.get(j).set(2, answerEncryptArray);
                        data.get(j).set(6, solutionEncryptArray);
                        allData.add(new TestAppModel(totalPosition, (String)keys.toArray()[i], data.get(j), totalPosition, (String)data.get(j).get(0), (String)((ArrayList)data.get(j).get(6)).get(2), ((String)data.get(j).get(5)).equals("1")));
                        ++totalPosition;
                        if (((String)((ArrayList)data.get(j).get(6)).get(0)).equals((String)((ArrayList)data.get(j).get(6)).get(2))) {
                            ++right;
                            continue;
                        }
                        if (((String)((ArrayList)data.get(j).get(6)).get(2)).toLowerCase().equals(Constants.UNATTEMPTED)) continue;
                        ++wrong;
                    }
                }
                Set<String> painKeys = response.panes.keySet();
                for (int p = 0; p < response.panes.size(); ++p) {
                    for (int q = 0; q < response.panes.get((String)painKeys.toArray()[p]).size(); ++q) {
                        try {
                            String panesDecoded = URLDecoder.decode(response.panes.get((String)painKeys.toArray()[p]).get(q), "UTF-8");
                            if (panesDecoded.length() <= 0) continue;
                            panesDecoded = TestPresenter.this.decodeBase64(panesDecoded.substring(32, panesDecoded.length() - 32));
                            response.panes.get((String)painKeys.toArray()[p]).set(q, panesDecoded);
                            continue;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
                if (TestPresenter.this.getView() != null) {
                    ((CommonContract.View)TestPresenter.this.getView()).onSolutionDataCallback(response, allData, true, questionSet, right, wrong, Double.isNaN((float)right * 100.0f / (float)(right + wrong)) ? "0 %" : String.format("%.02f", Float.valueOf((float)right * 100.0f / (float)(right + wrong))) + " % ");
                }
            } else if (TestPresenter.this.getView() != null) {
                ((CommonContract.View)TestPresenter.this.getView()).onSolutionDataCallback(response, null, false, null, 0, 0, "");
            }
        }

        @Override
        public void onLoginSuccess(String token) {
        }

        @Override
        public void onAuthFailed() {
            ((CommonContract.View)TestPresenter.this.getView()).onAuthFailed();
        }

        @Override
        public void onFail() {
            if (TestPresenter.this.getView() != null) {
                ((CommonContract.View)TestPresenter.this.getView()).onFailed();
            }
        }

        @Override
        public void onFail(String message) {
        }

        public void onSuccess(List model) {
            if (TestPresenter.this.getView() != null) {
                ((CommonContract.View)TestPresenter.this.getView()).onSuccess(model);
            }
        }
    };

    @Override
    public void unSubscribe() {
        if (this.testUseCase != null) {
            this.testUseCase.unSubscribe();
        }
    }

    @Override
    public void callOtherTestInfo(String url, Context context) {
        if (this.testUseCase != null) {
            // empty if block
        }
    }

    @Override
    public void callPauseTest(String url, PauseTestData pauseData, String qpi, String userid, String ppid, Context context) {
        if (this.testUseCase != null) {
            this.testUseCase.getPauseTest(this.callback, url, pauseData, qpi, userid, ppid, context);
        }
    }

    @Override
    public void callPauseModuleTest(String url, PauseTestData pauseData, String qpi, String userid, String ppi) {
        if (this.testUseCase != null) {
            // empty if block
        }
    }

    @Override
    public void callMockTestInfo(String url, Context context) {
        if (this.testUseCase != null) {
            this.testUseCase.getMockData(this.callback, url, context);
        }
    }

    @Override
    public void callMockSingleTest(String url, Context context) {
        if (this.testUseCase != null) {
            this.testUseCase.getSingleTest(this.callback, url, context);
        }
    }

    @Override
    public void callNativeTestApp(String url, Context context) {
        if (this.testUseCase != null) {
            this.testUseCase.getNativeTest(this.callback, url, context);
        }
    }

    @Override
    public void callSummery(String url, Context context) {
        if (this.testUseCase != null) {
            this.testUseCase.getSummeryTest(this.callback, url, context);
        }
    }

    @Override
    public void callSubmitTest(String url, Map<String, String> params, Context context) {
        if (this.testUseCase != null) {
            this.testUseCase.getSubmitTest(this.callback, url, params, context);
        }
    }

    @Override
    public void callSolutionRequest(String url, Context context) {
        if (this.testUseCase != null) {
            this.testUseCase.getNativeSolution(this.callback, url, context);
        }
    }

    @Override
    public void callMockSectionalInfo(String url, Context context) {
        if (this.testUseCase != null) {
            this.testUseCase.getMockSectionalInfo(this.callback, url, context);
        }
    }

    @Override
    public void callWalletPlan(String url, Context context) {
        if (this.testUseCase != null) {
            this.testUseCase.getWalletInfoData(this.callback, url, context);
        }
    }

    @Override
    public void callWalletInfo(String url, Context context) {
        if (this.testUseCase != null) {
            this.testUseCase.getWalletData(this.callback, url, context);
        }
    }

    private String decodeBase64(String coded) {
        byte[] valueDecoded = new byte[]{};
        try {
            valueDecoded = Base64.decode((byte[])coded.getBytes("UTF-8"), (int)0);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return new String(valueDecoded);
    }
}

