/*
 * Decompiled with CFR 0.152.
 */
package in.oliveboard.sdk.ui.adapters;

import android.content.Context;
import android.os.Build;
import android.support.v4.content.ContextCompat;
import android.support.v7.widget.RecyclerView;
import android.text.Html;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import in.oliveboard.sdk.R;
import in.oliveboard.sdk.presenter.model.TestAppModel;
import in.oliveboard.sdk.ui.adapters.viewholder.FilterViewHolder;
import java.net.URLDecoder;
import java.util.ArrayList;

public class TestFilterAdapter
extends RecyclerView.Adapter<FilterViewHolder> {
    ArrayList<TestAppModel> filterDataList;
    int type;
    int languageType = 0;
    Context context;

    public TestFilterAdapter(ArrayList<TestAppModel> filterDataList, Context context, int type, int languageType) {
        this.filterDataList = filterDataList;
        this.context = context;
        this.type = type;
        this.languageType = languageType;
    }

    public FilterViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        View itemView = LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.test_app_filter_card, parent, false);
        return new FilterViewHolder(itemView);
    }

    public void onBindViewHolder(FilterViewHolder holder, int position) {
        holder.questionNumberTextView.setText((CharSequence)(this.filterDataList.get(position).getQuestionIndex() + 1 + "."));
        try {
            if (Build.VERSION.SDK_INT >= 24) {
                holder.title.setText((CharSequence)Html.fromHtml((String)URLDecoder.decode(((ArrayList)this.filterDataList.get(position).getTestInfo().get(3)).size() > 1 ? (String)((ArrayList)this.filterDataList.get(position).getTestInfo().get(3)).get(this.languageType) : (String)((ArrayList)this.filterDataList.get(position).getTestInfo().get(3)).get(0), "UTF-8"), (int)0));
            } else {
                holder.title.setText((CharSequence)Html.fromHtml((String)URLDecoder.decode(((ArrayList)this.filterDataList.get(position).getTestInfo().get(3)).size() > 1 ? (String)((ArrayList)this.filterDataList.get(position).getTestInfo().get(3)).get(this.languageType) : (String)((ArrayList)this.filterDataList.get(position).getTestInfo().get(3)).get(0), "UTF-8")));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            holder.title.setText((CharSequence)"short question utf encoding is wrong");
        }
        if (this.type == 0) {
            if (this.filterDataList.get(position).getSelectionOption() != -1) {
                holder.iconStatus.setBackgroundColor(ContextCompat.getColor((Context)this.context, (int)R.color.filter_blue));
            } else if (this.filterDataList.get(position).isFavorite()) {
                holder.iconStatus.setBackgroundColor(ContextCompat.getColor((Context)this.context, (int)R.color.filter_yellow));
            } else {
                holder.iconStatus.setBackgroundColor(ContextCompat.getColor((Context)this.context, (int)R.color.filter_grey));
            }
        } else if (this.type == 1) {
            holder.iconStatus.setBackgroundColor(ContextCompat.getColor((Context)this.context, (int)R.color.filter_blue));
        } else if (this.type == 3) {
            holder.iconStatus.setBackgroundColor(ContextCompat.getColor((Context)this.context, (int)R.color.filter_yellow));
        } else if (this.type == 2) {
            holder.iconStatus.setBackgroundColor(ContextCompat.getColor((Context)this.context, (int)R.color.filter_grey));
        }
    }

    public int getItemCount() {
        return this.filterDataList.size();
    }
}

