/*
 * Decompiled with CFR 0.152.
 */
package in.oliveboard.sdk.ui;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.Intent;
import android.content.res.TypedArray;
import android.support.v4.content.ContextCompat;
import android.support.v7.appcompat.R;
import android.support.v7.widget.AppCompatImageView;
import android.util.AttributeSet;
import android.view.View;
import in.oliveboard.sdk.R;
import in.oliveboard.sdk.ui.HomeActivity;
import in.oliveboard.sdk.ui.LoadingUrlActivity;
import in.oliveboard.sdk.ui.SignupActivity;
import in.oliveboard.sdk.utils.App;
import in.oliveboard.sdk.utils.BasicConfig;
import in.oliveboard.sdk.utils.Constants;
import in.oliveboard.sdk.utils.LargeDataHandler;

public class ShowOliveBoard
extends AppCompatImageView
implements View.OnClickListener {
    public Context mContext;

    public ShowOliveBoard(Context context) {
        super(context);
        this.mContext = context;
        this.setCustomTypeface(context, null);
        this.setOnClickListener(this);
    }

    public ShowOliveBoard(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.mContext = context;
        this.setCustomTypeface(context, attrs);
        this.setOnClickListener(this);
    }

    public ShowOliveBoard(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.mContext = context;
        this.setCustomTypeface(context, attrs);
        this.setOnClickListener(this);
    }

    @TargetApi(value=16)
    private void setCustomTypeface(Context context, AttributeSet attrs) {
        if (this.isInEditMode()) {
            return;
        }
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.TextAppearance);
        this.setBackground(ContextCompat.getDrawable((Context)this.mContext, (int)R.drawable.applogo_ads));
        a.recycle();
    }

    public void onClick(View view) {
        try {
            if (!BasicConfig.getInstance().getAuthData(App.getContext()).isEmpty()) {
                if (LargeDataHandler.getInstance().getMockTestUrl() != null) {
                    Intent intent = new Intent(this.mContext, HomeActivity.class);
                    intent.putExtra(Constants.BUNDLE_KEY_MOCK_TEST_URL, LargeDataHandler.getInstance().getMockTestUrl());
                    intent.putExtra(Constants.BUNDLE_KEY_MOCK_TEST_TYPE, "Mock Test");
                    intent.putExtra("com.title.bundle.language", "Oliveboard Mock Tests");
                    this.mContext.startActivity(intent);
                } else {
                    this.mContext.startActivity(new Intent(this.mContext, LoadingUrlActivity.class));
                }
            } else {
                Intent intent = new Intent(this.mContext, SignupActivity.class);
                this.mContext.startActivity(intent);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

