package in.oliveboard.sdk.ui;

import android.content.Context;
import android.content.Intent;
import android.util.Log;

import in.oliveboard.sdk.utils.App;
import in.oliveboard.sdk.utils.BasicConfig;
import in.oliveboard.sdk.utils.Constants;
import in.oliveboard.sdk.utils.LargeDataHandler;

public final class StartOliveBoard {

    public static void init(Context context, String anyData){
        if(!BasicConfig.getInstance().getAuthData(App.getContext()).isEmpty()) {

            if (LargeDataHandler.getInstance().getMockTestUrl() != null) {
                Intent intent = new Intent(context, HomeActivity.class);
                intent.putExtra(Constants.BUNDLE_KEY_MOCK_TEST_URL, LargeDataHandler.getInstance().getMockTestUrl());
                intent.putExtra(Constants.BUNDLE_KEY_MOCK_TEST_TYPE, "Mock Test");
                intent.putExtra(Constants.BUNDLE_KEY_MOCK_TEST_NAME, "Oliveboard Mock Tests");
                context.startActivity(intent);
            } else {
                context.startActivity(new Intent(context, LoadingUrlActivity.class));
            }
        }else
        {
            Intent intent = new Intent(context, SignupActivity.class);
            context.startActivity(intent);
        }
    }

    public static void init(Context context){
        if(!BasicConfig.getInstance().getAuthData(App.getContext()).isEmpty()) {

            if (LargeDataHandler.getInstance().getMockTestUrl() != null) {
                Intent intent = new Intent(context, HomeActivity.class);
                intent.putExtra(Constants.BUNDLE_KEY_MOCK_TEST_URL, LargeDataHandler.getInstance().getMockTestUrl());
                intent.putExtra(Constants.BUNDLE_KEY_MOCK_TEST_TYPE, "Mock Test");
                intent.putExtra(Constants.BUNDLE_KEY_MOCK_TEST_NAME, "Oliveboard Mock Tests");
                context.startActivity(intent);
            } else {
                context.startActivity(new Intent(context, LoadingUrlActivity.class));
            }
        }else
        {
            Intent intent = new Intent(context, SignupActivity.class);
            context.startActivity(intent);

        }
    }
}
