package in.oliveboard.sdk.presenter.base;

import java.util.Map;

import in.oliveboard.sdk.presenter.model.PauseTestData;


public class UseCase {

    public interface TestUseCase {

        void getMockSectionalInfo(BaseCallback callback, String url);

        void getMockData(BaseCallback callback, String url);

        void getSingleTest(BaseCallback callback, String url);

        void getNativeTest(BaseCallback callback, String url);

        void getNativeSolution(BaseCallback callback, String url);

        void getSummeryTest(BaseCallback callback, String url);

        void getSubmitTest(BaseCallback callback, String url, Map<String, String> params);

        void getPauseTest(BaseCallback callback, String url, PauseTestData pauseData, String qpi, String userId, String ppId);

        void getWalletInfoData(BaseCallback callback, String url);

        void getWalletData(BaseCallback callback, String url);

    }
    public interface AuthUseCase {

        void getSignUpResponse(BaseCallback callback, Map<String, String> userInfo);

        void getLoginResponse(BaseCallback callback, Map<String, String> userInfo);

        void getChangePasswordResponse(BaseCallback callback, Map<String, String> userInfo);

    }


}
