package in.oliveboard.sdk.ui;

import android.app.Activity;
import android.content.Intent;
import android.graphics.Color;
import android.os.Bundle;
import android.support.design.widget.FloatingActionButton;
import android.support.v4.content.ContextCompat;
import android.support.v7.widget.SwitchCompat;
import android.support.v7.widget.Toolbar;
import android.view.MenuItem;
import android.view.View;
import android.widget.Button;
import android.widget.CompoundButton;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.TreeMap;

import in.oliveboard.sdk.R;
import in.oliveboard.sdk.presenter.TestPresenter;
import in.oliveboard.sdk.presenter.interfaces.CommonContract;
import in.oliveboard.sdk.presenter.model.ChangeLanguage;
import in.oliveboard.sdk.presenter.model.FilterModel;
import in.oliveboard.sdk.presenter.model.SectionKeyValue;
import in.oliveboard.sdk.presenter.model.TestAppModel;
import in.oliveboard.sdk.presenter.model.TestResponseModel;
import in.oliveboard.sdk.ui.base.BaseActivity;
import in.oliveboard.sdk.ui.fragments.EmptyFragment;
import in.oliveboard.sdk.ui.fragments.TestSolutionViewPagerFragment;
import in.oliveboard.sdk.utils.App;
import in.oliveboard.sdk.utils.BasicConfig;
import in.oliveboard.sdk.utils.Constants;
import in.oliveboard.sdk.utils.DialogUtils;
import in.oliveboard.sdk.utils.FilterAsyncTask;
import in.oliveboard.sdk.utils.FilterInterface;
import in.oliveboard.sdk.utils.FilterQuestions;
import in.oliveboard.sdk.utils.MainEventBus;
import in.oliveboard.sdk.utils.TestDataChangeListener;
import in.oliveboard.sdk.utils.onDialogUtilCalled;

public class TestSolutionActivity extends BaseActivity implements CommonContract.View,FilterInterface,TestDataChangeListener,onDialogUtilCalled {
    Toolbar toolbar;
    TextView typeTextView;
    SwitchCompat languageSwitch;
    TextView hindiTextView;
    TextView englishTextView;
    View quickActionLineView;
    LinearLayout languageSwitchLayout;
    RelativeLayout emptyLayout;
    TextView examNameToolbarTextView;
    FloatingActionButton filterBtn;
    RelativeLayout typeRelativelayout;
    LinearLayout typeBottom;
    ImageView typeSection;
    Button summaryBtn;

    ArrayList<TestAppModel> questionAnswerInfo = new ArrayList<>();
    ArrayList<TestAppModel> filterQuestionArrayList = new ArrayList<>();
    TreeMap<Integer, SectionKeyValue> questionSet = new TreeMap<>();
    int selectedOption = 0;
    public static final int FILTER_TYPE = 1002;
    String totalTime, totalQuestions, testName, accuracyString, totalMark;
    int correctAnswer = 0, wrongAnser = 0;
    TestPresenter presenter = new TestPresenter();
    @Override
    protected void initializeDagger() {
        App app = (App)getApplicationContext();

        toolbar = findViewById(R.id.toolbar);
        typeTextView = findViewById(R.id.type_text_view);
        languageSwitch = findViewById(R.id.switch_language);
        hindiTextView = findViewById(R.id.hindi_txt);
        englishTextView = findViewById(R.id. english_txt);
        quickActionLineView = findViewById(R.id.fine_line_view);
        languageSwitchLayout = findViewById(R.id.language_switch_layout);
        emptyLayout = findViewById(R.id.empty);
        examNameToolbarTextView = findViewById(R.id.test_txt);
        filterBtn = findViewById(R.id.filter_fab);
        typeRelativelayout = findViewById(R.id.type_relative);
        typeBottom = findViewById(R.id.type_bottam);
        typeSection = findViewById(R.id.section);
        summaryBtn = findViewById(R.id.summery_btn);

        summaryBtn.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                DialogUtils.getInstance().startSolutionSummeryDialog(TestSolutionActivity.this, TestSolutionActivity.this, totalTime, totalQuestions, testName, false, totalMark, correctAnswer, wrongAnser, accuracyString);

            }
        });


        filterBtn.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                ((App) getApplicationContext()).setBaseFilterArray(questionAnswerInfo);
                startActivityForResult(new Intent(getApplicationContext(), SolutionAppFilterActivity.class).putExtra("data", "data"), FILTER_TYPE);
            }
        });

        typeTextView.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                if(questionSet.size()>1) {
                    DialogUtils.getInstance().displayPopupWindow(quickActionLineView, TestSolutionActivity.this, questionSet, TestSolutionActivity.this, typeTextView.getText().toString());
                }
            }
        });
        typeRelativelayout.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                if(questionSet.size()>1) {
                    DialogUtils.getInstance().displayPopupWindow(quickActionLineView, TestSolutionActivity.this, questionSet, TestSolutionActivity.this, typeTextView.getText().toString());
                }
            }
        });
        typeBottom.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                if(questionSet.size()>1) {
                    DialogUtils.getInstance().displayPopupWindow(quickActionLineView, TestSolutionActivity.this, questionSet, TestSolutionActivity.this, typeTextView.getText().toString());
                }
            }
        });
        typeSection.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                if(questionSet.size()>1) {
                    DialogUtils.getInstance().displayPopupWindow(quickActionLineView, TestSolutionActivity.this, questionSet, TestSolutionActivity.this, typeTextView.getText().toString());
                }
            }
        });

    }

    @Override
    protected void savedInstance(Bundle savedInstanceState) {

    }

    @Override
    protected void initializePresenter() {
        super.presenter = presenter;
        presenter.setView(this);
        setSupportActionBar(toolbar);
        getSupportActionBar().setDisplayHomeAsUpEnabled(true);
        if(getIntent().getExtras().getString(Constants.BASE_BUNDLE_URL)!=null) {
            if(presenter!=null) {

//              showProgressDialog(((App)getApplicationContext()).getLang().equals("hi")?getString(R.string.str_please_wait_hindi):getString(R.string.str_please_wait));
                showProgressDialog(getString(R.string.str_please_wait));

                presenter.callSolutionRequest(getIntent().getExtras().getString(Constants.BASE_BUNDLE_URL));
            }
        }
        languageSwitch.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener() {
            @Override
            public void onCheckedChanged(CompoundButton compoundButton, boolean b) {
                if (b) {
                    ((App)getApplicationContext()).setLanguageType(1);

                    englishTextView.setTextColor(ContextCompat.getColor(getApplicationContext(), R.color.light_grey));
                    hindiTextView.setTextColor(Color.BLACK);
                    MainEventBus.getInstance().post(new ChangeLanguage(1));
                } else {
                    ((App)getApplicationContext()).setLanguageType(0);

                    englishTextView.setTextColor(Color.BLACK);
                    hindiTextView.setTextColor(ContextCompat.getColor(getApplicationContext(), R.color.light_grey));
                    MainEventBus.getInstance().post(new ChangeLanguage(0));

                }
            }
        });

    }

    @Override
    public int getLayoutId() {
        return R.layout.activity_solution_infinate;
    }



    public void setFragment(int position) {
//Todo here commitAllowStateLoss
        getSupportFragmentManager()
                .beginTransaction()
                .replace(R.id.container, TestSolutionViewPagerFragment.setInstance(position,false), Constants.FRAGMENT_TAG).commitAllowingStateLoss();

    }

    @Override
    public void onChangeFavorite(int position, boolean isFav) {

    }

    @Override
    public void onChangeOptionSelection(int position, int selectedPosition) {
//        Toast.makeText(getApplicationContext(),selectedPosition+"postion"+position,1).show();
        if(questionAnswerInfo!=null && (position<questionAnswerInfo.size())) {

            questionAnswerInfo.get(position).setAnswer(Integer.toString(selectedPosition));
        }

    }

    @Override
    public void onSessionReading(int position, String key) {

    }

    @Override
    public void onChangeQuestion(String key) {
        if (typeTextView != null && !(typeTextView.getText().toString().equals(key))) {
            typeTextView.setText(key);
            selectedOption = FilterQuestions.getInstance().getQuestionSection(questionSet, key);
        }
    }

    @Override
    public void onLangaugeSwitchChange(boolean isVisible) {
        if (isVisible) {
            if (languageSwitchLayout.getVisibility() == View.INVISIBLE) {
                languageSwitchLayout.setVisibility(View.VISIBLE);
            }
        } else {
            if (languageSwitchLayout.getVisibility() == View.VISIBLE) {
                languageSwitchLayout.setVisibility(View.INVISIBLE);
            }
        }
    }

    @Override
    public void onChangeExpandData(int position, boolean isExpanded) {
        if(questionAnswerInfo!=null && (position<questionAnswerInfo.size())) {

            questionAnswerInfo.get(position).setExpanded(isExpanded);
        }
    }

    @Override
    public void onOptionDialogSelected(int position) {
        if (selectedOption != position) {

            selectedOption = position;
            typeTextView.setText(questionSet.get(selectedOption).getKey());

        }
        ((TestSolutionViewPagerFragment)
                getSupportFragmentManager().findFragmentByTag(Constants.FRAGMENT_TAG)).changePosition(questionSet.get(position).getPosition());

    }

    @Override
    public void onAutoDialogSelected() {

    }

    @Override
    public void onSubmitDialogSelected() {

    }

    @Override
    public void onExitApp() {
        finish();
    }

    @Override
    public void onExitWithoutPause() {

    }

    @Override
    public void onTryAgain() {

    }

    @Override
    public void onPauseTest(boolean value) {

    }

    @Override
    public void startTest(boolean value) {

    }

    @Override
    public void retyPermission() {

    }

    @Override
    public void gotoPurchase() {

    }

    @Override
    public void noPhoneAction() {

    }

    @Override
    public void openPermissionSetting() {

    }

    @Override
    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == FILTER_TYPE) {
            if (resultCode == Activity.RESULT_OK) {
                if (data.getIntExtra(Constants.FILTER_TYPE, 0) == Constants.TYPE_ALL) {
                    filterQuestionArrayList.clear();
                    filterQuestionArrayList.addAll(questionAnswerInfo);
                    questionSet.clear();
                    questionSet.putAll(((App) getApplicationContext()).getQuestionSet());
                    ((App) getApplicationContext()).setCurrentQuestionInfo(filterQuestionArrayList);
                    setFragment(data.getIntExtra(Constants.FILTER_POSITION, 0));

                } else if (data.getIntExtra(Constants.FILTER_TYPE, 0) == Constants.FILTER_CORRECT) {
//                    containerFrame.setVisibility(View.INVISIBLE);
                    getSupportFragmentManager()
                            .beginTransaction()
                            .replace(R.id.container, new EmptyFragment(), Constants.FRAGMENT_TAG).commitAllowingStateLoss();

                    new FilterAsyncTask(((App) getApplicationContext()), 0, Constants.FILTER_CORRECT_TYPE, questionAnswerInfo, this, data.getIntExtra(Constants.FILTER_POSITION, 0)).execute();

                } else if (data.getIntExtra(Constants.FILTER_TYPE, 0) == Constants.FILTER_WRONG) {
//                    containerFrame.setVisibility(View.INVISIBLE);
                    getSupportFragmentManager()
                            .beginTransaction()
                            .replace(R.id.container, new EmptyFragment(), Constants.FRAGMENT_TAG).commitAllowingStateLoss();

                    new FilterAsyncTask(((App) getApplicationContext()), 0, Constants.FILTER_WRONG_TYPE, questionAnswerInfo, this, data.getIntExtra(Constants.FILTER_POSITION, 0)).execute();

                    /*ArrayList<FilterModel> dataFromFilter = FilterQuestions.getInstance().filter(questionAnswerInfo, Constants.FILTER_WRONG_TYPE);
                    filterQuestionArrayList.clear();
                    questionSet.clear();
                    questionSet.putAll(dataFromFilter.get(0).getSortOrder());
                    filterQuestionArrayList.addAll(dataFromFilter.get(0).getFilterArrayList());

                    ((App) getApplicationContext()).setCurrentQuestionInfo(filterQuestionArrayList);
                    setFragment(data.getIntExtra(Constants.FILTER_POSITION, 0));*/
                } else {
//                    containerFrame.setVisibility(View.INVISIBLE);
                    getSupportFragmentManager()
                            .beginTransaction()
                            .replace(R.id.container, new EmptyFragment(), Constants.FRAGMENT_TAG).commitAllowingStateLoss();

                    new FilterAsyncTask(((App) getApplicationContext()), 0, Constants.FILTER_UN_ATTEMPTED_TYPE, questionAnswerInfo, this, data.getIntExtra(Constants.FILTER_POSITION, 0)).execute();

//                    ArrayList<FilterModel> dataFromFilter = FilterQuestions.getInstance().filter(questionAnswerInfo, Constants.FILTER_UN_ATTEMPTED_TYPE);
//                    filterQuestionArrayList.clear();
//                    questionSet.clear();
//                    questionSet.putAll(dataFromFilter.get(0).getSortOrder());
//                    filterQuestionArrayList.addAll(dataFromFilter.get(0).getFilterArrayList());
//
//                    ((App) getApplicationContext()).setCurrentQuestionInfo(filterQuestionArrayList);
//                    setFragment(data.getIntExtra(Constants.FILTER_POSITION, 0));
                }
            }
        }
    }

    @Override
    public void ongetFilterResult(ArrayList<FilterModel> filterInfo, int position) {
        if(filterInfo!=null&&filterInfo.size()>0) {
            filterQuestionArrayList.clear();
            questionSet.clear();
            questionSet.putAll(filterInfo.get(0).getSortOrder());
            filterQuestionArrayList.addAll(filterInfo.get(0).getFilterArrayList());

            ((App) getApplicationContext()).setCurrentQuestionInfo(filterQuestionArrayList);
            setFragment(position);
        }
//        containerFrame.setVisibility(View.VISIBLE);

    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        ((App) getApplicationContext()).clearAllData();
        if(presenter!=null) {
            presenter.unSubscribe();
        }

    }

    @Override
    public void onSuccess(Object responseModel) {

    }

    @Override
    public void onFailed() {
        hideProgressDialog();
        finish();
    }

    @Override
    public void onSuccess(List responseModel) {

    }

    @Override
    public void onAuthFailed() {
        BasicConfig.getInstance().onAuthFailed(this);
    }

    @Override
    public void onSuccess(String response) {

    }

    @Override
    public void onSolutionDataCallback(TestResponseModel response, ArrayList solutionList, boolean status, TreeMap questionSets, int correct, int wrong, String accurecy) {

            hideProgressDialog();
            if (status) {
                if (response != null) {
                    if (solutionList != null) {
                        questionAnswerInfo.clear();
                        questionAnswerInfo.addAll(solutionList);

                        ((App) getApplicationContext()).setCurrentQuestionInfo(questionAnswerInfo);
                        ((App) getApplicationContext()).setQuestionSize(questionAnswerInfo.size());
                        if (questionSets != null) {
                            questionSet.clear();
                            questionSet.putAll(questionSets);
                            ((App) getApplicationContext()).setQuestionSet(questionSets);
                            typeTextView.setText(questionSet.get(0).getKey());
                        }
                        ((App) getApplicationContext()).setPanesList(response.panes);
                    }
                    if (questionAnswerInfo.size() == 0) {
                        finish();
                    } else {
                        emptyLayout.setVisibility(View.GONE);
                        setFragment(0);
                        testName = response.questionId;
                        totalMark = response.total;
                        accuracyString = accurecy;
                        correctAnswer = correct;
                        wrongAnser = wrong;
                        examNameToolbarTextView.setText(testName);
                        totalTime = response.settings.totalTimeString;
                        totalQuestions = Integer.toString(response.settings.numberOfQuestion);
//                    if (getIntent().getExtras() != null && getIntent().getExtras().containsKey(Constants.BUNDLE_KEY_SUMMERY)) {
//                        DialogUtils.getInstance().startSolutionSummeryDialog(TestSolutionActivity.this, this, totalTime, totalQuestions, testName, true, totalMark, correctAnswer, wrongAnser, accuracyString);
//                    }
                    }
                } else {
                    finish();
                }
            } else {
                finish();
            }


    }

    @Override
    public void onTestDataCallback(TestResponseModel response, ArrayList restructuredModelList, boolean status, TreeMap questionSet) {

    }
    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        switch (item.getItemId()) {
            // Respond to the action bar's Up/Home button
            case android.R.id.home:
                finish();

              /*  if(getIntent().getExtras()!=null&&getIntent().getExtras().containsKey("from_test")) {

                    if (new DateRuleUtil().setDailyRatingRule(getApplicationContext(), true)) {

                        if (!(new DateRuleUtil().getRatingPreference(getApplicationContext()).getStringData(Constants.RATING_APP_AFTER_SPEC_DATE).equals(Constants.RATING_APP_NEVER))) {
                            if(progressDialog!=null) {
                                if (!progressDialog.isShowing()) {
                                    DialogUtils.getInstance().ratingDialog(TestSolutionActivity.this, false);
                                }
                            }
                            else
                            {
                                DialogUtils.getInstance().ratingDialog(TestSolutionActivity.this, false);

                            }

                        } else {
                            finish();
                        }

                    } else {
                        finish();

                    }
                }
                else
                {
                    finish();
                }*/
                return true;

        }

        return super.onOptionsItemSelected(item);
    }

    @Override
    public void onBackPressed() {

        super.onBackPressed();
/*
        if(getIntent().getExtras()!=null&&getIntent().getExtras().containsKey("from_test")) {

            if (new DateRuleUtil().setDailyRatingRule(getApplicationContext(), true)) {

                if (!(new DateRuleUtil().getRatingPreference(getApplicationContext()).getStringData(Constants.RATING_APP_AFTER_SPEC_DATE).equals(Constants.RATING_APP_NEVER))) {
                    if(progressDialog!=null) {
                        if (!progressDialog.isShowing()) {
                            DialogUtils.getInstance().ratingDialog(TestSolutionActivity.this, false);
                        }
                    }
                    else
                    {
                        DialogUtils.getInstance().ratingDialog(TestSolutionActivity.this, false);

                    }

                } else {
                    super.onBackPressed();
                }

            } else {
                super.onBackPressed();

            }
        }
        else
        {
            super.onBackPressed();
        }*/
    }
    @Override
    public void onFailed(String message) {

    }
}
   /* @Override
    public void onBackPressed() {

        if(getIntent().getExtras()!=null&&getIntent().getExtras().containsKey("from_test")) {

            if (new Utils().setDailyRatingRule(getApplicationContext(), true)) {
                if (!(new AppPreferences(getApplicationContext(), Constants.RATING_RULE_PREF).getData(Constants.RATING_APP_AFTER_SPEC_DATE).equals(Constants.RATING_APP_NEVER))) {
                    if(progressDialog!=null) {
                        if (!progressDialog.isShowing()) {
                            DialogUtils.getInstance().ratingDialog(TestSolutionActivity.this, false);
                        }
                    }
                    else
                    {
                        DialogUtils.getInstance().ratingDialog(TestSolutionActivity.this, false);

                    }

                } else {
                    super.onBackPressed();
                }

            } else {
                super.onBackPressed();

            }
        }
        else
        {
            super.onBackPressed();
        }
    }*/


