package in.oliveboard.sdk.ui;

import android.Manifest;
import android.annotation.TargetApi;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.provider.Settings;
import android.support.design.widget.Snackbar;
import android.support.design.widget.TextInputLayout;
import android.support.v4.app.ActivityCompat;
import android.support.v4.content.ContextCompat;
import android.support.v7.widget.Toolbar;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.util.Log;
import android.view.View;
import android.view.WindowManager;
import android.widget.Button;
import android.widget.EditText;
import android.widget.TextView;
import android.widget.Toast;
import java.util.HashMap;
import java.util.Map;

import in.oliveboard.sdk.BuildConfig;
import in.oliveboard.sdk.R;
import in.oliveboard.sdk.presenter.AuthPresenter;
import in.oliveboard.sdk.presenter.interfaces.AuthContract;
import in.oliveboard.sdk.presenter.model.LoginResponseModel;
import in.oliveboard.sdk.ui.base.BaseActivity;
import in.oliveboard.sdk.utils.App;
import in.oliveboard.sdk.utils.AppPreferences;
import in.oliveboard.sdk.utils.BaseSharedPreferences;
import in.oliveboard.sdk.utils.BasicConfig;
import in.oliveboard.sdk.utils.Constants;
import in.oliveboard.sdk.utils.DialogUtils;
import in.oliveboard.sdk.utils.LargeDataHandler;
import in.oliveboard.sdk.utils.Utils;
import in.oliveboard.sdk.utils.onDialogUtilCalled;


public class LoginActivity extends BaseActivity implements AuthContract.View,onDialogUtilCalled {

    Toolbar toolbar;
    EditText mEmail;
    EditText mPassword;
    TextInputLayout mTextInputLayoutEmail;
    TextInputLayout mTextInputLayoutPassword;
    Button mSignIn;
    TextView mForgotPassword;
    TextView mSwitch_signup;
    private String strEmailAddress;
    private String strPassword;

    AuthPresenter presenter = new AuthPresenter();
    private static final int PERMISSION_REQUEST_CODE = 1;
    private static final int REQUEST_APP_SETTINGS = 168;
    BaseSharedPreferences baseSharedPreferences;
    @Override
    protected void initializeDagger() {

        toolbar = findViewById(R.id.toolbar);
        mEmail = findViewById(R.id.input_email);
        mPassword = findViewById(R.id.input_password);

        mTextInputLayoutEmail = findViewById(R.id.input_layout_email);
        mTextInputLayoutPassword = findViewById(R.id.input_layout_password);

        mSignIn = findViewById(R.id.btn_signin);
        mForgotPassword = findViewById(R.id.txt_forgot_pwd);
        mSwitch_signup = findViewById(R.id.txt_sign);

       /* if(Build.VERSION.SDK_INT > Build.VERSION_CODES.LOLLIPOP_MR1) {
            if (!checkPermission()) {
                requestPermission();
            }
        }*/

        isPermissionGranted();

        Log.d("sdk","package name ** "+ getApplicationContext().getPackageName());
        mSwitch_signup.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                startActivity(new Intent(LoginActivity.this, SignupActivity.class));
                finish();
            }
        });

        mForgotPassword.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                startActivity(new Intent(LoginActivity.this, ForgotPasswordActivity.class));
            }
        });

        setSupportActionBar(toolbar);
        setBackEnabled(true);
        setTitle("Oliveboard");
        toolbar.setNavigationOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {

                finish();
            }
        });

        mEmail.addTextChangedListener(new MyTextWatcher(mEmail));
        mPassword.addTextChangedListener(new MyTextWatcher(mPassword));
        mSignIn.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                if (!validateForm()) return;
                Utils.hideSoftKeyboard(LoginActivity.this, mEmail);
                Utils.hideSoftKeyboard(LoginActivity.this, mPassword);
                ((App) getApplicationContext()).changeLang("en");
                if (Utils.isConnectionAvailable(LoginActivity.this)) {

                    showProgressDialog(getString(R.string.str_please_wait));
//                showProgressDialog(((App)getApplicationContext()).getLang().equals("hi")?getString(R.string.str_please_wait_hindi):getString(R.string.str_please_wait));

                    Map<String, String> params = new HashMap<String, String>();
                    params.put("e", strEmailAddress);
                    params.put("p", strPassword);
                    params.put("ref",getApplicationContext().getPackageName());
                    new AppPreferences(getApplicationContext(), Constants.PREF_NAME).SaveData(Constants.KEY_TYPE,"Normal");

                    if (presenter != null) {
                        presenter.onUserLogin(params);
                    }


                } else {
                    Snackbar.make(view, Constants.ERROR_INTERNET_STATUS, Snackbar.LENGTH_LONG).show();
                }
            }
        });
    }

    @Override
    protected void onStart() {
        super.onStart();
    }

    @Override
    protected void onResume() {
        super.onResume();
    }

    @Override
    protected void savedInstance(Bundle savedInstanceState) {

    }

    @Override
    protected void initializePresenter() {
        super.presenter = presenter;
        presenter.setView(this);
    }

    @Override
    public int getLayoutId() {
        return R.layout.activity_login;
    }

    @Override
    public void loginSuccess(String token) {

    }


    @Override
    public void onFailed() {
        hideProgressDialog();
        Toast.makeText(getApplicationContext(), "Incorrect email/password. Please try again.", Toast.LENGTH_SHORT).show();

    }

    @Override
    public void onFailed(String message) {
        hideProgressDialog();
        Toast.makeText(getApplicationContext(),"Please try again",Toast.LENGTH_SHORT).show();

    }

    @Override
    public void onAuthFailed() {
        BasicConfig.getInstance().onAuthFailed(this);
    }

    @Override
    public void onLoginSuccess(Object responseModel) {
        hideProgressDialog();
        if(responseModel instanceof LoginResponseModel) {

            LargeDataHandler.getInstance().setMockTestUrl(((LoginResponseModel) responseModel).starturl);
            new AppPreferences(getApplicationContext(), Constants.PREF_NAME).saveBoolean(Constants.IS_LOGIN, true);
            new AppPreferences(getApplicationContext(), Constants.PREF_NAME).SaveData(Constants.KEY_TOKEN, ((LoginResponseModel) responseModel).uauth);
            new AppPreferences(getApplicationContext(), Constants.PREF_NAME).SaveData(Constants.KEY_EMAIL, strEmailAddress);
            new AppPreferences(getApplicationContext(), Constants.PREF_NAME).SaveData(Constants.KEY_PASSWORD, strPassword);

            Intent intent = new Intent(this, HomeActivity.class);
            intent.putExtra(Constants.BUNDLE_KEY_MOCK_TEST_URL, ((LoginResponseModel) responseModel).starturl);
            intent.putExtra(Constants.BUNDLE_KEY_MOCK_TEST_TYPE, "Mock Test");
            intent.putExtra(Constants.BUNDLE_KEY_MOCK_TEST_NAME, "Mock Test");
            startActivity(intent);
            finish();
        }

    }

    private class MyTextWatcher implements TextWatcher {

        private View view;

        private MyTextWatcher(View view) {
            this.view = view;
        }

        public void beforeTextChanged
                (CharSequence charSequence, int i, int i1, int i2) {
        }

        public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {
        }

        public void afterTextChanged(Editable editable) {
            int i = view.getId();
            if (i == R.id.input_email) {//validateEmail();

            } else if (i == R.id.input_password) {//validatePassword();

            }
        }
    }

    @TargetApi(Build.VERSION_CODES.LOLLIPOP)
    public boolean validateForm() {

        return validateEmail() && validatePassword();

    }

    private boolean validateEmail() {
        strEmailAddress = mEmail.getText().toString().trim();


        if (strEmailAddress.isEmpty() || !isValidEmail(strEmailAddress)) {

            mTextInputLayoutEmail.setError(getString(R.string.err_msg_email));
            //requestFocus(mEmail);
            return false;
        } else {
            mTextInputLayoutEmail.setErrorEnabled(false);
        }

        return true;
    }

    private boolean validatePassword() {
        strPassword = mPassword.getText().toString().trim();
        if (strPassword.isEmpty()) {
            mTextInputLayoutPassword.setError(getString(R.string.err_msg_password));
            //requestFocus(mPassword);
            return false;
        } else {
            mTextInputLayoutPassword.setErrorEnabled(false);
        }

        return true;
    }

    private static boolean isValidEmail(String email) {
        return !TextUtils.isEmpty(email) && android.util.Patterns.EMAIL_ADDRESS.matcher(email).matches();
    }

    private void requestFocus(View view) {
        if (view.requestFocus()) {
            getWindow().setSoftInputMode(WindowManager.LayoutParams.SOFT_INPUT_STATE_ALWAYS_VISIBLE);
        }
    }


    @Override
    protected void onDestroy() {
        super.onDestroy();
        if (presenter != null) {
        }
    }

    private void requestPermission() {

        if (ActivityCompat.shouldShowRequestPermissionRationale(LoginActivity.this, Manifest.permission.READ_PHONE_STATE)) {

            if (baseSharedPreferences.getData(Constants.PHONE_PERMISSION) != -1) {
                DialogUtils.getInstance().permissionAlerts(LoginActivity.this, LoginActivity.this,baseSharedPreferences);

            }
        } else {

            ActivityCompat.requestPermissions(LoginActivity.this, new String[]{Manifest.permission.READ_PHONE_STATE}, PERMISSION_REQUEST_CODE);
        }
    }

    @Override
    public void onOptionDialogSelected(int position) {

    }

    @Override
    public void onAutoDialogSelected() {

    }

    @Override
    public void onSubmitDialogSelected() {

    }

    @Override
    public void onExitApp() {

    }

    @Override
    public void onExitWithoutPause() {

    }

    @Override
    public void onTryAgain() {

    }

    @Override
    public void onPauseTest(boolean value) {

    }

    @Override
    public void startTest(boolean value) {

    }

    @Override
    public void retyPermission() {
        ActivityCompat.requestPermissions(LoginActivity.this, new String[]{Manifest.permission.READ_PHONE_STATE}, PERMISSION_REQUEST_CODE);

    }

    @Override
    public void gotoPurchase() {

    }

    @Override
    public void noPhoneAction() {

    }

    @Override
    public void openPermissionSetting() {
        Intent intent = new Intent();
        intent.setAction(Settings.ACTION_APPLICATION_DETAILS_SETTINGS);
        Uri uri = Uri.fromParts("package", getPackageName(), null);
        intent.setData(uri);
        startActivityForResult(intent,REQUEST_APP_SETTINGS);
    }

    private boolean checkPermission() {
        int result = ContextCompat.checkSelfPermission(LoginActivity.this, Manifest.permission.READ_PHONE_STATE);
        if (result == PackageManager.PERMISSION_GRANTED) {

            return true;

        } else {

            return false;

        }
    }

    public  boolean isPermissionGranted() {
        if (Build.VERSION.SDK_INT >= 23) {
            if (checkSelfPermission(android.Manifest.permission.READ_PHONE_STATE)
                    == PackageManager.PERMISSION_GRANTED) {
                Log.v("TAG","Permission is granted");
                return true;
            } else {

                Log.v("TAG","Permission is revoked");
                ActivityCompat.requestPermissions(this, new String[]{Manifest.permission.READ_PHONE_STATE}, 2);
                return false;
            }
        }
        else { //permission is automatically granted on sdk<23 upon installation
            Log.v("TAG","Permission is granted");
            return true;
        }
    }
    @Override
    public void onRequestPermissionsResult(int requestCode,
                                           String permissions[], int[] grantResults) {
        switch (requestCode) {

            case 2: {

                if (grantResults.length > 0
                        && grantResults[0] == PackageManager.PERMISSION_GRANTED) {
                    Toast.makeText(getApplicationContext(), "Permission granted", Toast.LENGTH_SHORT).show();
                    //do ur specific task after read phone state granted
                } else {
                    Toast.makeText(getApplicationContext(), "Permission denied", Toast.LENGTH_SHORT).show();
                }
                return;
            }

        }
    }

}
