/*
 * Decompiled with CFR 0.152.
 */
package in.oliveboard.sdk.utils;

import android.app.Activity;
import android.app.ProgressDialog;
import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.support.v4.content.ContextCompat;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import android.widget.EditText;
import android.widget.Toast;

public class Utils {
    private static String mTag = Utils.class.getSimpleName();
    private static Toast sToast;
    private static ProgressDialog progressDialog;

    public static void showToast(Context context, String text) {
        if (sToast != null) {
            sToast.cancel();
        }
        sToast = Toast.makeText((Context)context, (CharSequence)text, (int)0);
        sToast.show();
    }

    public static void showSoftKeyboard(Context ctx, EditText editText) {
        InputMethodManager imm = (InputMethodManager)ctx.getSystemService("input_method");
        imm.showSoftInput((View)editText, 1);
    }

    public static void hideSoftKeyboard(Context ctx, EditText editText) {
        InputMethodManager imm = (InputMethodManager)ctx.getSystemService("input_method");
        imm.hideSoftInputFromWindow(editText.getWindowToken(), 0);
    }

    public static boolean isConnectionAvailable(Context context) {
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
        return networkInfo != null && networkInfo.isConnectedOrConnecting();
    }

    public boolean checkPermission(Context context) {
        int result = ContextCompat.checkSelfPermission((Context)context, (String)"android.permission.READ_PHONE_STATE");
        return result == 0;
    }

    public static void showProgressDialog(Context context, String msg) {
        if (progressDialog == null) {
            progressDialog = new ProgressDialog(context);
        }
        if (!msg.isEmpty()) {
            progressDialog.setMessage((CharSequence)msg);
        }
        progressDialog.setCancelable(true);
        progressDialog.setCanceledOnTouchOutside(false);
        if (!((Activity)context).isFinishing()) {
            progressDialog.show();
        }
    }

    public static void removeProgressDialog() {
        try {
            if (null != progressDialog && progressDialog.isShowing()) {
                progressDialog.dismiss();
                progressDialog = null;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        progressDialog = null;
    }
}

