/*
 * Decompiled with CFR 0.152.
 */
package in.oliveboard.sdk.ui.fragments;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v4.widget.SwipeRefreshLayout;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import android.widget.TextView;
import android.widget.Toast;
import com.squareup.otto.Subscribe;
import in.oliveboard.sdk.R;
import in.oliveboard.sdk.presenter.TestPresenter;
import in.oliveboard.sdk.presenter.interfaces.CommonContract;
import in.oliveboard.sdk.presenter.model.ClearTest;
import in.oliveboard.sdk.presenter.model.MockSingleDataModel;
import in.oliveboard.sdk.presenter.model.RefreshFragment;
import in.oliveboard.sdk.presenter.model.RefreshTestInfo;
import in.oliveboard.sdk.presenter.model.TestResponseModel;
import in.oliveboard.sdk.presenter.model.TestStatusEventModel;
import in.oliveboard.sdk.ui.SummeryActivity;
import in.oliveboard.sdk.ui.TestModuleActivity;
import in.oliveboard.sdk.ui.TestUpgradeActivity;
import in.oliveboard.sdk.ui.WebActivity;
import in.oliveboard.sdk.ui.adapters.MockTestListAdaptor;
import in.oliveboard.sdk.ui.base.BaseFragment;
import in.oliveboard.sdk.utils.App;
import in.oliveboard.sdk.utils.BasicConfig;
import in.oliveboard.sdk.utils.Constants;
import in.oliveboard.sdk.utils.DialogUtils;
import in.oliveboard.sdk.utils.LargeDataHandler;
import in.oliveboard.sdk.utils.MainEventBus;
import in.oliveboard.sdk.utils.RecyclerItemClickListener;
import in.oliveboard.sdk.utils.Utils;
import in.oliveboard.sdk.utils.onDialogOptionCalled;
import in.oliveboard.sdk.utils.onDialogUtilCalled;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;

public class MockFragment
extends BaseFragment
implements SwipeRefreshLayout.OnRefreshListener,
CommonContract.View,
onDialogUtilCalled,
onDialogOptionCalled {
    SwipeRefreshLayout swipeRefreshLayout;
    RecyclerView recyclerView;
    TextView mockHeader;
    TextView noOfTests;
    RelativeLayout mockHeaderLayout;
    int usernewApp = 0;
    String paymentUrl;
    String buyUrl;
    String examName = "";
    String descriptionText;
    int forcePostion;
    TestPresenter presenter = new TestPresenter();
    ArrayList<ArrayList<String>> mockTestList = new ArrayList();
    MockTestListAdaptor mockTestListAdaptor;
    String urlTest;

    @Override
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        super.onCreateView(inflater, container, savedInstanceState);
        this.view = inflater.inflate(this.getLayoutId(), container, false);
        if (this.presenter != null) {
            this.presenter.initialize(this.getArguments());
        }
        this.swipeRefreshLayout = (SwipeRefreshLayout)this.view.findViewById(R.id.swipe_container);
        this.recyclerView = (RecyclerView)this.view.findViewById(R.id.recycler_view_mock);
        this.mockHeader = (TextView)this.view.findViewById(R.id.title_head);
        this.noOfTests = (TextView)this.view.findViewById(R.id.desc_head);
        this.mockHeaderLayout = (RelativeLayout)this.view.findViewById(R.id.head);
        return this.view;
    }

    @Override
    protected void initializeDagger() {
        App app = (App)this.getActivity().getApplicationContext();
    }

    @Override
    protected void initializePresenter() {
        ((BaseFragment)this).presenter = this.presenter;
        this.presenter.setView(this);
    }

    @Override
    protected void initializeActivity() {
        this.recyclerView.setHasFixedSize(true);
        this.recyclerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager((Context)this.getActivity()));
        this.recyclerView.addOnItemTouchListener((RecyclerView.OnItemTouchListener)new RecyclerItemClickListener((Context)this.getActivity(), this.recyclerView, new RecyclerItemClickListener.OnItemClickListener(){

            @Override
            public void onItemClick(View view, int position) {
                if (MockFragment.this.descriptionText != null && position == 0) {
                    return;
                }
                if (MockFragment.this.descriptionText != null) {
                    --position;
                }
                if ("AV".equalsIgnoreCase(MockFragment.this.mockTestList.get(position).get(0)) && MockFragment.this.usernewApp == 0 || "AV".equalsIgnoreCase(MockFragment.this.mockTestList.get(position).get(MockFragment.this.mockTestList.get(position).size() - 2)) && MockFragment.this.usernewApp == 0) {
                    if ("AV".equalsIgnoreCase(MockFragment.this.mockTestList.get(position).get(MockFragment.this.mockTestList.get(position).size() - 2))) {
                        MockFragment.this.startActivity(new Intent((Context)MockFragment.this.getActivity(), WebActivity.class).putExtra(Constants.BUNDLE_WEB_URL, MockFragment.this.mockTestList.get(position).get(MockFragment.this.mockTestList.get(position).size() - 1)).putExtra("ForceReload", true).putExtra("action_header", MockFragment.this.mockTestList.get(position).get(0)));
                    } else {
                        MockFragment.this.startActivity(new Intent((Context)MockFragment.this.getActivity(), WebActivity.class).putExtra(Constants.BUNDLE_WEB_URL, MockFragment.this.mockTestList.get(position).get(MockFragment.this.mockTestList.get(position).size() - 1)).putExtra("ForceReload", true).putExtra("action_header", MockFragment.this.mockTestList.get(position).get(1)));
                    }
                } else if ("CO".equalsIgnoreCase(MockFragment.this.mockTestList.get(position).get(0)) || "CO".equalsIgnoreCase(MockFragment.this.mockTestList.get(position).get(MockFragment.this.mockTestList.get(position).size() - 2))) {
                    if (MockFragment.this.getArguments().getBoolean("isMockTest")) {
                        MockFragment.this.startActivity(new Intent((Context)MockFragment.this.getActivity(), SummeryActivity.class).putExtra("exam_name", MockFragment.this.mockTestList.get(position).get(1)).putExtra(Constants.BUNDLE_SUMMERY_URL, MockFragment.this.mockTestList.get(position).get(MockFragment.this.mockTestList.get(position).size() - 1)));
                    } else {
                        MockFragment.this.startActivity(new Intent((Context)MockFragment.this.getActivity(), SummeryActivity.class).putExtra("exam_name", MockFragment.this.mockTestList.get(position).get(0)).putExtra(Constants.BUNDLE_SUMMERY_URL, MockFragment.this.mockTestList.get(position).get(MockFragment.this.mockTestList.get(position).size() - 1)));
                    }
                } else if ("UP".equalsIgnoreCase(MockFragment.this.mockTestList.get(position).get(0)) || "UP".equalsIgnoreCase(MockFragment.this.mockTestList.get(position).get(MockFragment.this.mockTestList.get(position).size() - 2))) {
                    try {
                        DialogUtils.getInstance().gotoPurchaseDialog(MockFragment.this, MockFragment.this);
                    }
                    catch (Exception exception) {}
                } else if (!"CS".equalsIgnoreCase(MockFragment.this.mockTestList.get(position).get(0)) && !"CS".equalsIgnoreCase(MockFragment.this.mockTestList.get(position).get(MockFragment.this.mockTestList.get(position).size() - 2))) {
                    if (((App)MockFragment.this.getActivity().getApplicationContext()).getExamRunning()) {
                        MockFragment.this.forcePostion = position;
                        DialogUtils.getInstance().multipleOptionFragmentDialog(MockFragment.this.getActivity(), MockFragment.this, "Alert", "You are currently attending a test this action will clear the current test \n Are you sure to continue ?", "Yes", "No");
                    } else if (MockFragment.this.mockTestList.get(position).size() > 0) {
                        MockFragment.this.examName = MockFragment.this.getArguments().getBoolean("isMockTest") ? MockFragment.this.mockTestList.get(position).get(1) : MockFragment.this.mockTestList.get(position).get(0);
                        MockFragment.this.showProgressDialog(MockFragment.this.getString(R.string.str_loading_test));
                        MockFragment.this.urlTest = MockFragment.this.mockTestList.get(position).get(MockFragment.this.mockTestList.get(position).size() - 1);
                        if (MockFragment.this.presenter != null) {
                            MockFragment.this.presenter.callNativeTestApp(MockFragment.this.mockTestList.get(position).get(MockFragment.this.mockTestList.get(position).size() - 1));
                        }
                    } else {
                        Log.e((String)"Error", (String)"Ya has error");
                    }
                }
            }

            @Override
            public void onItemLongClick(View view, int position) {
            }
        }));
        if (this.getArguments().containsKey(Constants.BUNDLE_KEY_EXAM_URL)) {
            this.mockHeader.setText((CharSequence)this.getArguments().getString(Constants.BUNDLE_TITLES));
            this.swipeRefreshLayout.setOnRefreshListener((SwipeRefreshLayout.OnRefreshListener)this);
            this.swipeRefreshLayout.setColorSchemeResources(new int[]{R.color.primary_color_dark, 17170453, 17170457, 17170451});
            if (LargeDataHandler.getInstance().getSingleData(this.getArguments().getString(Constants.BUNDLE_TITLES)) != null) {
                this.mockTestList.clear();
                this.mockTestList.addAll(LargeDataHandler.getInstance().getSingleData((String)this.getArguments().getString((String)Constants.BUNDLE_TITLES)).mockListDataList);
                this.descriptionText = LargeDataHandler.getInstance().getSingleData((String)this.getArguments().getString((String)Constants.BUNDLE_TITLES)).mockDescriptionText;
                this.usernewApp = LargeDataHandler.getInstance().getSingleData((String)this.getArguments().getString((String)Constants.BUNDLE_TITLES)).usenewapp;
                this.paymentUrl = LargeDataHandler.getInstance().getSingleData((String)this.getArguments().getString((String)Constants.BUNDLE_TITLES)).paymentUrl;
                this.buyUrl = LargeDataHandler.getInstance().getSingleData((String)this.getArguments().getString((String)Constants.BUNDLE_TITLES)).buyUrl;
                if (this.descriptionText != null && this.descriptionText.length() > 4) {
                    this.descriptionText = this.descriptionText.replaceAll("\n", "\n\n");
                }
            }
            this.mockTestListAdaptor = new MockTestListAdaptor((Context)this.getActivity(), this.mockTestList, this.descriptionText);
            this.recyclerView.setAdapter((RecyclerView.Adapter)this.mockTestListAdaptor);
            if (Utils.isConnectionAvailable((Context)this.getActivity())) {
                if (this.mockTestList.size() == 0) {
                    if (this.isAdded() && this.swipeRefreshLayout != null) {
                        this.swipeRefreshLayout.post(new Runnable(){

                            @Override
                            public void run() {
                                if (MockFragment.this.swipeRefreshLayout != null) {
                                    MockFragment.this.swipeRefreshLayout.setRefreshing(true);
                                }
                            }
                        });
                    }
                    if (this.presenter != null) {
                        this.presenter.callMockSingleTest(this.getArguments().getString(Constants.BUNDLE_KEY_EXAM_URL));
                    }
                } else {
                    this.noOfTests.setText((CharSequence)("" + this.mockTestList.size() + " Mock Tests"));
                }
            } else {
                Utils.showToast((Context)this.getActivity(), "No internet connection");
            }
        }
    }

    @Override
    public int getLayoutId() {
        return R.layout.fragment_mock;
    }

    public static MockFragment newInstance(int position, String url, String title) {
        Bundle bundleData = new Bundle();
        bundleData.putInt(Constants.BUNDLE_KEY_POSITION, position);
        bundleData.putString(Constants.BUNDLE_KEY_EXAM_URL, url);
        bundleData.putString(Constants.BUNDLE_TITLES, title);
        bundleData.putBoolean("isMockTest", true);
        MockFragment planFragment = new MockFragment();
        planFragment.setArguments(bundleData);
        return planFragment;
    }

    public static MockFragment newInstance(int position, String title) {
        Bundle bundleData = new Bundle();
        bundleData.putInt(Constants.BUNDLE_KEY_POSITION, position);
        bundleData.putString(Constants.BUNDLE_TITLES, title);
        bundleData.putBoolean("isMockTest", false);
        MockFragment planFragment = new MockFragment();
        planFragment.setArguments(bundleData);
        return planFragment;
    }

    public void onSuccess(Object responseModel) {
        if (this.isAdded()) {
            if (responseModel instanceof MockSingleDataModel) {
                LargeDataHandler.getInstance().addSingleMockData(this.getArguments().getString(Constants.BUNDLE_TITLES), (MockSingleDataModel)responseModel);
                this.mockTestList.clear();
                this.mockTestList.addAll(((MockSingleDataModel)responseModel).mockListDataList);
                this.noOfTests.setText((CharSequence)("" + ((MockSingleDataModel)responseModel).mockListDataList.size() + " Mock Tests"));
                this.usernewApp = ((MockSingleDataModel)responseModel).usenewapp;
                this.paymentUrl = ((MockSingleDataModel)responseModel).paymentUrl;
                this.buyUrl = ((MockSingleDataModel)responseModel).buyUrl;
                if (((MockSingleDataModel)responseModel).mockDescriptionText != null) {
                    this.descriptionText = ((MockSingleDataModel)responseModel).mockDescriptionText;
                    this.mockTestListAdaptor.onMockDescripionChange(((MockSingleDataModel)responseModel).mockDescriptionText);
                    this.mockTestListAdaptor.notifyDataSetChanged();
                } else {
                    this.descriptionText = null;
                    this.mockTestListAdaptor.notifyDataSetChanged();
                }
                if (this.swipeRefreshLayout != null) {
                    this.swipeRefreshLayout.setRefreshing(false);
                }
            } else if (responseModel instanceof TestResponseModel) {
                this.hideProgressDialog();
            }
            if (this.swipeRefreshLayout != null) {
                this.swipeRefreshLayout.setRefreshing(false);
            }
        }
    }

    @Override
    public void onFailed() {
        if (this.swipeRefreshLayout != null) {
            this.swipeRefreshLayout.setRefreshing(false);
        }
        this.hideProgressDialog();
    }

    public void onSuccess(List responseModel) {
    }

    @Override
    public void onAuthFailed() {
        if (this.isVisible()) {
            BasicConfig.getInstance().onAuthFailed(this);
        }
    }

    @Override
    public void onSuccess(String response) {
    }

    public void onSolutionDataCallback(TestResponseModel response, ArrayList restructuredModelList, boolean status, TreeMap questionSet, int correct, int wrong, String accurecy) {
    }

    public void onTestDataCallback(TestResponseModel response, ArrayList testAnswerModelArrayList, boolean status, TreeMap questionSet) {
        if (this.isAdded()) {
            this.hideProgressDialog();
            if (this.swipeRefreshLayout != null) {
                this.swipeRefreshLayout.setRefreshing(false);
            }
            if (status) {
                if (response != null) {
                    ((App)this.getActivity().getApplicationContext()).clearAllData();
                    ((App)this.getActivity().getApplicationContext()).setQuestionInfo(response);
                    ((App)this.getActivity().getApplicationContext()).setQuestionSet(questionSet);
                    ((App)this.getActivity().getApplicationContext()).setQuestionAnswerInfo(testAnswerModelArrayList);
                    if (this.getArguments().containsKey(Constants.BUNDLE_KEY_EXAM_URL)) {
                        this.startActivity(new Intent((Context)this.getActivity(), TestModuleActivity.class).putExtra(Constants.BASE_BUNDLE_EXAM_NAME, this.examName).putExtra(Constants.BASE_BUNDLE_URL, this.urlTest).putExtra(Constants.IS_MOCK, true));
                    } else {
                        this.startActivity(new Intent((Context)this.getActivity(), TestModuleActivity.class).putExtra(Constants.BASE_BUNDLE_EXAM_NAME, this.examName).putExtra(Constants.BASE_BUNDLE_URL, this.urlTest).putExtra(Constants.IS_MOCK, false));
                    }
                }
            } else {
                Toast.makeText((Context)this.getActivity(), (CharSequence)"try again", (int)1).show();
            }
        }
    }

    public void onRefresh() {
        if (this.getArguments().containsKey(Constants.BUNDLE_KEY_EXAM_URL) && this.presenter != null) {
            this.presenter.callMockSingleTest(this.getArguments().getString(Constants.BUNDLE_KEY_EXAM_URL));
        }
    }

    @Override
    public void onOptionDialogSelected(int position) {
    }

    @Override
    public void onAutoDialogSelected() {
    }

    @Override
    public void onSubmitDialogSelected() {
    }

    @Override
    public void onExitApp() {
    }

    @Override
    public void onExitWithoutPause() {
    }

    @Override
    public void onTryAgain() {
    }

    @Override
    public void onPauseTest(boolean value) {
    }

    @Override
    public void startTest(boolean value) {
    }

    @Override
    public void retyPermission() {
    }

    @Override
    public void gotoPurchase() {
        if (this.getActivity() != null) {
            this.getActivity().startActivity(new Intent((Context)this.getActivity(), TestUpgradeActivity.class).putExtra(Constants.PAYMENT_TYPE, this.buyUrl == null ? this.paymentUrl : this.buyUrl));
        }
    }

    @Override
    public void noPhoneAction() {
    }

    @Override
    public void openPermissionSetting() {
    }

    @Subscribe
    public void getTestSubmitStatus(TestStatusEventModel statusEventModel) {
        if (this.getArguments().containsKey(Constants.BUNDLE_KEY_EXAM_URL) && this.isAdded() && this.getUserVisibleHint() && !statusEventModel.refreshWholeTest && this.presenter != null) {
            this.presenter.callMockSingleTest(this.getArguments().getString(Constants.BUNDLE_KEY_EXAM_URL));
        }
    }

    public void onAttach(Context context) {
        super.onAttach(context);
        try {
            MainEventBus.getInstance().register((Object)this);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void onDetach() {
        super.onDetach();
        try {
            MainEventBus.getInstance().unregister((Object)this);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void onDestroy() {
        super.onDestroy();
        if (this.presenter != null) {
            this.presenter.unSubscribe();
        }
    }

    @Subscribe
    public void onRefresh(RefreshTestInfo refresh) {
        if (this.presenter != null && this.getArguments().containsKey(Constants.BUNDLE_KEY_EXAM_URL) && this.isAdded() && this.getUserVisibleHint()) {
            this.presenter.callMockSingleTest(this.getArguments().getString(Constants.BUNDLE_KEY_EXAM_URL));
        }
    }

    @Override
    public void onFailed(String message) {
    }

    @Subscribe
    public void refreshData(RefreshFragment fragment) {
        if (this.mockTestList == null || this.mockTestList.size() == 0) {
            // empty if block
        }
    }

    @Override
    public void onPositiveClick() {
        MainEventBus.getInstance().post((Object)new ClearTest());
        if (this.mockTestList.get(this.forcePostion).size() > 0) {
            this.examName = this.getArguments().getBoolean("isMockTest") ? this.mockTestList.get(this.forcePostion).get(1) : this.mockTestList.get(this.forcePostion).get(0);
            this.showProgressDialog(this.getString(R.string.str_loading_test));
            this.urlTest = this.mockTestList.get(this.forcePostion).get(this.mockTestList.get(this.forcePostion).size() - 1);
            if (this.presenter != null) {
                this.presenter.callNativeTestApp(this.mockTestList.get(this.forcePostion).get(this.mockTestList.get(this.forcePostion).size() - 1));
            }
        } else {
            Log.e((String)"Error", (String)"Ya has error");
        }
    }

    @Override
    public void onNegativeClick() {
    }
}

