/*
 * Decompiled with CFR 0.152.
 */
package in.oliveboard.sdk.ui.base;

import android.app.ProgressDialog;
import android.content.Context;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import in.oliveboard.sdk.presenter.base.BaseView;
import in.oliveboard.sdk.presenter.base.Presenter;

public abstract class BaseFragment
extends Fragment
implements BaseView {
    protected FragmentManager fragmentManager;
    protected Presenter presenter;
    protected View view;
    protected ProgressDialog progressDialog;

    protected abstract void initializeDagger();

    protected abstract void initializePresenter();

    protected abstract void initializeActivity();

    public abstract int getLayoutId();

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.fragmentManager = this.getActivity().getSupportFragmentManager();
        this.setRetainInstance(true);
        this.initializeDagger();
        this.initializePresenter();
    }

    @Nullable
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        this.view = inflater.inflate(this.getLayoutId(), container, false);
        if (this.presenter != null) {
            this.presenter.initialize(this.getArguments());
        }
        return this.view;
    }

    public void onActivityCreated(@Nullable Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        this.initializeActivity();
    }

    public void onStart() {
        super.onStart();
        if (this.presenter != null) {
            this.presenter.start();
        }
    }

    public void onStop() {
        super.onStop();
        if (this.presenter != null) {
            this.presenter.finalizeView();
        }
    }

    public void onDestroyView() {
        super.onDestroyView();
    }

    protected void showProgressDialog(String message) {
        if (this.progressDialog == null || !this.progressDialog.isShowing()) {
            this.progressDialog = new ProgressDialog((Context)this.getActivity());
            this.progressDialog.setMessage((CharSequence)message);
            this.progressDialog.setCanceledOnTouchOutside(false);
            if (this.isAdded()) {
                this.progressDialog.show();
            }
        }
    }

    protected void hideProgressDialog() {
        if (this.progressDialog != null && this.progressDialog.isShowing() && this.isAdded()) {
            this.progressDialog.dismiss();
        }
    }
}

