package in.oliveboard.sdk.ui;

import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.RequiresApi;
import android.support.design.widget.TabLayout;
import android.support.v4.content.ContextCompat;
import android.support.v4.view.ViewPager;
import android.support.v7.widget.Toolbar;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;
import android.widget.Button;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.TreeMap;

import in.oliveboard.sdk.R;
import in.oliveboard.sdk.presenter.TestPresenter;
import in.oliveboard.sdk.presenter.interfaces.CommonContract;
import in.oliveboard.sdk.presenter.model.SummeryBaseResponse;
import in.oliveboard.sdk.presenter.model.TestResponseModel;
import in.oliveboard.sdk.ui.adapters.SummaryFragmentAdapter;
import in.oliveboard.sdk.ui.base.BaseActivity;
import in.oliveboard.sdk.utils.App;
import in.oliveboard.sdk.utils.Constants;
import in.oliveboard.sdk.utils.LargeDataHandler;


public class SummeryActivity extends BaseActivity implements CommonContract.View {

    Toolbar toolbar;
    ViewPager viewPager;
    TabLayout tabs;
    Button analysisBtn;
    int solutionAppDecideFlag = 0;
    String solutionUrl;

    TestPresenter presenter = new TestPresenter();

    @RequiresApi(api = Build.VERSION_CODES.KITKAT)
    @Override
    protected void initializeDagger() {
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP) {
            Window window = getWindow();
            window.addFlags(WindowManager.LayoutParams.FLAG_DRAWS_SYSTEM_BAR_BACKGROUNDS);
            window.setStatusBarColor(ContextCompat.getColor(getApplicationContext(), R.color.primary_color_dark));
        }
        App app = (App) getApplicationContext();

        toolbar = findViewById(R.id.toolbar);
        viewPager = findViewById(R.id.pager_view);
        tabs = findViewById(R.id.summary_tabs);
        analysisBtn = findViewById(R.id.btn_analysis);

        toolbar.setNavigationIcon(R.drawable.icon_toolbar);
        setSupportActionBar(toolbar);
        setTitle(Objects.requireNonNull(getIntent().getExtras()).getString("exam_name"));
        Objects.requireNonNull(getSupportActionBar()).setDisplayHomeAsUpEnabled(true);

        analysisBtn.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                //LogEvents.getInstance().passEvents(getApplicationContext(), "SolutionSummeryScreen", "view_page", "go_to_solution_btn");
                if (1 == solutionAppDecideFlag) {

                    Intent intent = new Intent(getApplicationContext(), TestSolutionActivity.class);
                    intent.putExtra(Constants.BASE_BUNDLE_URL, solutionUrl);
                    intent.putExtra("action_header", getIntent().getExtras().getString("exam_name"));
                    if (getIntent().getExtras().containsKey("from_test")) {
                        intent.putExtra("from_test", "from_test");

                    }
                    startActivity(intent);
                    finish();


                } else {
                    startActivity(new Intent(getApplicationContext(), WebActivity.class).putExtra(Constants.BUNDLE_WEB_URL, solutionUrl).putExtra("action_header", getIntent().getExtras().getString("exam_name")).putExtra("hasExitDialog", false));
                }
            }
        });

//        webView.setFocusable(false);
//        webView.setFocusableInTouchMode(false);
    }

    @Override
    protected void savedInstance(Bundle savedInstanceState) {

    }

    @RequiresApi(api = Build.VERSION_CODES.KITKAT)
    @Override
    protected void initializePresenter() {
        super.presenter = presenter;
        presenter.setView(this);
       // LogEvents.getInstance().passEvents(getApplicationContext(), "SolutionSummeryScreen", "view_page");

        //showProgressDialog(((App)getApplicationContext()).getLang().equals("hi")?getString(R.string.str_loading_analysis_hindi):getString(R.string.str_loading_analysis));
        showProgressDialog(getString(R.string.str_loading_analysis));

        presenter.callSummery(Objects.requireNonNull(getIntent().getExtras()).getString(Constants.BUNDLE_SUMMERY_URL));
//        summeryRecyclerView.setAdapter(new SummeryAdaptor());
 /*       summeryRecyclerView.addOnItemTouchListener(new RecyclerView.OnItemTouchListener() {
            @Override
            public boolean onInterceptTouchEvent(RecyclerView rv, MotionEvent e) {
                int action = e.getAction();
                switch (action) {
                    case MotionEvent.ACTION_MOVE:
                        rv.getParent().requestDisallowInterceptTouchEvent(true);
                        break;
                }
                return false;
            }

            @Override
            public void onTouchEvent(RecyclerView rv, MotionEvent e) {

            }

            @Override
            public void onRequestDisallowInterceptTouchEvent(boolean disallowIntercept) {

            }
        });*/
//        summeryRecyclerView.setNestedScrollingEnabled(false);
    }

    @Override
    public int getLayoutId() {
        return R.layout.activity_mocksummary;
    }

    @Override
    public void onSuccess(Object responseModel) {
        hideProgressDialog();
        if (responseModel instanceof SummeryBaseResponse) {

            SummeryBaseResponse response = (SummeryBaseResponse) responseModel;
            solutionAppDecideFlag = response.solutionAppDecideFlag;
            solutionUrl = response.solutionUrl;
            LargeDataHandler.getInstance().setSummaryData(response);
            if (response.detailAnalysisWebView != null && response.detailAnalysisWebView.length() > 3) {
                viewPager.setAdapter(new SummaryFragmentAdapter(getSupportFragmentManager(),true));
                tabs.setupWithViewPager(viewPager);
            }
            else
            {
                viewPager.setAdapter(new SummaryFragmentAdapter(getSupportFragmentManager(),false));
                tabs.setVisibility(View.GONE);
            }
        }

    }

    @Override
    public void onFailed() {
        hideProgressDialog();
        finish();
    }

    @Override
    public void onSuccess(List responseModel) {

    }

    @Override
    public void onAuthFailed() {

    }

    @Override
    public void onSuccess(String response) {

    }

    @Override
    public void onSolutionDataCallback(TestResponseModel response, ArrayList restructuredModelList, boolean status, TreeMap questionSet, int correct, int wrong, String accurecy) {

    }

    @Override
    public void onTestDataCallback(TestResponseModel response, ArrayList restructuredModelList, boolean status, TreeMap questionSet) {

    }


    @Override
    protected void onDestroy() {
        super.onDestroy();

        if (presenter != null) {

            presenter.unSubscribe();
        }
    }

    @Override
    public void onFailed(String message) {

    }


}
