package in.oliveboard.sdk.ui;

import android.content.Intent;
import android.support.v7.app.AppCompatActivity;
import android.os.Bundle;
import android.view.View;
import android.widget.ProgressBar;
import android.widget.Toast;

import java.util.HashMap;
import java.util.Map;

import in.oliveboard.sdk.R;
import in.oliveboard.sdk.presenter.AuthPresenter;
import in.oliveboard.sdk.presenter.interfaces.AuthCallback;
import in.oliveboard.sdk.presenter.interfaces.AuthContract;
import in.oliveboard.sdk.presenter.model.LoginResponseModel;
import in.oliveboard.sdk.ui.base.BaseActivity;
import in.oliveboard.sdk.utils.App;
import in.oliveboard.sdk.utils.AppPreferences;
import in.oliveboard.sdk.utils.BasicConfig;
import in.oliveboard.sdk.utils.Constants;
import in.oliveboard.sdk.utils.LargeDataHandler;

public class LoadingUrlActivity extends BaseActivity implements AuthContract.View {
    ProgressBar loadingBar;
    AuthPresenter presenter = new AuthPresenter();

    @Override
    protected void initializeDagger() {
        loadingBar = findViewById(R.id.loading);
        loadingBar.setIndeterminate(true);
        loadingBar.setVisibility(View.VISIBLE);

    }

    @Override
    protected void savedInstance(Bundle savedInstanceState) {

    }

    @Override
    protected void initializePresenter() {

        super.presenter = presenter;
        presenter.setView(this);

        Map<String, String> params = new HashMap<String, String>();
        params.put("e", BasicConfig.getInstance().getAuthEmail(App.getContext()));
        params.put("p", BasicConfig.getInstance().getAuthPassword(App.getContext()));
        params.put("ref",getApplicationContext().getPackageName());
        new AppPreferences(getApplicationContext(), Constants.PREF_NAME).SaveData(Constants.KEY_TYPE,"Normal");

        if (presenter != null) {
            presenter.onUserLogin(params);
        }
    }

    @Override
    public int getLayoutId() {
        return R.layout.activity_loading_url;
    }

    @Override
    public void loginSuccess(String token) {
        loadingBar.setVisibility(View.GONE);
    }

    @Override
    public void onFailed() {
        loadingBar.setVisibility(View.GONE);
        new AppPreferences(getApplicationContext(), Constants.PREF_NAME).clearData();
        Toast.makeText(getApplicationContext(), "Incorrect email/password. Please try again.", Toast.LENGTH_SHORT).show();
        Intent intent = new Intent(this,LoginActivity.class);
        startActivity(intent);
    }

    @Override
    public void onFailed(String message) {
        loadingBar.setVisibility(View.GONE);
        Toast.makeText(getApplicationContext(),"Please try again",Toast.LENGTH_SHORT).show();
        Intent intent = new Intent(this,LoginActivity.class);
        startActivity(intent);
    }

    @Override
    public void onAuthFailed() {
        loadingBar.setVisibility(View.GONE);
        BasicConfig.getInstance().onAuthFailed(this);
    }

    @Override
    public void onLoginSuccess(Object responseModel) {
        loadingBar.setVisibility(View.GONE);
        if(responseModel instanceof LoginResponseModel) {
            LargeDataHandler.getInstance().setMockTestUrl(((LoginResponseModel) responseModel).starturl);
            new AppPreferences(getApplicationContext(), Constants.PREF_NAME).saveBoolean(Constants.IS_LOGIN, true);
            new AppPreferences(getApplicationContext(), Constants.PREF_NAME).SaveData(Constants.KEY_TOKEN, ((LoginResponseModel) responseModel).uauth);
            new AppPreferences(getApplicationContext(), Constants.PREF_NAME).SaveData(Constants.KEY_EMAIL, BasicConfig.getInstance().getAuthEmail(App.getContext()));
            new AppPreferences(getApplicationContext(), Constants.PREF_NAME).SaveData(Constants.KEY_PASSWORD, BasicConfig.getInstance().getAuthPassword(App.getContext()));

            Intent intent = new Intent(this, HomeActivity.class);
            intent.putExtra(Constants.BUNDLE_KEY_MOCK_TEST_URL, ((LoginResponseModel) responseModel).starturl);
            intent.putExtra(Constants.BUNDLE_KEY_MOCK_TEST_TYPE, "Mock Test");
            intent.putExtra(Constants.BUNDLE_KEY_MOCK_TEST_NAME, "Mock Test");
            startActivity(intent);
            finish();
        }
    }
}
