/*
 * Decompiled with CFR 0.152.
 */
package jlibs.xml;

import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.namespace.NamespaceContext;
import jlibs.core.util.ContextMap;

public class NamespaceMap
extends ContextMap<String, String>
implements NamespaceContext {
    public NamespaceMap() {
        this(null);
    }

    public NamespaceMap(ContextMap<String, String> parent) {
        super(parent);
        if (parent == null) {
            this.put("", "");
            this.put("xml", "http://www.w3.org/XML/1998/namespace");
            this.put("xmlns", "http://www.w3.org/2000/xmlns/");
        }
    }

    public NamespaceMap parent() {
        return (NamespaceMap)super.parent();
    }

    @Override
    public String getNamespaceURI(String prefix) {
        if (prefix == null) {
            throw new IllegalArgumentException("prefix is null");
        }
        return (String)this.get(prefix);
    }

    @Override
    public String getPrefix(String namespaceURI) {
        if (namespaceURI == null) {
            throw new IllegalArgumentException("namespaceURI is null");
        }
        Iterator keys = this.keys();
        while (keys.hasNext()) {
            String prefix = (String)keys.next();
            String uri = this.getNamespaceURI(prefix);
            if (!namespaceURI.equals(uri)) continue;
            return prefix;
        }
        return null;
    }

    @Override
    public Iterator<String> getPrefixes(String namespaceURI) {
        if (namespaceURI == null) {
            throw new IllegalArgumentException("namespaceURI is null");
        }
        ArrayList<String> prefixes = new ArrayList<String>();
        Iterator keys = this.keys();
        while (keys.hasNext()) {
            String prefix = (String)keys.next();
            String uri = this.getNamespaceURI(prefix);
            if (!namespaceURI.equals(uri)) continue;
            prefixes.add(prefix);
        }
        return prefixes.iterator();
    }

    public static class Handler {
        public NamespaceMap namespaceMap;
        private boolean needNewContext;

        public void startDocument() {
            this.namespaceMap = new NamespaceMap();
            this.needNewContext = true;
        }

        public void startPrefixMapping(String prefix, String uri) {
            if (this.needNewContext) {
                this.namespaceMap = new NamespaceMap(this.namespaceMap);
                this.needNewContext = false;
            }
            this.namespaceMap.put(prefix, uri);
        }

        public void startElement() {
            if (this.needNewContext) {
                this.namespaceMap = new NamespaceMap(this.namespaceMap);
            }
            this.needNewContext = true;
        }

        public void endElement() {
            this.namespaceMap = this.namespaceMap.parent();
        }
    }
}

