/*
 * Decompiled with CFR 0.152.
 */
package in.co.ophio.secure.vault;

import android.os.ParcelFileDescriptor;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class Utils {
    private Utils() {
    }

    public static void closeQuietly(Closeable closable) {
        if (closable != null) {
            try {
                closable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void closeWithErrorQuietly(ParcelFileDescriptor pfd, String msg) {
        if (pfd != null) {
            try {
                pfd.closeWithError(msg);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void writeFully(File file, byte[] data) throws IOException {
        try (FileOutputStream out = new FileOutputStream(file);){
            ((OutputStream)out).write(data);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readFully(File file) throws IOException {
        try (FileInputStream in = new FileInputStream(file);){
            int count;
            ByteArrayOutputStream bytes = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            while ((count = ((InputStream)in).read(buffer)) != -1) {
                bytes.write(buffer, 0, count);
            }
            byte[] byArray = bytes.toByteArray();
            return byArray;
        }
    }
}

