/*
 * Decompiled with CFR 0.152.
 */
package in.co.ophio.secure.core;

import android.content.ContentResolver;
import android.content.Context;
import android.content.SharedPreferences;
import android.provider.Settings;
import android.util.Base64;
import java.io.UnsupportedEncodingException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;

public class ObscuredSharedPreferences
implements SharedPreferences {
    protected static final String UTF8 = "utf-8";
    private static char[] newSecret;
    private final boolean encryptKeys;
    private SharedPreferences delegate;
    private Context context;

    public ObscuredSharedPreferences(Context context, SharedPreferences delegate) {
        this.delegate = delegate;
        this.context = context;
        this.encryptKeys = true;
    }

    public ObscuredSharedPreferences(Context context, SharedPreferences delegate, boolean encryptKeys) {
        this.delegate = delegate;
        this.context = context;
        this.encryptKeys = encryptKeys;
    }

    private char[] getSecret() throws IllegalAccessException {
        if (newSecret == null) {
            throw new IllegalAccessException("Please add a key");
        }
        return newSecret;
    }

    public void setSecret(String secret) {
        newSecret = secret.toCharArray();
    }

    private Set<String> encryptSet(Set<String> values) {
        HashSet<String> encryptedValues = new HashSet<String>();
        for (String value : values) {
            encryptedValues.add(this.encrypt(value));
        }
        return encryptedValues;
    }

    private Set<String> decryptSet(Set<String> values) {
        HashSet<String> decryptedValues = new HashSet<String>();
        for (String value : values) {
            decryptedValues.add(this.decrypt(value));
        }
        return decryptedValues;
    }

    private String encryptKey(String key) {
        return this.encryptKeys ? this.encrypt(key) : key;
    }

    public Editor edit() {
        return new Editor();
    }

    public Map<String, String> getAll() {
        Map all = this.delegate.getAll();
        Set keys = all.keySet();
        HashMap<String, String> unencryptedMap = new HashMap<String, String>(keys.size());
        for (String key : keys) {
            String decryptedKey = this.decryptKey(key);
            Object value = all.get(key);
            if (value == null) continue;
            unencryptedMap.put(decryptedKey, this.decrypt(value.toString()));
        }
        return unencryptedMap;
    }

    private String decryptKey(String key) {
        if (this.encryptKeys) {
            return this.decrypt(key);
        }
        return key;
    }

    public boolean getBoolean(String key, boolean defValue) {
        String v = this.delegate.getString(this.encryptKey(key), null);
        return v != null ? Boolean.parseBoolean(this.decrypt(v)) : defValue;
    }

    public float getFloat(String key, float defValue) {
        String v = this.delegate.getString(this.encryptKey(key), null);
        return v != null ? Float.parseFloat(this.decrypt(v)) : defValue;
    }

    public int getInt(String key, int defValue) {
        String v = this.delegate.getString(this.encryptKey(key), null);
        return v != null ? Integer.parseInt(this.decrypt(v)) : defValue;
    }

    public long getLong(String key, long defValue) {
        String v = this.delegate.getString(this.encryptKey(key), null);
        return v != null ? Long.parseLong(this.decrypt(v)) : defValue;
    }

    public String getString(String key, String defValue) {
        String v = this.delegate.getString(this.encryptKey(key), null);
        return v != null ? this.decrypt(v) : defValue;
    }

    public Set<String> getStringSet(String key, Set<String> defValues) {
        Set stringSet = this.delegate.getStringSet(this.encryptKey(key), defValues);
        return stringSet != null ? this.decryptSet(stringSet) : defValues;
    }

    public boolean contains(String s) {
        s = this.encryptKey(s);
        return this.delegate.contains(s);
    }

    public void registerOnSharedPreferenceChangeListener(SharedPreferences.OnSharedPreferenceChangeListener onSharedPreferenceChangeListener) {
        this.delegate.registerOnSharedPreferenceChangeListener(onSharedPreferenceChangeListener);
    }

    public void unregisterOnSharedPreferenceChangeListener(SharedPreferences.OnSharedPreferenceChangeListener onSharedPreferenceChangeListener) {
        this.delegate.unregisterOnSharedPreferenceChangeListener(onSharedPreferenceChangeListener);
    }

    protected String encrypt(String value) {
        try {
            byte[] bytes = value != null ? value.getBytes(UTF8) : new byte[]{};
            SecretKeyFactory keyFactory = SecretKeyFactory.getInstance("PBEWithMD5AndDES");
            SecretKey key = keyFactory.generateSecret(new PBEKeySpec(this.getSecret()));
            Cipher pbeCipher = Cipher.getInstance("PBEWithMD5AndDES");
            pbeCipher.init(1, (Key)key, new PBEParameterSpec(this.getSalt(), 20));
            return new String(Base64.encode((byte[])pbeCipher.doFinal(bytes), (int)2), UTF8);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        catch (InvalidKeySpecException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        catch (IllegalBlockSizeException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        catch (BadPaddingException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        catch (InvalidAlgorithmParameterException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        catch (InvalidKeyException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        catch (NoSuchPaddingException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    private byte[] getSalt() throws UnsupportedEncodingException {
        String id = Settings.Secure.getString((ContentResolver)this.context.getContentResolver(), (String)"android_id");
        if (id == null) {
            id = "ROBOLECTRICYOUAREBAD";
        }
        byte[] salt = Arrays.copyOf(id.getBytes(UTF8), 8);
        return salt;
    }

    protected String decrypt(String value) {
        try {
            byte[] bytes = value != null ? Base64.decode((String)value, (int)0) : new byte[]{};
            SecretKeyFactory keyFactory = SecretKeyFactory.getInstance("PBEWithMD5AndDES");
            SecretKey key = keyFactory.generateSecret(new PBEKeySpec(this.getSecret()));
            Cipher pbeCipher = Cipher.getInstance("PBEWithMD5AndDES");
            pbeCipher.init(2, (Key)key, new PBEParameterSpec(this.getSalt(), 20));
            return new String(pbeCipher.doFinal(bytes), UTF8);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public class Editor
    implements SharedPreferences.Editor {
        protected SharedPreferences.Editor delegate;

        public Editor() {
            this.delegate = ObscuredSharedPreferences.this.delegate.edit();
        }

        public Editor putBoolean(String key, boolean value) {
            this.delegate.putString(ObscuredSharedPreferences.this.encryptKey(key), ObscuredSharedPreferences.this.encrypt(Boolean.toString(value)));
            return this;
        }

        public Editor putFloat(String key, float value) {
            this.delegate.putString(ObscuredSharedPreferences.this.encryptKey(key), ObscuredSharedPreferences.this.encrypt(Float.toString(value)));
            return this;
        }

        public Editor putInt(String key, int value) {
            this.delegate.putString(ObscuredSharedPreferences.this.encryptKey(key), ObscuredSharedPreferences.this.encrypt(Integer.toString(value)));
            return this;
        }

        public Editor putLong(String key, long value) {
            this.delegate.putString(ObscuredSharedPreferences.this.encryptKey(key), ObscuredSharedPreferences.this.encrypt(Long.toString(value)));
            return this;
        }

        public Editor putString(String key, String value) {
            this.delegate.putString(ObscuredSharedPreferences.this.encryptKey(key), ObscuredSharedPreferences.this.encrypt(value));
            return this;
        }

        public SharedPreferences.Editor putStringSet(String key, Set<String> values) {
            this.delegate.putStringSet(ObscuredSharedPreferences.this.encryptKey(key), ObscuredSharedPreferences.this.encryptSet(values));
            return this;
        }

        public void apply() {
            this.delegate.apply();
        }

        public Editor clear() {
            this.delegate.clear();
            return this;
        }

        public boolean commit() {
            return this.delegate.commit();
        }

        public Editor remove(String s) {
            this.delegate.remove(ObscuredSharedPreferences.this.encryptKey(s));
            return this;
        }
    }
}

