/*
 * Decompiled with CFR 0.152.
 */
package com.sdsmdg.harjot.rotatingtext.models;

import android.graphics.Path;
import android.graphics.Typeface;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import java.util.Arrays;

public class Rotatable {
    private int color = -16777216;
    private String[] text;
    private int updateDuration = 2000;
    private int animationDuration = 1000;
    private int currentWordNumber;
    private Integer[] color_array = new Integer[]{-16777216};
    private boolean useArray = false;
    private float size = 24.0f;
    private int strokeWidth = -1;
    private Path pathIn;
    private Path pathOut;
    private Interpolator interpolator = new LinearInterpolator();
    private Typeface typeface;
    private boolean isCenter = false;
    private boolean isUpdated = false;
    private int FPS = 60;
    private int nCycles = 0;
    private int countCycles = 0;
    private String initialWord = "";
    private boolean applyHorizontal = false;

    public Rotatable(int updateDuration, String ... text) {
        this.updateDuration = updateDuration;
        this.text = text;
        this.currentWordNumber = -1;
    }

    public Rotatable(int color, int updateDuration, String ... text) {
        this.color = color;
        this.updateDuration = updateDuration;
        this.text = text;
        this.currentWordNumber = -1;
    }

    public Rotatable(Integer[] color_array, int updateDuration, String ... text) {
        this.color_array = color_array;
        this.updateDuration = updateDuration;
        this.text = text;
        this.currentWordNumber = -1;
        this.useArray = true;
    }

    public int getColor() {
        return this.color;
    }

    public boolean useArray() {
        return this.useArray;
    }

    public int getColorFromArray(int pos) {
        return this.color_array[pos];
    }

    public int colorArraySize() {
        return this.color_array.length;
    }

    public void setColor(int color) {
        this.color = color;
        this.setUpdated(true);
    }

    public int countCycles(boolean bool) {
        if (bool) {
            ++this.countCycles;
        }
        return this.countCycles;
    }

    public void setCycles(int val) {
        this.nCycles = val;
        this.countCycles = 0;
    }

    public int getCycles() {
        return this.nCycles;
    }

    public void setInitialWord(String initialWord) {
        this.initialWord = initialWord;
    }

    public String getInitialWord() {
        return this.initialWord;
    }

    public void setApplyHorizontal(Boolean bool) {
        this.applyHorizontal = bool;
    }

    public boolean getApplyHorizontal() {
        return this.applyHorizontal;
    }

    public String[] getText() {
        return this.text;
    }

    public int getWordCount() {
        return this.text.length;
    }

    public void setText(String ... text) {
        this.text = text;
    }

    public String getTextAt(int index) {
        if (index >= this.text.length) {
            throw new ArrayIndexOutOfBoundsException("index exceeded number of words!!");
        }
        return this.text[index];
    }

    public void setTextAt(int index, String word) {
        if (index >= this.text.length) {
            throw new ArrayIndexOutOfBoundsException("index exceeded number of words!!");
        }
        this.text[index] = word;
    }

    public void addTextAt(int index, String word) {
        int i;
        if (index >= this.text.length) {
            throw new ArrayIndexOutOfBoundsException("index exceeded number of words!!");
        }
        String[] copyArray = this.text;
        if (this.currentWordNumber >= index) {
            ++this.currentWordNumber;
        }
        this.text = new String[this.text.length + 1];
        for (i = 0; i < index; ++i) {
            this.text[i] = copyArray[i];
        }
        this.text[index] = word;
        ++i;
        while (i <= copyArray.length) {
            this.text[i] = copyArray[i - 1];
            ++i;
        }
    }

    public String[] peekNewTextAt(int index, String word) {
        if (index >= this.text.length) {
            throw new ArrayIndexOutOfBoundsException("index exceeded number of words!!");
        }
        String[] newSet = Arrays.copyOf(this.text, this.text.length);
        newSet[index] = word;
        return newSet;
    }

    public String[] peekAddTextAt(int index, String word) {
        int i;
        if (index >= this.text.length) {
            throw new ArrayIndexOutOfBoundsException("index exceeded number of words!!");
        }
        String[] newSet = new String[this.text.length + 1];
        for (i = 0; i < index; ++i) {
            newSet[i] = this.text[i];
        }
        newSet[index] = word;
        ++i;
        while (i <= this.text.length) {
            newSet[i] = this.text[i - 1];
            ++i;
        }
        return newSet;
    }

    public int getUpdateDuration() {
        return this.updateDuration;
    }

    public void setUpdateDuration(int updateDuration) {
        this.updateDuration = updateDuration;
        this.setUpdated(true);
    }

    public int getNextWordNumber() {
        this.currentWordNumber = (this.currentWordNumber + 1) % this.text.length;
        return this.currentWordNumber;
    }

    public String peekNextWord() {
        return this.text[(this.currentWordNumber + 1) % this.text.length];
    }

    public String getNextWord() {
        return this.text[this.getNextWordNumber()];
    }

    public String getCurrentWord() {
        return this.text[this.currentWordNumber];
    }

    public int getCurrentWordNumber() {
        return this.currentWordNumber;
    }

    public String getPreviousWord() {
        if (this.currentWordNumber <= 0) {
            return this.text[this.text.length - 1];
        }
        return this.text[this.currentWordNumber - 1];
    }

    public float getSize() {
        return this.size;
    }

    public void setSize(float size) {
        this.size = size;
        this.setUpdated(true);
    }

    public int getStrokeWidth() {
        return this.strokeWidth;
    }

    public void setStrokeWidth(int strokeWidth) {
        this.strokeWidth = strokeWidth;
    }

    public int getAnimationDuration() {
        return this.animationDuration;
    }

    public void setAnimationDuration(int animationDuration) {
        this.animationDuration = animationDuration;
        this.setUpdated(true);
    }

    public Path getPathIn() {
        return this.pathIn;
    }

    public void setPathIn(Path pathIn) {
        this.pathIn = pathIn;
    }

    public Path getPathOut() {
        return this.pathOut;
    }

    public void setPathOut(Path pathOut) {
        this.pathOut = pathOut;
    }

    public Interpolator getInterpolator() {
        return this.interpolator;
    }

    public void setInterpolator(Interpolator interpolator) {
        this.interpolator = interpolator;
        this.setUpdated(true);
    }

    public Typeface getTypeface() {
        return this.typeface;
    }

    public void setTypeface(Typeface typeface) {
        this.typeface = typeface;
        this.setUpdated(true);
    }

    public String getLargestWord() {
        String largest = "";
        for (String s : this.text) {
            if (s.length() <= largest.length()) continue;
            largest = s;
        }
        return largest;
    }

    public String getLargestWordWithSpace() {
        String largest = "";
        for (String s : this.text) {
            if (s.length() <= largest.length()) continue;
            largest = s;
        }
        return largest + " ";
    }

    public String peekLargestReplaceWord(int index, String newWord) {
        String[] newSet = this.peekNewTextAt(index, newWord);
        String largest = "";
        for (String s : newSet) {
            if (s.length() <= largest.length()) continue;
            largest = s;
        }
        return largest + " ";
    }

    public String peekLargestAddWord(int index, String newWord) {
        String[] newSet = this.peekAddTextAt(index, newWord);
        String largest = "";
        for (String s : newSet) {
            if (s.length() <= largest.length()) continue;
            largest = s;
        }
        return largest + " ";
    }

    public boolean isCenter() {
        return this.isCenter;
    }

    public void setCenter(boolean center) {
        this.isCenter = center;
        this.setUpdated(true);
    }

    public boolean isUpdated() {
        return this.isUpdated;
    }

    public void setUpdated(boolean updated) {
        this.isUpdated = updated;
    }

    public int getFPS() {
        return this.FPS;
    }

    public void setFPS(int FPS) {
        this.FPS = FPS;
    }
}

