/*
 * Decompiled with CFR 0.152.
 */
package com.sdsmdg.harjot.rotatingtext;

import android.content.Context;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.Typeface;
import android.os.Build;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.sdsmdg.harjot.rotatingtext.AnimationInterface;
import com.sdsmdg.harjot.rotatingtext.RotatingTextSwitcher;
import com.sdsmdg.harjot.rotatingtext.models.Rotatable;
import com.sdsmdg.harjot.rotatingtext.utils.Utils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class RotatingTextWrapper
extends RelativeLayout {
    ArrayList<TextView> textViews;
    private String text;
    private ArrayList<Rotatable> rotatableList;
    private List<RotatingTextSwitcher> switcherList;
    private boolean isContentSet = false;
    private Context context;
    private RelativeLayout.LayoutParams lp;
    private int prevId;
    private Typeface typeface;
    private int size = 24;
    private double changedSize = 0.0;
    private boolean adaptable = false;

    public RotatingTextWrapper(Context context) {
        super(context);
        this.context = context;
    }

    public RotatingTextWrapper(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.context = context;
    }

    public RotatingTextWrapper(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.context = context;
    }

    public void setContent(String text, Rotatable ... rotatables) {
        this.text = text;
        this.rotatableList = new ArrayList();
        this.switcherList = new ArrayList<RotatingTextSwitcher>();
        this.textViews = new ArrayList();
        Collections.addAll(this.rotatableList, rotatables);
        this.isContentSet = true;
        this.requestLayout();
    }

    public void setContent(String text, ArrayList<Rotatable> rotatables) {
        this.text = text;
        this.rotatableList = new ArrayList<Rotatable>(rotatables);
        this.switcherList = new ArrayList<RotatingTextSwitcher>();
        this.isContentSet = true;
        this.requestLayout();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        if (this.isContentSet) {
            this.removeAllViews();
            String[] array = this.text.split("\\?");
            if (array.length == 0) {
                RotatingTextSwitcher textSwitcher = new RotatingTextSwitcher(this.context);
                this.switcherList.add(textSwitcher);
                textSwitcher.setRotatable(this.rotatableList.get(0));
                if (Build.VERSION.SDK_INT < 17) {
                    textSwitcher.setId(Utils.generateViewId());
                } else {
                    textSwitcher.setId(View.generateViewId());
                }
                this.prevId = textSwitcher.getId();
                this.lp = new RelativeLayout.LayoutParams(-2, -2);
                this.lp.addRule(15);
                this.lp.addRule(9);
                this.addView((View)textSwitcher, (ViewGroup.LayoutParams)this.lp);
            }
            for (int i = 0; i < array.length; ++i) {
                TextView textView = new TextView(this.context);
                textView.setText((CharSequence)array[i]);
                if (Build.VERSION.SDK_INT < 17) {
                    textView.setId(Utils.generateViewId());
                } else {
                    textView.setId(View.generateViewId());
                }
                textView.setTextSize((float)this.size);
                this.textViews.add(textView);
                if (this.typeface != null) {
                    textView.setTypeface(this.typeface);
                }
                this.lp = new RelativeLayout.LayoutParams(-2, -2);
                this.lp.addRule(15);
                if (i == 0) {
                    this.lp.addRule(9);
                } else {
                    this.lp.addRule(1, this.prevId);
                }
                this.addView((View)textView, (ViewGroup.LayoutParams)this.lp);
                if (i >= this.rotatableList.size()) continue;
                RotatingTextSwitcher textSwitcher = new RotatingTextSwitcher(this.context);
                this.switcherList.add(textSwitcher);
                textSwitcher.setRotatable(this.rotatableList.get(i));
                if (Build.VERSION.SDK_INT < 17) {
                    textSwitcher.setId(Utils.generateViewId());
                } else {
                    textSwitcher.setId(View.generateViewId());
                }
                this.prevId = textSwitcher.getId();
                this.lp = new RelativeLayout.LayoutParams(-2, -2);
                this.lp.addRule(15);
                this.lp.addRule(1, textView.getId());
                this.addView((View)textSwitcher, (ViewGroup.LayoutParams)this.lp);
            }
            this.isContentSet = false;
        }
    }

    public void replaceWord(int rotatableIndex, int wordIndex, String newWord) {
        if (!TextUtils.isEmpty((CharSequence)newWord) && !newWord.contains("\n")) {
            final RotatingTextSwitcher switcher = this.switcherList.get(rotatableIndex);
            final Rotatable toChange = this.rotatableList.get(rotatableIndex);
            Rect result = new Rect();
            Paint paint = this.getPaint(toChange);
            paint.getTextBounds(toChange.getLargestWord(), 0, toChange.getLargestWord().length(), result);
            double originalSize = result.width();
            String toDeleteWord = toChange.getTextAt(wordIndex);
            result = new Rect();
            paint.getTextBounds(toChange.peekLargestReplaceWord(wordIndex, newWord), 0, toChange.peekLargestReplaceWord(wordIndex, newWord).length(), result);
            double finalSize = result.width();
            if (finalSize < originalSize) {
                if (toChange.getCurrentWord().equals(toDeleteWord) && switcher.animationInterface.isAnimationRunning()) {
                    toChange.setTextAt(wordIndex, newWord);
                    switcher.animationInterface.setAnimationListener(new AnimationInterface.AnimationListener(){

                        @Override
                        public void onAnimationValueChanged(boolean newValue) {
                            if (!switcher.animationInterface.isAnimationRunning()) {
                                switcher.animationInterface.setAnimationListener(null);
                                switcher.animationInterface.setAnimationListener(new AnimationInterface.AnimationListener(){

                                    @Override
                                    public void onAnimationValueChanged(boolean newValue) {
                                        if (!switcher.animationInterface.isAnimationRunning()) {
                                            switcher.animationInterface.setAnimationListener(null);
                                            RotatingTextWrapper.this.setChanges(switcher, toChange);
                                        }
                                    }
                                });
                            }
                        }
                    });
                } else if (toChange.getCurrentWord().equals(toDeleteWord) && !switcher.animationInterface.isAnimationRunning()) {
                    toChange.setTextAt(wordIndex, newWord);
                    switcher.animationInterface.setAnimationListener(new AnimationInterface.AnimationListener(){

                        @Override
                        public void onAnimationValueChanged(boolean newValue) {
                            if (!switcher.animationInterface.isAnimationRunning()) {
                                switcher.animationInterface.setAnimationListener(null);
                                RotatingTextWrapper.this.setChanges(switcher, toChange);
                            }
                        }
                    });
                } else if (toChange.getPreviousWord().equals(toDeleteWord)) {
                    toChange.setTextAt(wordIndex, newWord);
                    if (!switcher.animationInterface.isAnimationRunning()) {
                        this.setChanges(switcher, toChange);
                    } else {
                        switcher.animationInterface.setAnimationListener(new AnimationInterface.AnimationListener(){

                            @Override
                            public void onAnimationValueChanged(boolean newValue) {
                                switcher.animationInterface.setAnimationListener(null);
                                RotatingTextWrapper.this.setChanges(switcher, toChange);
                            }
                        });
                    }
                } else {
                    toChange.setTextAt(wordIndex, newWord);
                    this.setChanges(switcher, toChange);
                }
            } else {
                toChange.setTextAt(wordIndex, newWord);
                switcher.setText(toChange.getLargestWordWithSpace());
                if (this.adaptable && finalSize != originalSize) {
                    int actualPixel = this.findRequiredPixel();
                    if (this.adaptable && actualPixel > this.availablePixels()) {
                        this.reduceSize((double)actualPixel / (double)this.availablePixels());
                    }
                }
            }
        }
    }

    private Paint getPaint(Rotatable toChange) {
        Paint paint = new Paint();
        paint.setTextSize(toChange.getSize() * this.getContext().getResources().getDisplayMetrics().density);
        paint.setTypeface(toChange.getTypeface());
        paint.setColor(-16777216);
        paint.setStyle(Paint.Style.FILL);
        return paint;
    }

    public void addWord(int rotatableIndex, int wordIndex, String newWord) {
        if (!TextUtils.isEmpty((CharSequence)newWord) && !newWord.contains("\n")) {
            RotatingTextSwitcher switcher = this.switcherList.get(rotatableIndex);
            Rotatable toChange = this.rotatableList.get(rotatableIndex);
            Paint paint = this.getPaint(toChange);
            Rect result = new Rect();
            paint.getTextBounds(toChange.getLargestWord(), 0, toChange.getLargestWord().length(), result);
            double originalSize = result.width();
            result = new Rect();
            paint.getTextBounds(toChange.peekLargestAddWord(wordIndex, newWord), 0, toChange.peekLargestAddWord(wordIndex, newWord).length(), result);
            double finalSize = result.width();
            toChange.addTextAt(wordIndex, newWord);
            switcher.setText(toChange.getLargestWordWithSpace());
            if (this.adaptable && finalSize != originalSize) {
                int actualPixel = this.findRequiredPixel();
                if (this.adaptable && actualPixel > this.availablePixels()) {
                    this.reduceSize((double)actualPixel / (double)this.availablePixels());
                }
            }
        }
    }

    private void setChanges(RotatingTextSwitcher switcher, Rotatable toChange) {
        switcher.setText(toChange.getLargestWordWithSpace());
        if (this.adaptable && this.getSize() != (int)this.changedSize && this.changedSize != 0.0) {
            if ((double)this.availablePixels() / (double)this.findRequiredPixel() < (double)this.getSize() / this.changedSize) {
                this.reduceSize((double)this.findRequiredPixel() / (double)this.availablePixels());
            } else {
                this.reduceSize(this.changedSize / (double)this.getSize());
            }
        }
    }

    private int availablePixels() {
        View parent = (View)this.getParent();
        return parent.getMeasuredWidth() - parent.getPaddingLeft() - parent.getPaddingRight();
    }

    private int findRequiredPixel() {
        int actualPixel = 0;
        for (RotatingTextSwitcher switcher : this.switcherList) {
            switcher.measure(0, 0);
            actualPixel += switcher.getMeasuredWidth();
        }
        for (TextView id : this.textViews) {
            id.measure(0, 0);
            actualPixel += id.getMeasuredWidth();
        }
        ViewGroup.MarginLayoutParams margins = (ViewGroup.MarginLayoutParams)ViewGroup.MarginLayoutParams.class.cast(this.getLayoutParams());
        actualPixel += margins.leftMargin;
        actualPixel += margins.rightMargin;
        actualPixel += this.getPaddingLeft();
        return actualPixel += this.getPaddingRight();
    }

    public void reduceSize(double factor) {
        double initialSizeWrapper = this.changedSize == 0.0 ? (double)this.getSize() : this.changedSize;
        double newWrapperSize = initialSizeWrapper / factor;
        for (RotatingTextSwitcher switcher : this.switcherList) {
            double initialSizeRotatable = switcher.getTextSize();
            double newRotatableSize = initialSizeRotatable / factor;
            switcher.setTextSize(0, (float)newRotatableSize);
        }
        for (TextView id : this.textViews) {
            id.setTextSize((float)newWrapperSize);
        }
        ViewGroup.MarginLayoutParams margins = (ViewGroup.MarginLayoutParams)ViewGroup.MarginLayoutParams.class.cast(this.getLayoutParams());
        margins.leftMargin = (int)((double)margins.leftMargin / factor);
        margins.rightMargin = (int)((double)margins.rightMargin / factor);
        int paddingLeft = this.getPaddingLeft();
        int paddingRight = this.getPaddingRight();
        if (paddingLeft != 0) {
            if (paddingRight == 0) {
                this.setPadding((int)((double)paddingLeft / factor), 0, 0, 0);
            } else {
                this.setPadding((int)((double)paddingLeft / factor), 0, (int)((double)paddingRight / factor), 0);
            }
        } else if (paddingRight != 0) {
            this.setPadding(0, 0, (int)((double)paddingRight / factor), 0);
        }
        double d = this.changedSize = this.changedSize == 0.0 ? (double)this.getSize() / factor : this.changedSize / factor;
        if (this.adaptable && this.findRequiredPixel() > this.availablePixels()) {
            this.reduceSize((double)this.findRequiredPixel() / (double)this.availablePixels());
        }
    }

    public void setAdaptable(boolean adaptable) {
        this.adaptable = adaptable;
    }

    public Typeface getTypeface() {
        return this.typeface;
    }

    public void setTypeface(Typeface typeface) {
        this.typeface = typeface;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public void pause(int position) {
        this.switcherList.get(position).pause();
    }

    public void resume(int position) {
        this.switcherList.get(position).resume();
    }

    public List<RotatingTextSwitcher> getSwitcherList() {
        return this.switcherList;
    }
}

