/*
 * Decompiled with CFR 0.152.
 */
package com.sdsmdg.harjot.rotatingtext;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.app.Activity;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.widget.TextView;
import com.sdsmdg.harjot.rotatingtext.AnimationInterface;
import com.sdsmdg.harjot.rotatingtext.models.Rotatable;
import io.reactivex.Observable;
import io.reactivex.Scheduler;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Consumer;
import io.reactivex.schedulers.Schedulers;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;

public class RotatingTextSwitcher
extends TextView {
    private Context context;
    private Rotatable rotatable;
    private Paint paint;
    private float density;
    private boolean isRotatableSet = false;
    private Path pathIn;
    private Path pathOut;
    private Timer updateWordTimer;
    private Disposable disposable;
    private String currentText = "";
    private String oldText = "";
    AnimationInterface animationInterface = new AnimationInterface(false);
    private boolean isPaused = false;

    public RotatingTextSwitcher(Context context) {
        super(context);
        this.context = context;
    }

    public void setRotatable(Rotatable rotatable) {
        this.rotatable = rotatable;
        this.isRotatableSet = true;
        this.init();
    }

    private void init() {
        this.paint = this.getPaint();
        this.density = this.getContext().getResources().getDisplayMetrics().density;
        this.paint.setAntiAlias(true);
        this.paint.setTextSize(this.rotatable.getSize() * this.density);
        this.paint.setColor(this.rotatable.getColor());
        if (this.rotatable.isCenter()) {
            this.paint.setTextAlign(Paint.Align.CENTER);
        }
        if (this.rotatable.getTypeface() != null) {
            this.paint.setTypeface(this.rotatable.getTypeface());
        }
        this.setText(this.rotatable.getLargestWordWithSpace());
        this.oldText = this.currentText = this.rotatable.getNextWord();
        this.post(new Runnable(){

            @Override
            public void run() {
                RotatingTextSwitcher.this.pathIn = new Path();
                RotatingTextSwitcher.this.pathIn.moveTo(0.0f, (float)RotatingTextSwitcher.this.getHeight() - ((RotatingTextSwitcher)RotatingTextSwitcher.this).paint.getFontMetrics().bottom);
                RotatingTextSwitcher.this.pathIn.lineTo((float)RotatingTextSwitcher.this.getWidth(), (float)RotatingTextSwitcher.this.getHeight() - ((RotatingTextSwitcher)RotatingTextSwitcher.this).paint.getFontMetrics().bottom);
                RotatingTextSwitcher.this.rotatable.setPathIn(RotatingTextSwitcher.this.pathIn);
                RotatingTextSwitcher.this.pathOut = new Path();
                RotatingTextSwitcher.this.pathOut.moveTo(0.0f, (float)(2 * RotatingTextSwitcher.this.getHeight()) - ((RotatingTextSwitcher)RotatingTextSwitcher.this).paint.getFontMetrics().bottom);
                RotatingTextSwitcher.this.pathOut.lineTo((float)RotatingTextSwitcher.this.getWidth(), (float)(2 * RotatingTextSwitcher.this.getHeight()) - ((RotatingTextSwitcher)RotatingTextSwitcher.this).paint.getFontMetrics().bottom);
                RotatingTextSwitcher.this.rotatable.setPathOut(RotatingTextSwitcher.this.pathOut);
            }
        });
        if (this.disposable == null) {
            this.disposable = Observable.interval((long)(1000 / this.rotatable.getFPS()), (TimeUnit)TimeUnit.MILLISECONDS, (Scheduler)Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe((Consumer)new Consumer<Long>(){

                public void accept(Long aLong) throws Exception {
                    RotatingTextSwitcher.this.invalidate();
                }
            });
        }
        this.invalidate();
        this.updateWordTimer = new Timer();
        this.updateWordTimer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                ((Activity)RotatingTextSwitcher.this.context).runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        if (RotatingTextSwitcher.this.isPaused) {
                            RotatingTextSwitcher.this.pauseRender();
                        } else {
                            RotatingTextSwitcher.this.animationInterface.setAnimationRunning(true);
                            RotatingTextSwitcher.this.resumeRender();
                            RotatingTextSwitcher.this.animateInHorizontal();
                            RotatingTextSwitcher.this.animateOutHorizontal();
                            RotatingTextSwitcher.this.oldText = RotatingTextSwitcher.this.currentText;
                            RotatingTextSwitcher.this.currentText = RotatingTextSwitcher.this.rotatable.getNextWord();
                        }
                    }
                });
            }
        }, this.rotatable.getUpdateDuration(), (long)this.rotatable.getUpdateDuration());
    }

    protected void onDraw(Canvas canvas) {
        if (this.isRotatableSet) {
            if (this.rotatable.isUpdated()) {
                this.updatePaint();
                this.rotatable.setUpdated(false);
            }
            String text = this.currentText;
            int number = this.rotatable.getCurrentWordNumber();
            int arrayLength = this.rotatable.colorArraySize();
            if (this.rotatable.getPathIn() != null) {
                canvas.drawTextOnPath(text, this.rotatable.getPathIn(), 0.0f, 0.0f, this.paint);
                if (this.rotatable.useArray()) {
                    if (number < arrayLength && number > 0) {
                        this.paint.setColor(this.rotatable.getColorFromArray(number - 1));
                    } else {
                        this.paint.setColor(this.rotatable.getColorFromArray(arrayLength - 1));
                    }
                }
                if (this.rotatable.getPathOut() != null) {
                    canvas.drawTextOnPath(this.oldText, this.rotatable.getPathOut(), 0.0f, 0.0f, this.paint);
                    if (number < arrayLength && this.rotatable.useArray()) {
                        this.paint.setColor(this.rotatable.getColorFromArray(number));
                    }
                }
            }
        }
    }

    private void animateInHorizontal() {
        ValueAnimator animator;
        if (!this.rotatable.getApplyHorizontal()) {
            animator = ValueAnimator.ofFloat((float[])new float[]{0.0f, this.getHeight()});
            animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator valueAnimator) {
                    RotatingTextSwitcher.this.pathIn = new Path();
                    RotatingTextSwitcher.this.pathIn.moveTo(0.0f, ((Float)valueAnimator.getAnimatedValue()).floatValue() - ((RotatingTextSwitcher)RotatingTextSwitcher.this).paint.getFontMetrics().bottom);
                    RotatingTextSwitcher.this.pathIn.lineTo((float)RotatingTextSwitcher.this.getWidth(), ((Float)valueAnimator.getAnimatedValue()).floatValue() - ((RotatingTextSwitcher)RotatingTextSwitcher.this).paint.getFontMetrics().bottom);
                    RotatingTextSwitcher.this.rotatable.setPathIn(RotatingTextSwitcher.this.pathIn);
                }
            });
        } else {
            animator = ValueAnimator.ofFloat((float[])new float[]{-this.getWidth(), 0.0f});
            animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator valueAnimator) {
                    RotatingTextSwitcher.this.pathIn = new Path();
                    RotatingTextSwitcher.this.pathIn.moveTo(((Float)valueAnimator.getAnimatedValue()).floatValue(), (float)(2 * RotatingTextSwitcher.this.getHeight()) / 3.0f);
                    RotatingTextSwitcher.this.pathIn.lineTo(((Float)valueAnimator.getAnimatedValue()).floatValue() + (float)RotatingTextSwitcher.this.getWidth(), (float)(2 * RotatingTextSwitcher.this.getHeight()) / 3.0f);
                    RotatingTextSwitcher.this.rotatable.setPathIn(RotatingTextSwitcher.this.pathIn);
                }
            });
        }
        animator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                RotatingTextSwitcher.this.animationInterface.setAnimationRunning(false);
            }
        });
        animator.setInterpolator((TimeInterpolator)this.rotatable.getInterpolator());
        animator.setDuration((long)this.rotatable.getAnimationDuration());
        animator.start();
    }

    private void animateOutHorizontal() {
        ValueAnimator animator;
        if (!this.rotatable.getApplyHorizontal()) {
            animator = ValueAnimator.ofFloat((float[])new float[]{this.getHeight(), (float)this.getHeight() * 2.0f});
            animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator valueAnimator) {
                    RotatingTextSwitcher.this.pathOut = new Path();
                    RotatingTextSwitcher.this.pathOut.moveTo(0.0f, ((Float)valueAnimator.getAnimatedValue()).floatValue() - ((RotatingTextSwitcher)RotatingTextSwitcher.this).paint.getFontMetrics().bottom);
                    RotatingTextSwitcher.this.pathOut.lineTo((float)RotatingTextSwitcher.this.getWidth(), ((Float)valueAnimator.getAnimatedValue()).floatValue() - ((RotatingTextSwitcher)RotatingTextSwitcher.this).paint.getFontMetrics().bottom);
                    RotatingTextSwitcher.this.rotatable.setPathOut(RotatingTextSwitcher.this.pathOut);
                }
            });
        } else {
            animator = ValueAnimator.ofFloat((float[])new float[]{0.0f, (float)this.getWidth() + 10.0f});
            animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator valueAnimator) {
                    RotatingTextSwitcher.this.pathOut = new Path();
                    RotatingTextSwitcher.this.pathOut.moveTo(((Float)valueAnimator.getAnimatedValue()).floatValue(), (float)(2 * RotatingTextSwitcher.this.getHeight()) / 3.0f);
                    RotatingTextSwitcher.this.pathOut.lineTo(((Float)valueAnimator.getAnimatedValue()).floatValue() + (float)RotatingTextSwitcher.this.getWidth(), (float)(2 * RotatingTextSwitcher.this.getHeight()) / 3.0f);
                    RotatingTextSwitcher.this.rotatable.setPathOut(RotatingTextSwitcher.this.pathOut);
                }
            });
        }
        animator.setInterpolator((TimeInterpolator)this.rotatable.getInterpolator());
        animator.setDuration((long)this.rotatable.getAnimationDuration());
        animator.start();
    }

    private void animateInCurve() {
        final int stringLength = this.rotatable.peekNextWord().length();
        final float[] yValues = new float[stringLength];
        for (int i = 0; i < stringLength; ++i) {
            yValues[i] = 0.0f;
        }
        ValueAnimator animator = ValueAnimator.ofFloat((float[])new float[]{0.0f, this.getHeight()});
        animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator valueAnimator) {
                int i;
                yValues[0] = ((Float)valueAnimator.getAnimatedValue()).floatValue() - ((RotatingTextSwitcher)RotatingTextSwitcher.this).paint.getFontMetrics().bottom;
                for (i = 1; i < stringLength; ++i) {
                    if (!(valueAnimator.getAnimatedFraction() > (float)i / (float)stringLength)) continue;
                    yValues[i] = (valueAnimator.getAnimatedFraction() - (float)i / (float)stringLength) * yValues[0];
                }
                RotatingTextSwitcher.this.pathIn = new Path();
                RotatingTextSwitcher.this.pathIn.moveTo(0.0f, yValues[0]);
                for (i = 1; i < stringLength; ++i) {
                    RotatingTextSwitcher.this.pathIn.lineTo((float)RotatingTextSwitcher.this.getWidth() * ((float)i / (float)stringLength), yValues[i]);
                    RotatingTextSwitcher.this.pathIn.moveTo((float)RotatingTextSwitcher.this.getWidth() * ((float)i / (float)stringLength), yValues[i]);
                }
                RotatingTextSwitcher.this.rotatable.setPathIn(RotatingTextSwitcher.this.pathIn);
            }
        });
        animator.setInterpolator((TimeInterpolator)this.rotatable.getInterpolator());
        animator.setDuration((long)this.rotatable.getAnimationDuration());
        animator.start();
    }

    private void animateOutCurve() {
        final int stringLength = this.getText().length();
        final float[] yValues = new float[stringLength];
        for (int i = 0; i < stringLength; ++i) {
            yValues[i] = this.getHeight();
        }
        ValueAnimator animator = ValueAnimator.ofFloat((float[])new float[]{this.getHeight(), 2 * this.getHeight()});
        animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator valueAnimator) {
                int i;
                yValues[0] = ((Float)valueAnimator.getAnimatedValue()).floatValue() - ((RotatingTextSwitcher)RotatingTextSwitcher.this).paint.getFontMetrics().bottom;
                for (i = 1; i < stringLength; ++i) {
                    if (!(valueAnimator.getAnimatedFraction() > (float)i / (float)stringLength)) continue;
                    yValues[i] = (valueAnimator.getAnimatedFraction() - (float)i / (float)stringLength) * yValues[0];
                }
                RotatingTextSwitcher.this.pathIn = new Path();
                RotatingTextSwitcher.this.pathIn.moveTo(0.0f, yValues[0]);
                for (i = 1; i < stringLength; ++i) {
                    RotatingTextSwitcher.this.pathIn.lineTo((float)RotatingTextSwitcher.this.getWidth() * ((float)i / (float)stringLength), yValues[i]);
                    RotatingTextSwitcher.this.pathIn.moveTo((float)RotatingTextSwitcher.this.getWidth() * ((float)i / (float)stringLength), yValues[i]);
                }
                RotatingTextSwitcher.this.rotatable.setPathIn(RotatingTextSwitcher.this.pathIn);
            }
        });
        animator.setInterpolator((TimeInterpolator)this.rotatable.getInterpolator());
        animator.setDuration((long)this.rotatable.getAnimationDuration());
        animator.start();
    }

    public void pause() {
        this.isPaused = true;
    }

    public void resume() {
        this.isPaused = false;
    }

    private void pauseRender() {
        if (this.disposable != null && !this.disposable.isDisposed()) {
            this.disposable.dispose();
            this.disposable = null;
        }
    }

    private void resumeRender() {
        if (this.disposable == null) {
            this.disposable = Observable.interval((long)(1000 / this.rotatable.getFPS()), (TimeUnit)TimeUnit.MILLISECONDS, (Scheduler)Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe((Consumer)new Consumer<Long>(){

                public void accept(Long aLong) throws Exception {
                    RotatingTextSwitcher.this.invalidate();
                }
            });
        }
    }

    private void updatePaint() {
        this.paint.setTextSize(this.rotatable.getSize() * this.density);
        this.paint.setColor(this.rotatable.getColor());
        if (this.rotatable.isCenter()) {
            this.paint.setTextAlign(Paint.Align.CENTER);
        }
        if (this.rotatable.getTypeface() != null) {
            this.paint.setTypeface(this.rotatable.getTypeface());
        }
        if (this.updateWordTimer != null) {
            this.updateWordTimer.cancel();
        }
        this.updateWordTimer = new Timer();
        this.updateWordTimer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                ((Activity)RotatingTextSwitcher.this.context).runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        if (RotatingTextSwitcher.this.isPaused) {
                            RotatingTextSwitcher.this.pauseRender();
                        } else {
                            if (RotatingTextSwitcher.this.currentText.equals(RotatingTextSwitcher.this.rotatable.getInitialWord()) && RotatingTextSwitcher.this.rotatable.getCycles() != 0) {
                                RotatingTextSwitcher.this.rotatable.countCycles(true);
                            }
                            if (RotatingTextSwitcher.this.rotatable.countCycles(false) >= RotatingTextSwitcher.this.rotatable.getCycles() + 1 && RotatingTextSwitcher.this.rotatable.getCycles() != 0) {
                                RotatingTextSwitcher.this.rotatable.setCycles(0);
                                RotatingTextSwitcher.this.isPaused = true;
                                RotatingTextSwitcher.this.pauseRender();
                            } else {
                                RotatingTextSwitcher.this.oldText = RotatingTextSwitcher.this.currentText;
                                RotatingTextSwitcher.this.currentText = RotatingTextSwitcher.this.rotatable.getNextWord();
                                RotatingTextSwitcher.this.animationInterface.setAnimationRunning(true);
                                RotatingTextSwitcher.this.resumeRender();
                                RotatingTextSwitcher.this.animateInHorizontal();
                                RotatingTextSwitcher.this.animateOutHorizontal();
                            }
                        }
                    }
                });
            }
        }, this.rotatable.getUpdateDuration(), (long)this.rotatable.getUpdateDuration());
    }

    public boolean isPaused() {
        return this.isPaused;
    }
}

